/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model;

import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.model.BasicStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.DefaultCaseExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.ICaseExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.IJPQLQueryBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.query.JPQLQueryStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;

public abstract class AbstractJPQLQueryBuilder
implements IJPQLQueryBuilder {
    private BasicStateObjectBuilder builder;

    protected AbstractJPQLQueryBuilder() {
    }

    @Override
    public ICaseExpressionStateObjectBuilder buildCaseExpressionStateObjectBuilder(StateObject parent) {
        return new DefaultCaseExpressionStateObjectBuilder(parent);
    }

    @Override
    public JPQLQueryStateObject buildStateObject(IManagedTypeProvider provider, CharSequence jpqlQuery, boolean tolerant) {
        return this.buildStateObject(provider, jpqlQuery, "ql_statement", tolerant);
    }

    @Override
    public JPQLQueryStateObject buildStateObject(IManagedTypeProvider provider, CharSequence jpqlQuery, String queryBNFId, boolean tolerant) {
        JPQLExpression jpqlExpression = this.parse(jpqlQuery, this.getGrammar(), tolerant);
        BasicStateObjectBuilder builder = this.getStateObjectBuilder();
        try {
            builder.jpqlQueryBuilder = this;
            builder.managedTypeProvider = provider;
            jpqlExpression.accept(this.wrap(builder));
            JPQLQueryStateObject jPQLQueryStateObject = builder.parent;
            return jPQLQueryStateObject;
        }
        finally {
            builder.jpqlQueryBuilder = null;
            builder.managedTypeProvider = null;
            builder.parent = null;
            builder.stateObject = null;
        }
    }

    @Override
    public StateObject buildStateObject(StateObject parent, CharSequence jpqlFragment, String queryBNFId) {
        JPQLExpression jpqlExpression = this.parse(jpqlFragment, parent.getGrammar(), queryBNFId);
        BasicStateObjectBuilder builder = this.getStateObjectBuilder();
        IJPQLQueryBuilder oldBuilder = builder.jpqlQueryBuilder;
        IManagedTypeProvider oldProvider = builder.managedTypeProvider;
        JPQLQueryStateObject oldParent = builder.parent;
        StateObject oldStateObject = builder.stateObject;
        try {
            builder.jpqlQueryBuilder = this;
            builder.managedTypeProvider = parent.getManagedTypeProvider();
            builder.parent = parent.getRoot();
            builder.stateObject = parent;
            jpqlExpression.getQueryStatement().accept(this.wrap(builder));
            StateObject stateObject = builder.stateObject;
            return stateObject;
        }
        finally {
            builder.jpqlQueryBuilder = oldBuilder;
            builder.managedTypeProvider = oldProvider;
            builder.parent = oldParent;
            builder.stateObject = oldStateObject;
        }
    }

    protected abstract BasicStateObjectBuilder buildStateObjectBuilder();

    protected final BasicStateObjectBuilder getStateObjectBuilder() {
        if (this.builder == null) {
            this.builder = this.buildStateObjectBuilder();
        }
        return this.builder;
    }

    protected JPQLExpression parse(CharSequence jpqlQuery, JPQLGrammar jpqlGrammar, boolean tolerant) {
        return new JPQLExpression(jpqlQuery, jpqlGrammar, tolerant);
    }

    protected JPQLExpression parse(CharSequence jpqFragment, JPQLGrammar jpqlGrammar, String queryBNFId) {
        return new JPQLExpression(jpqFragment, jpqlGrammar, queryBNFId, true);
    }

    protected ExpressionVisitor wrap(BasicStateObjectBuilder builder) {
        return builder;
    }
}

