/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleProcessorBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTask;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.RecycleUtils;

public abstract class ViewLifecyclePhaseBase
implements ViewLifecyclePhase {
    private final Logger LOG = LogManager.getLogger(ViewLifecyclePhaseBase.class);
    private LifecycleElement element;
    private Component parent;
    private String viewPath;
    private String path;
    private int depth;
    private List<String> refreshPaths;
    private ViewLifecyclePhase predecessor;
    private ViewLifecyclePhase nextPhase;
    private boolean processed;
    private boolean completed;
    private HashSet<String> pendingSuccessors = new LinkedHashSet<String>();
    private ViewLifecycleTask<?> currentTask;
    private List<ViewLifecycleTask<?>> tasks;
    private List<ViewLifecycleTask<?>> skipLifecycleTasks;

    @Override
    public void recycle() {
        this.trace("recycle");
        this.element = null;
        this.path = null;
        this.viewPath = null;
        this.depth = 0;
        this.predecessor = null;
        this.nextPhase = null;
        this.processed = false;
        this.completed = false;
        this.refreshPaths = null;
        this.pendingSuccessors = new LinkedHashSet<String>();
    }

    @Override
    public void prepare(LifecycleElement element, Component parent, String parentPath, List<String> refreshPaths) {
        this.path = parentPath;
        String parentViewPath = parent == null ? null : parent.getViewPath();
        this.viewPath = StringUtils.isEmpty((String)parentViewPath) ? this.path : parentViewPath + "." + this.path;
        this.element = CopyUtils.unwrap(element);
        this.parent = parent;
        this.refreshPaths = refreshPaths;
        this.trace("prepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            ViewLifecycleProcessorBase processor = (ViewLifecycleProcessorBase)ViewLifecycle.getProcessor();
            this.validateBeforeProcessing();
            boolean skipLifecycle = this.shouldSkipLifecycle();
            String ntracePrefix = null;
            String ntraceSuffix = null;
            try {
                String viewStatus;
                if (ViewLifecycle.isTrace() && ProcessLogger.isTraceActive()) {
                    ntracePrefix = "lc-" + this.getStartViewStatus() + "-" + this.getEndViewStatus() + ":";
                    ntraceSuffix = ":" + this.getElement().getClass().getSimpleName() + (this.getElement().isRender() ? ":render" : ":no-render");
                    ProcessLogger.ntrace(ntracePrefix, ntraceSuffix, 1000L);
                    ProcessLogger.countBegin(ntracePrefix + ntraceSuffix);
                }
                if ((viewStatus = this.element.getViewStatus()) != null && !viewStatus.equals(this.getStartViewStatus())) {
                    this.trace("dup " + this.getStartViewStatus() + " " + this.getEndViewStatus() + " " + viewStatus);
                }
                processor.setActivePhase(this);
                this.trace("path-update " + this.element.getViewPath());
                this.element.setViewPath(this.getViewPath());
                this.element.getPhasePathMapping().put(this.getViewPhase(), this.getViewPath());
                List<ViewLifecycleTask<?>> pendingTasks = skipLifecycle ? this.skipLifecycleTasks : this.tasks;
                StringBuilder trace = ViewLifecycle.isTrace() && this.LOG.isDebugEnabled() ? new StringBuilder("Tasks") : null;
                for (ViewLifecycleTask<?> task : pendingTasks) {
                    if (trace != null) {
                        trace.append("\n  ").append(task);
                    }
                    if (!task.getElementType().isInstance(this.element)) {
                        if (trace == null) continue;
                        trace.append(" skip");
                        continue;
                    }
                    if (trace != null) {
                        trace.append(" run");
                    }
                    this.currentTask = task;
                    task.run();
                    this.currentTask = null;
                }
                if (trace != null) {
                    this.LOG.debug(trace.toString());
                }
                this.element.setViewStatus(this.getEndViewStatus());
                this.processed = true;
                processor.setActivePhase(null);
            }
            catch (Throwable throwable) {
                processor.setActivePhase(null);
                if (ViewLifecycle.isTrace() && ProcessLogger.isTraceActive()) {
                    ProcessLogger.countEnd(ntracePrefix + ntraceSuffix, this.getElement().getClass() + " " + this.getElement().getId());
                }
                throw throwable;
            }
            if (ViewLifecycle.isTrace() && ProcessLogger.isTraceActive()) {
                ProcessLogger.countEnd(ntracePrefix + ntraceSuffix, this.getElement().getClass() + " " + this.getElement().getId());
            }
            if (skipLifecycle) {
                this.notifyCompleted();
            } else {
                assert (this.pendingSuccessors.isEmpty()) : this.pendingSuccessors;
                LinkedList<ViewLifecyclePhase> successors = new LinkedList<ViewLifecyclePhase>();
                this.initializeSuccessors(successors);
                this.processSuccessors(successors);
            }
        }
        catch (Throwable t) {
            this.trace("error");
            this.LOG.warn("Error in lifecycle phase " + this, t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException("Unexpected error in lifecycle phase " + this, t);
        }
    }

    protected boolean shouldSkipLifecycle() {
        if (StringUtils.isBlank((String)this.getViewPath())) {
            return false;
        }
        boolean isPreProcessPhase = this.getViewPhase().equals("PRE_PROCESS");
        boolean isRefreshComponent = ViewLifecycle.isRefreshComponent(this.getViewPhase(), this.getViewPath());
        boolean includesRefreshComponent = false;
        if (StringUtils.isNotBlank((String)ViewLifecycle.getRefreshComponentPhasePath(this.getViewPhase()))) {
            includesRefreshComponent = ViewLifecycle.getRefreshComponentPhasePath(this.getViewPhase()).startsWith(this.getViewPath());
        }
        boolean skipLifecycle = false;
        if (!(isPreProcessPhase || isRefreshComponent || includesRefreshComponent)) {
            skipLifecycle = this.element.skipLifecycle();
        }
        return skipLifecycle;
    }

    protected void validateBeforeProcessing() {
        if (this.processed) {
            throw new IllegalStateException("Lifecycle phase has already been processed " + this);
        }
        if (this.predecessor != null && !this.predecessor.isProcessed()) {
            throw new IllegalStateException("Predecessor phase has not completely processed " + this);
        }
        if (!ViewLifecycle.isActive()) {
            throw new IllegalStateException("No view lifecyle is not active on the current thread");
        }
        if (this.LOG.isDebugEnabled()) {
            this.trace("ready " + this.getStartViewStatus() + " -> " + this.getEndViewStatus());
        }
    }

    protected void processSuccessors(Queue<ViewLifecyclePhase> successors) {
        for (ViewLifecyclePhase successor : successors) {
            if (this.pendingSuccessors.add(successor.getParentPath())) continue;
            ViewLifecycle.reportIllegalState("Already pending " + successor + "\n" + this);
        }
        this.trace("processed " + this.pendingSuccessors);
        if (this.pendingSuccessors.isEmpty()) {
            this.notifyCompleted();
        } else {
            for (ViewLifecyclePhase successor : successors) {
                assert (successor.getPredecessor() == null) : this + " " + successor;
                successor.setPredecessor(this);
                if (successor instanceof ViewLifecyclePhaseBase) {
                    ((ViewLifecyclePhaseBase)successor).trace("succ-pend");
                }
                ViewLifecycle.getProcessor().offerPendingPhase(successor);
            }
        }
    }

    @Override
    public void setNextPhase(ViewLifecyclePhase nextPhase) {
        if (this.nextPhase != null) {
            throw new IllegalStateException("Next phase is already set " + nextPhase + "\n" + this);
        }
        if (nextPhase == null || !this.getEndViewStatus().equals(nextPhase.getStartViewStatus())) {
            throw new IllegalStateException("Next phase is invalid for end phase " + this.getEndViewStatus() + " found " + nextPhase.getStartViewStatus());
        }
        this.nextPhase = nextPhase;
        this.trace("next-phase");
    }

    public void setTasks(List<ViewLifecycleTask<?>> tasks) {
        for (ViewLifecycleTask<?> task : tasks) {
            assert (task.getElementState() == null) : task.getElementState() + "\n" + this;
            task.setElementState(this);
        }
        this.tasks = tasks;
    }

    public void setSkipLifecycleTasks(List<ViewLifecycleTask<?>> skipLifecycleTasks) {
        for (ViewLifecycleTask<?> task : skipLifecycleTasks) {
            assert (task.getElementState() == null) : task.getElementState() + "\n" + this;
            task.setElementState(this);
        }
        this.skipLifecycleTasks = skipLifecycleTasks;
    }

    protected void initializeSuccessors(Queue<ViewLifecyclePhase> successors) {
        if (ViewLifecycle.isRefreshLifecycle() && this.refreshPaths != null) {
            String currentPath = this.getViewPath();
            boolean withinRefreshComponent = currentPath.startsWith(ViewLifecycle.getRefreshComponentPhasePath(this.getViewPhase()));
            if (withinRefreshComponent) {
                this.initializeAllLifecycleSuccessors(successors);
            } else if (this.refreshPaths.contains(currentPath) || StringUtils.isBlank((String)currentPath)) {
                this.initializeRefreshPathSuccessors(successors);
            }
            return;
        }
        this.initializeAllLifecycleSuccessors(successors);
    }

    @Override
    public void setRefreshPaths(List<String> refreshPaths) {
        this.refreshPaths = refreshPaths;
    }

    @Override
    public List<String> getRefreshPaths() {
        return this.refreshPaths;
    }

    protected void initializeRefreshPathSuccessors(Queue<ViewLifecyclePhase> successors) {
        Object nestedPathPrefix;
        Component nestedParent;
        LifecycleElement element = this.getElement();
        if (element instanceof Component) {
            nestedParent = (Component)element;
            nestedPathPrefix = "";
        } else {
            nestedParent = this.getParent();
            nestedPathPrefix = this.getParentPath() + ".";
        }
        List<String> nestedProperties = this.getNestedPropertiesForRefreshPath();
        for (String nestedProperty : nestedProperties) {
            String nestedPath = (String)nestedPathPrefix + nestedProperty;
            LifecycleElement nestedElement = (LifecycleElement)ObjectPropertyUtils.getPropertyValue(element, nestedProperty);
            if (nestedElement == null) continue;
            ViewLifecyclePhase nestedPhase = this.initializeSuccessor(nestedElement, nestedPath, nestedParent);
            successors.add(nestedPhase);
        }
    }

    protected List<String> getNestedPropertiesForRefreshPath() {
        ArrayList<String> nestedProperties = new ArrayList<String>();
        Object currentPath = this.getViewPath();
        if (currentPath == null) {
            currentPath = "";
        }
        if (StringUtils.isNotBlank((String)currentPath)) {
            currentPath = (String)currentPath + ".";
        }
        for (String refreshPath : this.refreshPaths) {
            String nestedProperty;
            if (!refreshPath.startsWith((String)currentPath) || StringUtils.isBlank((String)(nestedProperty = StringUtils.substringAfter((String)refreshPath, (String)currentPath)))) continue;
            if (StringUtils.contains((String)nestedProperty, (String)".")) {
                nestedProperty = StringUtils.substringBefore((String)nestedProperty, (String)".");
            }
            if (nestedProperties.contains(nestedProperty)) continue;
            nestedProperties.add(nestedProperty);
        }
        return nestedProperties;
    }

    protected void initializeAllLifecycleSuccessors(Queue<ViewLifecyclePhase> successors) {
        Object nestedPathPrefix;
        Component nestedParent;
        LifecycleElement element = this.getElement();
        if (element instanceof Component) {
            nestedParent = (Component)element;
            nestedPathPrefix = "";
        } else {
            nestedParent = this.getParent();
            nestedPathPrefix = this.getParentPath() + ".";
        }
        for (Map.Entry<String, LifecycleElement> nestedElementEntry : ViewLifecycleUtils.getElementsForLifecycle(element, this.getViewPhase()).entrySet()) {
            String nestedPath = (String)nestedPathPrefix + nestedElementEntry.getKey();
            LifecycleElement nestedElement = nestedElementEntry.getValue();
            if (nestedElement == null || this.getEndViewStatus().equals(nestedElement.getViewStatus())) continue;
            ViewLifecyclePhase nestedPhase = this.initializeSuccessor(nestedElement, nestedPath, nestedParent);
            successors.offer(nestedPhase);
        }
    }

    protected void verifyCompleted() {
    }

    protected ViewLifecyclePhase initializeSuccessor(LifecycleElement nestedElement, String nestedPath, Component nestedParent) {
        ViewLifecyclePhase successorPhase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase(this.getViewPhase(), nestedElement, nestedParent, nestedPath, this.refreshPaths);
        return successorPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyCompleted() {
        this.trace("complete");
        this.completed = true;
        ViewLifecycle.LifecycleEvent event = this.getEventToNotify();
        if (event != null) {
            ViewLifecycle.getActiveLifecycle().invokeEventListeners(event, ViewLifecycle.getView(), ViewLifecycle.getModel(), this.element);
        }
        this.element.notifyCompleted(this);
        if (this.nextPhase != null) {
            assert (this.nextPhase.getPredecessor() == null) : this + " " + this.nextPhase;
            if (this.predecessor != null) {
                this.nextPhase.setPredecessor(this.predecessor);
            } else {
                this.nextPhase.setPredecessor(this);
                HashSet<String> hashSet = this.pendingSuccessors;
                synchronized (hashSet) {
                    this.pendingSuccessors.add(this.nextPhase.getParentPath());
                }
            }
            ViewLifecycle.getProcessor().pushPendingPhase(this.nextPhase);
            return;
        }
        ViewLifecyclePhaseBase viewLifecyclePhaseBase = this;
        synchronized (viewLifecyclePhaseBase) {
            if (this.predecessor != null) {
                ViewLifecyclePhase viewLifecyclePhase = this.predecessor;
                synchronized (viewLifecyclePhase) {
                    this.predecessor.removePendingSuccessor(this.getParentPath());
                    if (!this.predecessor.hasPendingSuccessors()) {
                        this.predecessor.notifyCompleted();
                    }
                    this.recycle();
                    RecycleUtils.recycle(this.getViewPhase(), this, ViewLifecyclePhase.class);
                }
            } else {
                this.trace("notify");
                this.notifyAll();
            }
        }
    }

    @Override
    public final LifecycleElement getElement() {
        return this.element;
    }

    @Override
    public final Component getParent() {
        return this.parent;
    }

    @Override
    public String getParentPath() {
        return this.path;
    }

    @Override
    public String getViewPath() {
        return this.viewPath;
    }

    public void setViewPath(String viewPath) {
        this.viewPath = viewPath;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public final boolean isProcessed() {
        return this.processed;
    }

    @Override
    public final boolean isComplete() {
        return this.completed;
    }

    @Override
    public ViewLifecyclePhase getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void setPredecessor(ViewLifecyclePhase phase) {
        if (this.predecessor != null) {
            throw new IllegalStateException("Predecessor phase is already defined");
        }
        this.predecessor = phase;
    }

    @Override
    public ViewLifecycleTask<?> getCurrentTask() {
        return this.currentTask;
    }

    @Override
    public boolean hasPendingSuccessors() {
        return !this.pendingSuccessors.isEmpty();
    }

    @Override
    public void removePendingSuccessor(String parentPath) {
        if (!this.pendingSuccessors.remove(parentPath)) {
            throw new IllegalStateException("Not a pending successor: " + parentPath);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LinkedList<ViewLifecyclePhase> toPrint = new LinkedList<ViewLifecyclePhase>();
        toPrint.offer(this);
        while (!toPrint.isEmpty()) {
            ViewLifecyclePhase tpredecessor;
            String indent;
            ViewLifecyclePhase tp = (ViewLifecyclePhase)toPrint.poll();
            if (tp.getElement() == null) {
                sb.append("\n      ");
                sb.append(tp.getClass().getSimpleName());
                sb.append(" (recycled)");
                continue;
            }
            if (tp == this) {
                sb.append("\nProcessed? ");
                sb.append(this.processed);
                indent = "\n";
            } else {
                indent = "\n    ";
            }
            sb.append(indent);
            sb.append(tp.getClass().getSimpleName());
            sb.append(" ");
            sb.append(System.identityHashCode(tp));
            sb.append(" ");
            sb.append(tp.getViewPath());
            sb.append(" ");
            sb.append(tp.getElement().getClass().getSimpleName());
            sb.append(" ");
            sb.append(tp.getElement().getId());
            sb.append(" ");
            sb.append(this.pendingSuccessors);
            if (tp == this) {
                sb.append("\nPredecessor Phases:");
            }
            if ((tpredecessor = tp.getPredecessor()) == null) continue;
            toPrint.add(tpredecessor);
        }
        return sb.toString();
    }

    protected void trace(String step) {
        if (ViewLifecycle.isTrace() && this.LOG.isDebugEnabled()) {
            String msg = System.identityHashCode(this) + " " + this.getClass() + " " + step + " " + this.path + " " + (String)(this.element == null ? "(recycled)" : this.element.getClass() + " " + this.element.getId());
            this.LOG.debug(msg);
        }
    }
}

