/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.initialize;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.RemoteFieldsHolder;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.view.ViewModel;

public class ProcessRemoteFieldsHolderTask
extends ViewLifecycleTaskBase<Container> {
    public ProcessRemoteFieldsHolderTask() {
        super(Container.class);
    }

    @Override
    protected void performLifecycleTask() {
        Container container = (Container)this.getElementState().getElement();
        if (!container.isProcessRemoteFieldHolders()) {
            return;
        }
        ArrayList<Component> processedItems = new ArrayList<Component>();
        for (Component component : container.getItems()) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(container);
                processedItems.addAll(translatedFields);
                continue;
            }
            processedItems.add(component);
        }
        container.setItems(processedItems);
        ViewLifecycle.getHelper().addCustomContainerComponents((ViewModel)ViewLifecycle.getModel(), (Container)this.getElementState().getElement());
    }
}

