/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.constraint.BaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.WhenConstraint;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ConstraintStateUtils;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.DatePicker;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ClientValidationUtils {
    private static int methodKey = 0;
    private static List<List<String>> mustOccursPathNames;
    public static final String LABEL_KEY_SPLIT_PATTERN = ",";
    public static final String PREREQ_MSG_KEY = "prerequisite";
    public static final String POSTREQ_MSG_KEY = "postrequisite";
    public static final String MUSTOCCURS_MSG_KEY = "mustOccurs";
    public static final String MUSTOCCURS_MSG_EQUAL_KEY = "mustOccursEqualMinMax";
    public static final String GENERIC_FIELD_MSG_KEY = "general.genericFieldName";
    public static final String ALL_MSG_KEY = "general.all";
    public static final String ATMOST_MSG_KEY = "general.atMost";
    public static final String AND_MSG_KEY = "general.and";
    public static final String OR_MSG_KEY = "general.or";

    public static String generateMessageText(String namespace, String componentCode, String messageKey, List<String> params) {
        String message = "NO MESSAGE";
        if (StringUtils.isNotEmpty((String)messageKey)) {
            message = KRADServiceLocatorWeb.getMessageService().getMessageText(namespace, componentCode, messageKey);
            if (params != null && !params.isEmpty() && StringUtils.isNotEmpty((String)message)) {
                message = MessageFormat.format(message, params.toArray());
                message = MessageStructureUtils.translateStringMessage(message);
            }
        }
        if (StringUtils.isEmpty((String)message)) {
            message = messageKey;
        }
        message = KRADUtils.convertToHTMLAttributeSafeString(message);
        return message;
    }

    public static String generateValidatorMessagesOption() {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        Object mOption = "";
        Object keyValuePairs = "";
        for (ValidationMessageKeys element : EnumSet.allOf(ValidationMessageKeys.class)) {
            String key = element.toString();
            String message = messageService.getMessageText("validation." + key);
            if (!StringUtils.isNotEmpty((String)message)) continue;
            message = MessageStructureUtils.translateStringMessage(message);
            keyValuePairs = (String)keyValuePairs + "\n" + key + ": '" + message + "',";
        }
        if (StringUtils.isNotEmpty((String)(keyValuePairs = StringUtils.removeEnd((String)keyValuePairs, (String)LABEL_KEY_SPLIT_PATTERN)))) {
            mOption = "{" + (String)keyValuePairs + "}";
        }
        return mOption;
    }

    public static String getRegexMethod(InputField field, ValidCharactersConstraint validCharactersConstraint) {
        return ClientValidationUtils.getRegexMethod(field, validCharactersConstraint, true);
    }

    public static String getRegexMethod(InputField field, ValidCharactersConstraint validCharactersConstraint, boolean escape) {
        String message = ClientValidationUtils.generateMessageText(validCharactersConstraint.getMessageNamespaceCode(), validCharactersConstraint.getMessageComponentCode(), validCharactersConstraint.getMessageKey(), validCharactersConstraint.getValidationMessageParams());
        String key = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
        String regex = validCharactersConstraint.getValue();
        if (regex.contains("\\\\")) {
            regex = regex.replaceAll("\\\\", "\\\\\\\\");
        }
        if (regex.contains("/")) {
            regex = regex.replace("/", "\\/");
        }
        return "\njQuery.validator.addMethod(\"" + (String)(escape ? ScriptUtils.escapeName(key) : key) + "\", function(value, element) {\n return (this.optional(element) !== false) || /" + regex + "/.test(value);}, \"" + message + "\");";
    }

    public static String getRegexMethodWithBooleanCheck(InputField field, ValidCharactersConstraint validCharactersConstraint) {
        String message = ClientValidationUtils.generateMessageText(validCharactersConstraint.getMessageNamespaceCode(), validCharactersConstraint.getMessageComponentCode(), validCharactersConstraint.getMessageKey(), validCharactersConstraint.getValidationMessageParams());
        String key = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
        String regex = validCharactersConstraint.getValue();
        if (regex.contains("\\\\")) {
            regex = regex.replaceAll("\\\\", "\\\\\\\\");
        }
        if (regex.contains("/")) {
            regex = regex.replace("/", "\\/");
        }
        return "\njQuery.validator.addMethod(\"" + ScriptUtils.escapeName(key) + "\", function(value, element, doCheck) {\n if(doCheck === false){return true;}else{return (this.optional(element) !== false) || /" + regex + "/.test(value);}}, \"" + message + "\");";
    }

    public static void processCaseConstraint(InputField field, View view, CaseConstraint constraint, String andedCase, String validationState, StateMapping stateMapping) {
        if (constraint.getOperator() == null) {
            constraint.setOperator("equals");
        }
        String operator = "==";
        if (constraint.getOperator().equalsIgnoreCase("not_equals") || constraint.getOperator().equalsIgnoreCase("not_equal")) {
            operator = "!=";
        } else if (constraint.getOperator().equalsIgnoreCase("greater_than_equal")) {
            operator = ">=";
        } else if (constraint.getOperator().equalsIgnoreCase("less_than_equal")) {
            operator = "<=";
        } else if (constraint.getOperator().equalsIgnoreCase("greater_than")) {
            operator = ">";
        } else if (constraint.getOperator().equalsIgnoreCase("less_than")) {
            operator = "<";
        } else if (constraint.getOperator().equalsIgnoreCase("has_value")) {
            operator = "";
        }
        field.getControl().addStyleClass("dependsOn-" + ScriptUtils.escapeName(constraint.getPropertyName()));
        if (constraint.getWhenConstraint() != null && !constraint.getWhenConstraint().isEmpty()) {
            String fieldPath = constraint.getPropertyName();
            for (WhenConstraint wc : constraint.getWhenConstraint()) {
                if ((wc = ConstraintStateUtils.getApplicableConstraint(wc, validationState, stateMapping)) == null) continue;
                ClientValidationUtils.processWhenConstraint(field, view, constraint, wc, ScriptUtils.escapeName(fieldPath), operator, andedCase, validationState, stateMapping);
            }
        }
    }

    private static void processWhenConstraint(InputField field, View view, CaseConstraint caseConstraint, WhenConstraint wc, String fieldPath, String operator, String andedCase, String validationState, StateMapping stateMapping) {
        Constraint constraint;
        String ruleString = "";
        Object booleanStatement = "";
        if (wc.getValues() != null) {
            String caseStr = "";
            if (!caseConstraint.isCaseSensitive()) {
                caseStr = ".toUpperCase()";
            }
            for (int i = 0; i < wc.getValues().size(); ++i) {
                booleanStatement = operator.isEmpty() ? (wc.getValues().get(i) instanceof String && ((String)wc.getValues().get(i)).equalsIgnoreCase("false") ? (String)booleanStatement + "(coerceValue('" + fieldPath + "') == '')" : (String)booleanStatement + "(coerceValue('" + fieldPath + "') != '')") : (String)booleanStatement + "(coerceValue('" + fieldPath + "')" + caseStr + " " + operator + " \"" + wc.getValues().get(i) + "\"" + caseStr + ")";
                if (i + 1 == wc.getValues().size()) continue;
                booleanStatement = (String)booleanStatement + " || ";
            }
        }
        if (andedCase != null) {
            booleanStatement = "(" + (String)booleanStatement + ") && (" + andedCase + ")";
        }
        if (wc.getConstraint() != null && StringUtils.isNotEmpty((String)booleanStatement) && (constraint = ConstraintStateUtils.getApplicableConstraint(wc.getConstraint(), validationState, stateMapping)) != null) {
            ruleString = ClientValidationUtils.createRule(field, constraint, (String)booleanStatement, view, validationState, stateMapping);
        }
        if (StringUtils.isNotEmpty((String)ruleString)) {
            ClientValidationUtils.addScriptToPage(view, field, ruleString);
        }
    }

    public static void addScriptToPage(View view, InputField field, String script) {
        String prefixScript = "";
        if (field.getOnDocumentReadyScript() != null) {
            prefixScript = field.getOnDocumentReadyScript();
        }
        field.setOnDocumentReadyScript(prefixScript + "\nrunValidationScript(function(){" + script + "});");
    }

    private static List<String> parseOutFields(String statement) {
        String[] splits;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String s : splits = StringUtils.splitByWholeSeparator((String)statement, (String)"coerceValue(")) {
            String fieldName;
            if (!s.startsWith("'") || fieldNames.contains(fieldName = StringUtils.substringBefore((String)(s = s.substring(1)), (String)"'"))) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    private static String createRule(InputField field, Constraint constraint, String booleanStatement, View view, String validationState, StateMapping stateMapping) {
        Object rule = "";
        int constraintCount = 0;
        if (constraint instanceof BaseConstraint && ((BaseConstraint)constraint).getApplyClientSide().booleanValue()) {
            if (constraint instanceof SimpleConstraint) {
                if (((SimpleConstraint)constraint).getRequired() != null && ((SimpleConstraint)constraint).getRequired().booleanValue()) {
                    rule = (String)rule + "required: function(element){\nreturn (" + booleanStatement + ");}";
                    Object showIndicatorScript = "";
                    boolean hasConditionalReqCheck = false;
                    for (String checkedField : ClientValidationUtils.parseOutFields(booleanStatement)) {
                        showIndicatorScript = (String)showIndicatorScript + "setupShowReqIndicatorCheck('" + checkedField + "', '" + field.getBindingInfo().getBindingPath() + "', function(){\nreturn (" + booleanStatement + ");});\n";
                        hasConditionalReqCheck = true;
                    }
                    ClientValidationUtils.addScriptToPage(view, field, (String)showIndicatorScript);
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getMinLength() != null) {
                    if (constraintCount > 0) {
                        rule = (String)rule + ",\n";
                    }
                    rule = (String)rule + "minLengthConditional: [" + ((SimpleConstraint)constraint).getMinLength() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getMaxLength() != null) {
                    if (constraintCount > 0) {
                        rule = (String)rule + ",\n";
                    }
                    rule = (String)rule + "maxLengthConditional: [" + ((SimpleConstraint)constraint).getMaxLength() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getExclusiveMin() != null) {
                    if (constraintCount > 0) {
                        rule = (String)rule + ",\n";
                    }
                    rule = (String)rule + "minExclusive: [" + ((SimpleConstraint)constraint).getExclusiveMin() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getInclusiveMax() != null) {
                    if (constraintCount > 0) {
                        rule = (String)rule + ",\n";
                    }
                    rule = (String)rule + "maxInclusive: [" + ((SimpleConstraint)constraint).getInclusiveMax() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                rule = "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {" + (String)rule + "\n});";
            } else if (constraint instanceof ValidCharactersConstraint) {
                Object regexMethod = "";
                Object methodName = "";
                if (StringUtils.isNotEmpty((String)((ValidCharactersConstraint)constraint).getValue())) {
                    regexMethod = ClientValidationUtils.getRegexMethodWithBooleanCheck(field, (ValidCharactersConstraint)constraint) + "\n";
                    methodName = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
                    ++methodKey;
                } else if (StringUtils.isNotEmpty((String)((ValidCharactersConstraint)constraint).getMessageKey())) {
                    methodName = ((ValidCharactersConstraint)constraint).getMessageKey();
                }
                if (StringUtils.isNotEmpty((String)methodName)) {
                    rule = (String)regexMethod + "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n\"" + (String)methodName + "\" : function(element){return (" + booleanStatement + ");}\n});";
                }
            } else if (constraint instanceof PrerequisiteConstraint) {
                ClientValidationUtils.processPrerequisiteConstraint(field, (PrerequisiteConstraint)constraint, view, booleanStatement);
            } else if (constraint instanceof CaseConstraint) {
                ClientValidationUtils.processCaseConstraint(field, view, (CaseConstraint)constraint, booleanStatement, validationState, stateMapping);
            } else if (constraint instanceof MustOccurConstraint) {
                ClientValidationUtils.processMustOccurConstraint(field, view, (MustOccurConstraint)constraint, booleanStatement);
            }
        }
        return rule;
    }

    public static void processPrerequisiteConstraint(InputField field, PrerequisiteConstraint constraint, View view) {
        ClientValidationUtils.processPrerequisiteConstraint(field, constraint, view, "true");
    }

    public static void processPrerequisiteConstraint(InputField field, PrerequisiteConstraint constraint, View view, String booleanStatement) {
        if (constraint != null && constraint.getApplyClientSide().booleanValue()) {
            String dependsClass = "dependsOn-" + ScriptUtils.escapeName(constraint.getPropertyName());
            String addClass = "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').addClass('" + dependsClass + "');jQuery('[name=\"" + ScriptUtils.escapeName(constraint.getPropertyName()) + "\"]').addClass('dependsOn-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "');";
            ClientValidationUtils.addScriptToPage(view, field, addClass + ClientValidationUtils.getPrerequisiteStatement(field, view, constraint, booleanStatement) + ClientValidationUtils.getPostrequisiteStatement(field, constraint, booleanStatement));
            String showIndicatorScript = "setupShowReqIndicatorCheck('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "', '" + ScriptUtils.escapeName(constraint.getPropertyName()) + "', function(){\nreturn (coerceValue('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "') && " + booleanStatement + ");});\n";
            ClientValidationUtils.addScriptToPage(view, field, showIndicatorScript);
        }
    }

    private static String getPrerequisiteStatement(InputField field, View view, PrerequisiteConstraint constraint, String booleanStatement) {
        ++methodKey;
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        String message = "";
        if (StringUtils.isEmpty((String)constraint.getMessageKey())) {
            message = messageService.getMessageText("validation.prerequisite");
            message = MessageStructureUtils.translateStringMessage(message);
        } else {
            message = ClientValidationUtils.generateMessageText(constraint.getMessageNamespaceCode(), constraint.getMessageComponentCode(), constraint.getMessageKey(), constraint.getValidationMessageParams());
        }
        if (StringUtils.isEmpty((String)message)) {
            message = "prerequisite - No message";
        } else {
            DataField requiredField = view.getViewIndex().getDataFieldByPath(constraint.getPropertyName());
            if (requiredField != null && StringUtils.isNotEmpty((String)requiredField.getLabel())) {
                message = MessageFormat.format(message, requiredField.getLabel());
            } else {
                String genericFieldLabel = messageService.getMessageText(GENERIC_FIELD_MSG_KEY);
                message = MessageFormat.format(message, genericFieldLabel);
            }
        }
        String methodName = "prConstraint-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + methodKey;
        String addClass = "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').addClass('" + methodName + "');\n";
        String method = "\njQuery.validator.addMethod(\"" + methodName + "\", function(value, element) {\n if(" + booleanStatement + "){ return ((this.optional(element) !== false) || (coerceValue('" + ScriptUtils.escapeName(constraint.getPropertyName()) + "')));}else{return true;} }, \"" + message + "\");";
        String ifStatement = "if(occursBefore('" + ScriptUtils.escapeName(constraint.getPropertyName()) + "','" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "')){" + addClass + method + "}";
        return ifStatement;
    }

    private static String getPostrequisiteStatement(InputField field, PrerequisiteConstraint constraint, String booleanStatement) {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        String message = "";
        if (StringUtils.isEmpty((String)constraint.getMessageKey())) {
            message = messageService.getMessageText("validation.postrequisite");
            message = MessageStructureUtils.translateStringMessage(message);
        } else {
            message = ClientValidationUtils.generateMessageText(constraint.getMessageNamespaceCode(), constraint.getMessageComponentCode(), constraint.getMessageKey(), constraint.getValidationMessageParams());
        }
        if (StringUtils.isEmpty((String)constraint.getMessageKey())) {
            if (StringUtils.isNotEmpty((String)field.getLabel())) {
                message = MessageFormat.format(message, field.getLabel());
            } else {
                String genericFieldLabel = messageService.getMessageText(GENERIC_FIELD_MSG_KEY);
                message = MessageFormat.format(message, genericFieldLabel);
            }
        }
        String function = "function(element){\nreturn (coerceValue('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "') && " + booleanStatement + ");}";
        String postStatement = "\nelse if(occursBefore('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "','" + ScriptUtils.escapeName(constraint.getPropertyName()) + "')){\njQuery('[name=\"" + ScriptUtils.escapeName(constraint.getPropertyName()) + "\"]').rules(\"add\", { required: \n" + function + ", \nmessages: {\nrequired: \"" + message + "\"}});}\n";
        return postStatement;
    }

    public static void processMustOccurConstraint(InputField field, View view, MustOccurConstraint mc, String booleanStatement) {
        mustOccursPathNames = new ArrayList<List<String>>();
        String methodName = "moConstraint-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + ++methodKey;
        String method = "\njQuery.validator.addMethod(\"" + methodName + "\", function(value, element) {\n if(" + booleanStatement + "){return ((this.optional(element) !== false) || (" + ClientValidationUtils.getMustOccurStatement(field, mc) + "));}else{return true;}}, \"" + ClientValidationUtils.getMustOccursMessage(view, mc) + "\");";
        String rule = method + "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n\"" + methodName + "\": function(element){return (" + booleanStatement + ");}\n});";
        ClientValidationUtils.addScriptToPage(view, field, rule);
    }

    private static String getMustOccurStatement(InputField field, MustOccurConstraint constraint) {
        Object statement = "";
        ArrayList<String> attributePaths = new ArrayList<String>();
        if (constraint != null && constraint.getApplyClientSide().booleanValue()) {
            Object array = "[";
            if (constraint.getPrerequisiteConstraints() != null) {
                for (int i = 0; i < constraint.getPrerequisiteConstraints().size(); ++i) {
                    field.getControl().addStyleClass("dependsOn-" + constraint.getPrerequisiteConstraints().get(i).getPropertyName());
                    array = (String)array + "'" + ScriptUtils.escapeName(constraint.getPrerequisiteConstraints().get(i).getPropertyName()) + "'";
                    attributePaths.add(constraint.getPrerequisiteConstraints().get(i).getPropertyName());
                    if (i + 1 == constraint.getPrerequisiteConstraints().size()) continue;
                    array = (String)array + LABEL_KEY_SPLIT_PATTERN;
                }
            }
            array = (String)array + "]";
            statement = "mustOccurTotal(" + (String)array + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
            if (constraint.getMin() != null) {
                attributePaths.add(constraint.getMin().toString());
            } else {
                attributePaths.add(null);
            }
            if (constraint.getMax() != null) {
                attributePaths.add(constraint.getMax().toString());
            } else {
                attributePaths.add(null);
            }
            mustOccursPathNames.add(attributePaths);
            if (StringUtils.isEmpty((String)statement)) {
                statement = "0";
            }
            if (constraint.getMustOccurConstraints() != null) {
                for (MustOccurConstraint mc : constraint.getMustOccurConstraints()) {
                    statement = "mustOccurCheck(" + (String)statement + " + " + ClientValidationUtils.getMustOccurStatement(field, mc) + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
                }
            } else {
                statement = "mustOccurCheck(" + (String)statement + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
            }
        }
        return statement;
    }

    private static String getMustOccursMessage(View view, MustOccurConstraint constraint) {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        String message = "";
        if (StringUtils.isNotEmpty((String)constraint.getMessageKey())) {
            message = ClientValidationUtils.generateMessageText(constraint.getMessageNamespaceCode(), constraint.getMessageComponentCode(), constraint.getMessageKey(), constraint.getValidationMessageParams());
        } else {
            String and = messageService.getMessageText(AND_MSG_KEY);
            String or = messageService.getMessageText(OR_MSG_KEY);
            String mustOccursMsgEqualMinMax = messageService.getMessageText("validation.mustOccursEqualMinMax");
            String atMost = messageService.getMessageText(ATMOST_MSG_KEY);
            String genericLabel = messageService.getMessageText(GENERIC_FIELD_MSG_KEY);
            String mustOccursMsg = messageService.getMessageText("validation.mustOccurs");
            Object statement = "";
            for (int i = 0; i < mustOccursPathNames.size(); ++i) {
                Object andedString = "";
                List<String> paths = mustOccursPathNames.get(i);
                if (!paths.isEmpty()) {
                    String min = paths.get(paths.size() - 2);
                    String max = paths.get(paths.size() - 1);
                    for (int j = 0; j < paths.size() - 2; ++j) {
                        InputField field = (InputField)view.getViewIndex().getDataFieldByPath(paths.get(j).trim());
                        String label = genericLabel;
                        if (field != null && StringUtils.isNotEmpty((String)field.getLabel())) {
                            label = field.getLabel();
                        }
                        if (min.equals(max)) {
                            if (j == 0) {
                                andedString = label;
                                continue;
                            }
                            if (j == paths.size() - 3) {
                                andedString = (String)andedString + " " + and + " " + label;
                                continue;
                            }
                            andedString = (String)andedString + ", " + label;
                            continue;
                        }
                        andedString = (String)andedString + "(" + label + ")";
                    }
                    if (min.equals(max)) {
                        andedString = "(" + (String)andedString + ")";
                    }
                    if (StringUtils.isNotBlank((String)andedString) && !((String)andedString).equals("()")) {
                        if (StringUtils.isNotEmpty((String)min) && StringUtils.isNotEmpty((String)max) && !min.equals(max)) {
                            andedString = MessageFormat.format(mustOccursMsg, min + "-" + max) + " " + (String)andedString;
                        } else if (StringUtils.isNotEmpty((String)min) && StringUtils.isNotEmpty((String)max) && min.equals(max) && i == 0) {
                            andedString = mustOccursMsgEqualMinMax + " " + (String)andedString;
                        } else if (!(StringUtils.isNotEmpty((String)min) && StringUtils.isNotEmpty((String)max) && min.equals(max) && i != 0)) {
                            if (StringUtils.isNotEmpty((String)min)) {
                                andedString = MessageFormat.format(mustOccursMsg, min) + " " + (String)andedString;
                            } else if (StringUtils.isNotEmpty((String)max)) {
                                andedString = MessageFormat.format(mustOccursMsg, atMost + " " + max) + " " + (String)andedString;
                            }
                        }
                    }
                }
                if (!StringUtils.isNotEmpty((String)andedString)) continue;
                statement = StringUtils.isNotBlank((String)statement) ? (String)statement + " " + or.toUpperCase() + " " + (String)andedString : andedString;
            }
            if (StringUtils.isNotEmpty((String)statement)) {
                message = statement;
                message = message.replace(")(", " " + or + " ");
            }
        }
        return message;
    }

    public static void processAndApplyConstraints(InputField field, View view, Object model) {
        methodKey = 0;
        String validationState = ConstraintStateUtils.getClientViewValidationState(model, view);
        StateMapping stateMapping = view.getStateMapping();
        if (view instanceof FormView && ((FormView)view).isValidateClientSide()) {
            CaseConstraint caseConstraint;
            ValidCharactersConstraint validCharactersConstraint;
            SimpleConstraint simpleConstraint = ConstraintStateUtils.getApplicableConstraint(field.getSimpleConstraint(), validationState, stateMapping);
            if (simpleConstraint != null && simpleConstraint.getApplyClientSide().booleanValue()) {
                String rule;
                if (simpleConstraint.getRequired() != null && simpleConstraint.getRequired().booleanValue()) {
                    field.getControl().addStyleClass("required");
                }
                if (simpleConstraint.getExclusiveMin() != null) {
                    if (field.getControl() instanceof TextControl && ((TextControl)field.getControl()).getDatePicker() != null) {
                        DatePicker datePicker = ((TextControl)field.getControl()).getDatePicker();
                        Map<String, String> dpTemplateOptions = datePicker.getTemplateOptions();
                        if (dpTemplateOptions == null) {
                            dpTemplateOptions = new HashMap<String, String>();
                            datePicker.setTemplateOptions(dpTemplateOptions);
                        }
                        dpTemplateOptions.put("minDate", simpleConstraint.getExclusiveMin());
                    } else {
                        rule = "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n minExclusive: [" + simpleConstraint.getExclusiveMin() + "]});";
                        ClientValidationUtils.addScriptToPage(view, field, rule);
                    }
                }
                if (simpleConstraint.getInclusiveMax() != null) {
                    if (field.getControl() instanceof TextControl && ((TextControl)field.getControl()).getDatePicker() != null) {
                        ((TextControl)field.getControl()).getDatePicker().getTemplateOptions().put("maxDate", simpleConstraint.getInclusiveMax());
                    } else {
                        rule = "jQuery('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n maxInclusive: [" + simpleConstraint.getInclusiveMax() + "]});";
                        ClientValidationUtils.addScriptToPage(view, field, rule);
                    }
                }
            }
            if ((validCharactersConstraint = ConstraintStateUtils.getApplicableConstraint(field.getValidCharactersConstraint(), validationState, stateMapping)) != null && validCharactersConstraint.getApplyClientSide().booleanValue()) {
                if (StringUtils.isNotEmpty((String)validCharactersConstraint.getValue())) {
                    String script = ClientValidationUtils.getRegexMethod(field, validCharactersConstraint, false);
                    if (((UifFormBase)model).getRequestJsonTemplate() == "components/element/dataTablesJson.ftl") {
                        script = script.replaceAll("\\.", "\\\\u002e");
                    }
                    ClientValidationUtils.addScriptToPage(view, field, script);
                    field.getControl().addStyleClass("validChar-" + field.getBindingInfo().getBindingPath() + methodKey);
                    ++methodKey;
                } else if (StringUtils.isNotEmpty((String)validCharactersConstraint.getMessageKey())) {
                    field.getControl().addStyleClass(validCharactersConstraint.getMessageKey());
                }
            }
            if ((caseConstraint = ConstraintStateUtils.getApplicableConstraint(field.getCaseConstraint(), validationState, stateMapping)) != null && caseConstraint.getApplyClientSide().booleanValue()) {
                ClientValidationUtils.processCaseConstraint(field, view, caseConstraint, null, validationState, stateMapping);
            }
            if (field.getDependencyConstraints() != null) {
                for (PrerequisiteConstraint prc : field.getDependencyConstraints()) {
                    if ((prc = ConstraintStateUtils.getApplicableConstraint(prc, validationState, stateMapping)) == null) continue;
                    ClientValidationUtils.processPrerequisiteConstraint(field, prc, view);
                }
            }
            if (field.getMustOccurConstraints() != null) {
                for (MustOccurConstraint mc : field.getMustOccurConstraints()) {
                    if ((mc = ConstraintStateUtils.getApplicableConstraint(mc, validationState, stateMapping)) == null) continue;
                    ClientValidationUtils.processMustOccurConstraint(field, view, mc, "true");
                }
            }
        }
    }

    public static enum ValidationMessageKeys {
        REQUIRED("required"),
        MIN_EXCLUSIVE("minExclusive"),
        MAX_INCLUSIVE("maxInclusive"),
        MIN_LENGTH("minLengthConditional"),
        MAX_LENGTH("maxLengthConditional");

        private final String name;

        private ValidationMessageKeys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean contains(String name) {
            for (ValidationMessageKeys element : EnumSet.allOf(ValidationMessageKeys.class)) {
                if (!element.toString().equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
    }
}

