/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Iframe;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.FormView;

@BeanTag(name="iframeView", parent="Uif-IframeView")
public class IframeView
extends FormView {
    private UrlInfo location;
    private Iframe iframe;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        super.setSinglePageView(true);
        List<? extends Component> modifiedItems = this.getPage().getItems();
        modifiedItems.add(this.iframe);
        this.getPage().setItems(modifiedItems);
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.location != null) {
            ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(this.location, false);
            ViewLifecycle.getExpressionEvaluator().evaluateExpressionsOnConfigurable(this, this.location, this.getContext());
            this.iframe.setSource(this.location.getHref());
        }
    }

    @BeanTagAttribute
    public UrlInfo getLocation() {
        return this.location;
    }

    public void setLocation(UrlInfo location) {
        this.location = location;
    }

    @BeanTagAttribute
    public String getHref() {
        if (this.location != null) {
            return this.location.getHref();
        }
        return null;
    }

    public void setHref(String href) {
        if (this.location == null) {
            this.location = ComponentFactory.getUrlInfo();
        }
        this.location.setHref(href);
    }

    @BeanTagAttribute
    public Iframe getIframe() {
        return this.iframe;
    }

    public void setIframe(Iframe iframe) {
        this.iframe = iframe;
    }
}

