/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.CheckboxGroupControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="richTable", parent="Uif-RichTable"), @BeanTag(name="pagedRichTable", parent="Uif-PagedRichTable"), @BeanTag(name="scrollableRichTable", parent="Uif-ScrollableRichTable")})
public class RichTable
extends WidgetBase {
    private static final long serialVersionUID = 4671589690877390070L;
    private String emptyTableMessage;
    private boolean disableTableSort;
    private boolean forceAoColumnDefsOverride;
    private boolean forceLocalJsonData;
    private int nestedLevel;
    private String aaData;
    private Set<String> hiddenColumns;
    private Set<String> sortableColumns;
    private List<String> cellCssClasses = new ArrayList<String>();
    private String ajaxSource;
    private boolean showExportOption;
    private String groupingOptionsJSString = "null";

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        String sDomOption;
        Object domOption;
        super.performFinalize(model, parent);
        UifFormBase formBase = (UifFormBase)model;
        if (!this.isRender()) {
            return;
        }
        if (this.templateOptions.isEmpty()) {
            this.setTemplateOptions(new HashMap<String, String>());
        }
        if (StringUtils.isNotBlank((String)this.getEmptyTableMessage()) && !this.templateOptions.containsKey("oLanguage")) {
            this.templateOptions.put("oLanguage", "{\"sEmptyTable\" : \"" + this.getEmptyTableMessage() + "\"}");
        }
        if ((domOption = this.templateOptions.get("sDom")) instanceof String && StringUtils.isNotBlank((String)(sDomOption = (String)domOption))) {
            if (!this.isShowExportOption()) {
                sDomOption = StringUtils.remove((String)sDomOption, (String)"T");
            }
            this.templateOptions.put("sDom", sDomOption);
        }
        if ("addLine".equals(formBase.getActionEvent()) || "addBlankLine".equals(formBase.getActionEvent())) {
            this.templateOptions.put("aaSorting", "[]");
        }
        if (parent instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)parent;
            LayoutManager layoutManager = collectionGroup.getLayoutManager();
            if (layoutManager instanceof TableLayoutManager && collectionGroup.isUseServerPaging()) {
                this.addCellStyling((TableLayoutManager)layoutManager);
            }
            this.buildTableOptions(collectionGroup);
            this.setTotalOptions(collectionGroup);
            ViewLifecycle.getActiveLifecycle();
            View view = ViewLifecycle.getView();
            if (view instanceof LookupView) {
                this.buildSortOptions((LookupView)view, collectionGroup);
            }
        }
        if (this.isDisableTableSort()) {
            this.templateOptions.put("bSort", "false");
        }
        String kradUrl = this.getConfigurationService().getPropertyValueAsString("krad.url");
        if (StringUtils.isNotBlank((String)this.ajaxSource)) {
            this.templateOptions.put("sAjaxSource", this.ajaxSource);
        } else if (parent instanceof CollectionGroup && ((CollectionGroup)parent).isUseServerPaging()) {
            this.templateOptions.put("bProcessing", "true");
            this.templateOptions.put("bServerSide", "true");
            this.templateOptions.put("sAjaxSource", kradUrl + ((UifFormBase)model).getControllerMapping() + "?methodToCall=tableJsonRetrieval&updateComponentId=" + parent.getId() + "&formKey=" + ((UifFormBase)model).getFormKey() + "&ajaxReturnType=" + UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey() + "&ajaxRequest=true");
            String pushLookupSelect = "function (aoData) { if(jQuery('table.dataTable').length > 0) {        var table = jQuery('table.dataTable');        jQuery( table.find(':input:checked')).each( function (index) {             aoData.push({'name': (jQuery(this)).attr('name'),'value': (jQuery(this)).attr('value')});      console.log(jQuery(this).attr('name') + ':' + jQuery(this).attr('value'));     });  }  }";
            this.templateOptions.put("fnServerParams", pushLookupSelect);
            ViewLifecycle.getViewPostMetadata().addComponentPostData(parent.getId(), "aoColumnDefs", this.templateOptions.get("aoColumnDefs"));
        }
        this.templateOptions.put("sDownloadSource", kradUrl + "/export?updateComponentId=" + parent.getId() + "&formKey=" + ((UifFormBase)model).getFormKey() + "&ajaxReturnType=" + UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey() + "&ajaxRequest=true");
    }

    private void addCellStyling(TableLayoutManager manager) {
        if (!CollectionUtils.isEmpty(manager.getAllRowFields())) {
            for (int index = 0; index < manager.getNumberOfColumns(); ++index) {
                String cellStyleClasses = ((ComponentBase)((Object)manager.getAllRowFields().get(index))).getWrapperCssClassesAsString();
                if (!StringUtils.isNotBlank((String)cellStyleClasses)) continue;
                this.cellCssClasses.add(cellStyleClasses);
            }
        }
    }

    private void setTotalOptions(CollectionGroup collectionGroup) {
        List<String> totalColumns;
        LayoutManager layoutManager = collectionGroup.getLayoutManager();
        if (layoutManager instanceof TableLayoutManager && (totalColumns = ((TableLayoutManager)layoutManager).getColumnsToCalculate()).size() > 0) {
            Object array = "[";
            for (String i : totalColumns) {
                array = (String)array + i + ",";
            }
            array = StringUtils.removeEnd((String)array, (String)",");
            array = (String)array + "]";
            this.templateOptions.put("fnFooterCallback", "function (nRow, aaData, iStart, iEnd, aiDisplay) {initializeTotalsFooter (nRow, aaData, iStart, iEnd, aiDisplay, " + (String)array + " )}");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildTableOptions(CollectionGroup collectionGroup) {
        this.checkMutable(false);
        LayoutManager layoutManager = collectionGroup.getLayoutManager();
        boolean useServerPaging = collectionGroup.isUseServerPaging();
        if (this.templateOptions.isEmpty()) {
            this.setTemplateOptions(new HashMap<String, String>());
        }
        if (!collectionGroup.getSubCollections().isEmpty()) {
            this.setDisableTableSort(true);
        }
        if (!this.isDisableTableSort()) {
            String jsArray;
            String options;
            boolean actionFieldVisible;
            if (!(!collectionGroup.isRenderAddLine() || Boolean.TRUE.equals(collectionGroup.getReadOnly()) || layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isSeparateAddLine())) {
                this.templateOptions.put("aiSortingSkipRows", "[0]");
            }
            StringBuilder tableColumnOptions = new StringBuilder("[");
            int colIndex = 0;
            int actionIndex = -1;
            boolean bl = actionFieldVisible = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
            if (layoutManager instanceof TableLayoutManager) {
                actionIndex = ((TableLayoutManager)layoutManager).getActionColumnIndex();
            }
            if (actionIndex == 1 && actionFieldVisible) {
                String options2 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                tableColumnOptions.append(options2 + ",");
                ++colIndex;
            }
            if (layoutManager instanceof TableLayoutManager && ((TableLayoutManager)layoutManager).isRenderSequenceField()) {
                Class dataTypeClass = Number.class;
                if (((TableLayoutManager)layoutManager).getSequenceFieldPrototype() instanceof DataField) {
                    DataField dataField = (DataField)((TableLayoutManager)layoutManager).getSequenceFieldPrototype();
                    dataTypeClass = ObjectPropertyUtils.getPropertyType(collectionGroup.getCollectionObjectClass(), dataField.getPropertyName());
                    if (dataField.getSortAs() != null && dataField.getSortAs().length() > 0) {
                        if (dataField.getSortAs().equals("kuali_date")) {
                            dataTypeClass = Date.class;
                        } else if (dataField.getSortAs().equals("numeric")) {
                            dataTypeClass = Number.class;
                        } else if (dataField.getSortAs().equals("string")) {
                            dataTypeClass = String.class;
                        }
                    }
                }
                tableColumnOptions.append("{" + this.sortable(false) + "," + this.sortType(this.getSortType(dataTypeClass)) + "," + this.sortDataType("dom-text") + this.mData(useServerPaging, colIndex) + "," + this.targets(colIndex) + "},");
                this.templateOptions.put("aaSorting", "[[" + colIndex + ",'asc']]");
                ++colIndex;
                if (actionIndex == 2 && actionFieldVisible) {
                    options = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                    tableColumnOptions.append(options + ",");
                    ++colIndex;
                }
            }
            if (collectionGroup.isIncludeLineSelectionField()) {
                String options2 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                tableColumnOptions.append(options2 + ",");
                ++colIndex;
            }
            if (!StringUtils.isEmpty((String)((String)this.templateOptions.get("aoColumns")))) {
                jsArray = (String)this.templateOptions.get("aoColumns");
                int startBrace = StringUtils.indexOf((String)jsArray, (String)"[");
                int n = StringUtils.lastIndexOf((String)jsArray, (String)"]");
                tableColumnOptions.append(StringUtils.substring((String)jsArray, (int)(startBrace + 1), (int)n) + ",");
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= colIndex)) {
                    String options3 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                    tableColumnOptions.append(options3);
                } else {
                    tableColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableColumnOptions.toString(), (String)","));
                }
                tableColumnOptions.append("]");
                this.templateOptions.put("aoColumns", tableColumnOptions.toString());
            } else if (!StringUtils.isEmpty((String)((String)this.templateOptions.get("aoColumnDefs"))) && this.forceAoColumnDefsOverride) {
                jsArray = (String)this.templateOptions.get("aoColumnDefs");
                int startBrace = StringUtils.indexOf((String)jsArray, (String)"[");
                int n = StringUtils.lastIndexOf((String)jsArray, (String)"]");
                tableColumnOptions.append(StringUtils.substring((String)jsArray, (int)(startBrace + 1), (int)n) + ",");
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= colIndex)) {
                    String options4 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                    tableColumnOptions.append(options4);
                } else {
                    tableColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableColumnOptions.toString(), (String)","));
                }
                tableColumnOptions.append("]");
                this.templateOptions.put("aoColumnDefs", tableColumnOptions.toString());
            } else if (layoutManager instanceof TableLayoutManager) {
                List<Field> rowFields = ((TableLayoutManager)layoutManager).getFirstRowFields();
                for (Component component : rowFields) {
                    String options3;
                    void var10_14;
                    if (actionFieldVisible && colIndex + 1 == actionIndex) {
                        String options5 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                        tableColumnOptions.append(options5 + ",");
                        ++colIndex;
                    }
                    if (component instanceof FieldGroup) {
                        Component component2 = ((FieldGroup)component).getItems().get(0);
                    }
                    if (var10_14 instanceof DataField) {
                        DataField field = (DataField)var10_14;
                        if (this.getHiddenColumns() != null && this.getHiddenColumns().contains(field.getPropertyName())) {
                            tableColumnOptions.append("{" + this.visible(false) + "," + this.mData(useServerPaging, colIndex) + this.targets(colIndex) + "},");
                        } else if (this.getSortableColumns() != null && !this.getSortableColumns().isEmpty()) {
                            if (this.getSortableColumns().contains(field.getPropertyName())) {
                                tableColumnOptions.append(this.getDataFieldColumnOptions(colIndex, collectionGroup, field) + ",");
                            } else {
                                tableColumnOptions.append("{" + this.sortable(false) + "," + this.mData(useServerPaging, colIndex) + this.targets(colIndex) + "},");
                            }
                        } else {
                            String options6 = this.getDataFieldColumnOptions(colIndex, collectionGroup, field);
                            tableColumnOptions.append(options6 + ",");
                        }
                        ++colIndex;
                        continue;
                    }
                    if (var10_14 instanceof MessageField) {
                        if (var10_14.getDataAttributes() != null && "RowGrouping".equals(var10_14.getDataAttributes().get("role"))) {
                            tableColumnOptions.append("{" + this.visible(false) + "," + this.mData(useServerPaging, colIndex) + this.targets(colIndex) + "},");
                        } else {
                            options3 = this.constructTableColumnOptions(colIndex, true, useServerPaging, String.class, "dom-text");
                            tableColumnOptions.append(options3 + ",");
                        }
                        ++colIndex;
                        continue;
                    }
                    if (var10_14 instanceof LinkField) {
                        LinkField linkField = (LinkField)var10_14;
                        Class dataTypeClass = String.class;
                        if (linkField.getSortAs() != null && linkField.getSortAs().length() > 0) {
                            if (linkField.getSortAs().equals("kuali_date")) {
                                dataTypeClass = Date.class;
                            } else if (linkField.getSortAs().equals("numeric")) {
                                dataTypeClass = Number.class;
                            } else if (linkField.getSortAs().equals("string")) {
                                dataTypeClass = String.class;
                            }
                        }
                        String options7 = this.constructTableColumnOptions(colIndex, true, useServerPaging, dataTypeClass, "dom-text");
                        tableColumnOptions.append(options7 + ",");
                        ++colIndex;
                        continue;
                    }
                    options3 = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                    tableColumnOptions.append(options3 + ",");
                    ++colIndex;
                }
                if (actionFieldVisible && (actionIndex == -1 || actionIndex >= colIndex)) {
                    options = this.constructTableColumnOptions(colIndex, false, useServerPaging, null, null);
                    tableColumnOptions.append(options);
                } else {
                    tableColumnOptions = new StringBuilder(StringUtils.removeEnd((String)tableColumnOptions.toString(), (String)","));
                }
                if (!StringUtils.isEmpty((String)((String)this.templateOptions.get("aoColumnDefs")))) {
                    String origAoOptions = ((String)this.templateOptions.get("aoColumnDefs")).trim();
                    origAoOptions = StringUtils.removeStart((String)origAoOptions, (String)"[");
                    origAoOptions = StringUtils.removeEnd((String)origAoOptions, (String)"]");
                    tableColumnOptions.append("," + origAoOptions);
                }
                tableColumnOptions.append("]");
                this.templateOptions.put("aoColumnDefs", tableColumnOptions.toString());
            }
        }
    }

    protected void buildSortOptions(LookupView lookupView, CollectionGroup collectionGroup) {
        LayoutManager layoutManager;
        if (!this.isDisableTableSort() && CollectionUtils.isNotEmpty(lookupView.getDefaultSortAttributeNames()) && (layoutManager = collectionGroup.getLayoutManager()) instanceof TableLayoutManager) {
            TableLayoutManager tableLayoutManager = (TableLayoutManager)layoutManager;
            List<String> firstRowPropertyNames = this.getFirstRowPropertyNames(tableLayoutManager.getFirstRowFields());
            List<String> defaultSortAttributeNames = lookupView.getDefaultSortAttributeNames();
            String sortDirection = lookupView.isDefaultSortAscending() ? "'asc'" : "'desc'";
            boolean actionFieldVisible = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
            int actionIndex = ((TableLayoutManager)layoutManager).getActionColumnIndex();
            int columnIndexPrefix = 0;
            if (tableLayoutManager.isRenderSequenceField()) {
                ++columnIndexPrefix;
            }
            if (tableLayoutManager.getRowDetailsGroup() != null && CollectionUtils.isNotEmpty(tableLayoutManager.getRowDetailsGroup().getItems())) {
                ++columnIndexPrefix;
            }
            StringBuffer tableToolsSortOptions = new StringBuffer("[");
            for (String defaultSortAttributeName : defaultSortAttributeNames) {
                int index = firstRowPropertyNames.indexOf(defaultSortAttributeName);
                if (index < 0) continue;
                if (tableToolsSortOptions.length() > 1) {
                    tableToolsSortOptions.append(",");
                }
                int columnIndex = columnIndexPrefix + index;
                if (actionFieldVisible && actionIndex != -1 && actionIndex <= columnIndex + 1) {
                    ++columnIndex;
                }
                tableToolsSortOptions.append("[" + columnIndex + "," + sortDirection + "]");
            }
            tableToolsSortOptions.append("]");
            if (this.templateOptions.isEmpty()) {
                this.setTemplateOptions(new HashMap<String, String>());
            }
            this.templateOptions.put("aaSorting", tableToolsSortOptions.toString());
        }
    }

    private List<String> getFirstRowPropertyNames(List<Field> firstRowFields) {
        return Lists.transform(firstRowFields, (Function)new Function<Field, String>(){

            public String apply(@Nullable Field field) {
                if (field != null && field instanceof DataField) {
                    return ((DataField)field).getPropertyName();
                }
                return null;
            }
        });
    }

    protected String getDataFieldColumnOptions(int target, CollectionGroup collectionGroup, DataField field) {
        Control control;
        String sortDataType = null;
        sortDataType = !Boolean.TRUE.equals(collectionGroup.getReadOnly()) && field instanceof InputField && ((InputField)field).getControl() != null ? ((control = ((InputField)field).getControl()) instanceof SelectControl ? "dom-select" : (control instanceof CheckboxControl || control instanceof CheckboxGroupControl ? "dom-checkbox" : (control instanceof RadioGroupControl ? "dom-radio" : "dom-text"))) : "dom-text";
        Class<Object> dataTypeClass = ObjectPropertyUtils.getPropertyType(collectionGroup.getCollectionObjectClass(), field.getPropertyName());
        if (field.getSortAs() != null && field.getSortAs().length() > 0) {
            if (field.getSortAs().equals("kuali_currency")) {
                dataTypeClass = KualiDecimal.class;
            } else if (field.getSortAs().equals("kuali_date")) {
                dataTypeClass = Date.class;
            } else if (field.getSortAs().equals("numeric")) {
                dataTypeClass = Number.class;
            } else if (field.getSortAs().equals("string")) {
                dataTypeClass = String.class;
            }
        }
        boolean isSortable = true;
        if (field.isApplyMask()) {
            isSortable = false;
        }
        return this.constructTableColumnOptions(target, isSortable, collectionGroup.isUseServerPaging(), dataTypeClass, sortDataType);
    }

    public String constructTableColumnOptions(int target, boolean isSortable, boolean isUseServerPaging, Class<?> dataTypeClass, String sortDataType) {
        Object options = "null";
        if (!isSortable || dataTypeClass == null) {
            options = this.sortable(false) + "," + this.sortType("string");
        } else {
            options = this.sortType(this.getSortType(dataTypeClass));
            if (!isUseServerPaging && !this.forceLocalJsonData) {
                options = (String)options + "," + this.sortDataType(sortDataType);
            }
        }
        if (target < this.cellCssClasses.size() && target >= 0) {
            options = (String)options + ", \"sClass\" : \"" + this.cellCssClasses.get(target) + "\"";
        }
        options = !((String)(options = (String)options + this.mData(isUseServerPaging, target))).equals("null") ? "{" + (String)options + "," + this.targets(target) + "}" : "{" + (String)options + "}";
        return options;
    }

    private String sortable(boolean sortable) {
        return "\"bSortable\": " + (sortable ? "true" : "false");
    }

    private String sortDataType(String sortDataType) {
        return "\"sSortDataType\": \"" + sortDataType + "\"";
    }

    private String getSortType(Class<?> dataTypeClass) {
        String sortType = "string";
        if (ClassUtils.isAssignable(dataTypeClass, KualiPercent.class)) {
            sortType = "kuali_percent";
        } else if (ClassUtils.isAssignable(dataTypeClass, KualiInteger.class) || ClassUtils.isAssignable(dataTypeClass, KualiDecimal.class)) {
            sortType = "kuali_currency";
        } else if (ClassUtils.isAssignable(dataTypeClass, Timestamp.class)) {
            sortType = "date";
        } else if (ClassUtils.isAssignable(dataTypeClass, Date.class) || ClassUtils.isAssignable(dataTypeClass, java.util.Date.class)) {
            sortType = "kuali_date";
        } else if (ClassUtils.isAssignable(dataTypeClass, Number.class)) {
            sortType = "numeric";
        }
        return sortType;
    }

    private String sortType(String sortType) {
        return "\"sType\": \"" + sortType + "\"";
    }

    private String targets(int target) {
        return "\"aTargets\": [" + target + "]";
    }

    private String visible(boolean visible) {
        return "\"bVisible\": " + (visible ? "true" : "false");
    }

    private String mData(boolean isUseServerPaging, int target) {
        if (isUseServerPaging || this.forceLocalJsonData) {
            return ", \"mDataProp\" : function(row,type,newVal){ return _handleColData(row,type,'c" + target + "',newVal);}";
        }
        return "";
    }

    @BeanTagAttribute
    public String getEmptyTableMessage() {
        return this.emptyTableMessage;
    }

    public void setEmptyTableMessage(String emptyTableMessage) {
        this.emptyTableMessage = emptyTableMessage;
    }

    @BeanTagAttribute
    public boolean isDisableTableSort() {
        return this.disableTableSort;
    }

    public void setDisableTableSort(boolean disableTableSort) {
        this.disableTableSort = disableTableSort;
    }

    @BeanTagAttribute
    public boolean isShowExportOption() {
        return this.showExportOption;
    }

    public void setShowExportOption(boolean showExportOption) {
        this.showExportOption = showExportOption;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(Set<String> hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(Set<String> sortableColumns) {
        this.sortableColumns = sortableColumns;
    }

    @BeanTagAttribute
    public String getAjaxSource() {
        return this.ajaxSource;
    }

    public void setAjaxSource(String ajaxSource) {
        this.ajaxSource = ajaxSource;
    }

    public String getGroupingOptionsJSString() {
        return this.groupingOptionsJSString;
    }

    public void setGroupingOptionsJSString(String groupingOptionsJSString) {
        this.groupingOptionsJSString = groupingOptionsJSString;
    }

    @BeanTagAttribute
    public boolean isForceAoColumnDefsOverride() {
        return this.forceAoColumnDefsOverride;
    }

    public void setForceAoColumnDefsOverride(boolean forceAoColumnDefsOverride) {
        this.forceAoColumnDefsOverride = forceAoColumnDefsOverride;
    }

    @BeanTagAttribute
    public boolean isForceLocalJsonData() {
        return this.forceLocalJsonData;
    }

    public void setForceLocalJsonData(boolean forceLocalJsonData) {
        this.forceLocalJsonData = forceLocalJsonData;
    }

    @BeanTagAttribute
    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public void setNestedLevel(int nestedLevel) {
        this.nestedLevel = nestedLevel;
    }

    public String getAaData() {
        return this.aaData;
    }

    protected void setAaData(String aaData) {
        this.aaData = aaData;
    }

    public String getCellValue(Object model, Field field) {
        Object value = KRADUtils.getSimpleFieldValue(model, field);
        value = value == null ? "null" : "@quot@" + (String)value + "@quot@";
        return value;
    }

    public void addRowToTableData(String row) {
        Object escape = "";
        if (this.templateOptions.isEmpty()) {
            this.setTemplateOptions(new HashMap<String, String>());
        }
        for (int i = 0; i < this.nestedLevel && this.forceLocalJsonData; ++i) {
            escape = (String)escape + "\\";
        }
        row = ((String)row).trim().replace("\"", (String)escape + "\\u0022").replace("'", (String)escape + "\\u0027").replace("\n", "").replace("\r", "");
        row = StringUtils.removeEnd((String)row, (String)",");
        row = ((String)row).replace("@quot@", "\"");
        row = "{" + (String)row + "}";
        if (StringUtils.isBlank((String)this.aaData)) {
            this.aaData = "[" + (String)row + "]";
            if (this.templateOptions.get("bDeferRender") == null) {
                this.templateOptions.put("bDeferRender", "true");
            }
        } else if (StringUtils.isNotBlank((String)row)) {
            this.aaData = this.aaData.substring(0, this.aaData.length() - 1) + "," + (String)row + "]";
        }
        if (this.forceLocalJsonData) {
            this.templateOptions.put("aaData", this.aaData);
        }
    }

    protected ConfigurationService getConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }
}

