/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.listener;

import java.util.List;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class KualiHttpSessionListener
implements HttpSessionListener {
    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.releaseLocks(se);
    }

    private void releaseLocks(HttpSessionEvent se) {
        if (se != null && se.getSession() != null && se.getSession().getAttribute("UserSession") != null) {
            UserSession userSession = (UserSession)se.getSession().getAttribute("UserSession");
            this.releaseUserSessionLocks(userSession);
        }
        if (GlobalVariables.getUserSession() != null) {
            this.releaseUserSessionLocks(GlobalVariables.getUserSession());
        }
    }

    private void releaseUserSessionLocks(UserSession userSession) {
        String sessionId = userSession.getKualiSessionId();
        Person user = userSession.getPerson();
        if (StringUtils.isNotBlank((String)sessionId) && user != null) {
            List<PessimisticLock> locks = KRADServiceLocatorWeb.getPessimisticLockService().getPessimisticLocksForSession(sessionId);
            KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, user);
        }
    }
}

