/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.config.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.security.credentials.CredentialsSourceFactory;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.impl.config.module.Log4jLifeCycle;

public class CoreConfigurer
extends ModuleConfigurer {
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private DataSource serverDataSource;
    private String platform;
    private UserTransaction userTransaction;
    private TransactionManager transactionManager;
    private CredentialsSourceFactory credentialsSourceFactory;

    public CoreConfigurer() {
        super("core");
        this.setValidRunModes(Arrays.asList(RunMode.LOCAL));
    }

    public List<Lifecycle> loadLifecycles() throws Exception {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        if (this.isConfigureLogging()) {
            lifecycles.add((Lifecycle)new Log4jLifeCycle());
        }
        return lifecycles;
    }

    public void addAdditonalToConfig() {
        this.configureJta();
        this.configureDataSource();
        this.configureCredentialsSourceFactory();
    }

    public boolean hasWebInterface() {
        return true;
    }

    protected boolean isConfigureLogging() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.logging.configure", false);
    }

    protected void configureCredentialsSourceFactory() {
        if (this.credentialsSourceFactory != null) {
            ConfigContext.getCurrentContextConfig().putObject("credentialsSourceFactory", (Object)this.credentialsSourceFactory);
        }
    }

    protected void configureDataSource() {
        if (this.dataSource != null) {
            ConfigContext.getCurrentContextConfig().putObject("datasource", (Object)this.dataSource);
        }
        if (this.nonTransactionalDataSource != null) {
            ConfigContext.getCurrentContextConfig().putObject("nonTransactionalDatasource", (Object)this.nonTransactionalDataSource);
        }
        if (this.serverDataSource != null) {
            ConfigContext.getCurrentContextConfig().putObject("serverDatasource", (Object)this.serverDataSource);
        }
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info("CoreConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode());
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add("classpath:org/kuali/rice/core/config/CORESpringBeans.xml");
        return springFileLocations;
    }

    protected void configureJta() {
        boolean transactionManagerConfigured;
        if (this.userTransaction != null) {
            ConfigContext.getCurrentContextConfig().putObject("userTransaction", (Object)this.userTransaction);
        }
        if (this.transactionManager != null) {
            ConfigContext.getCurrentContextConfig().putObject("transactionManager", (Object)this.transactionManager);
        }
        boolean userTransactionConfigured = this.userTransaction != null || !StringUtils.isEmpty((String)ConfigContext.getCurrentContextConfig().getProperty("userTransaction.jndi.location"));
        boolean bl = transactionManagerConfigured = this.transactionManager != null || !StringUtils.isEmpty((String)ConfigContext.getCurrentContextConfig().getProperty("transactionManager.jndi.location"));
        if (userTransactionConfigured && !transactionManagerConfigured) {
            throw new ConfigurationException("When configuring JTA, both a UserTransaction and a TransactionManager are required.  Only the UserTransaction was configured.");
        }
        if (transactionManagerConfigured && !userTransactionConfigured) {
            throw new ConfigurationException("When configuring JTA, both a UserTransaction and a TransactionManager are required.  Only the TransactionManager was configured.");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getNonTransactionalDataSource() {
        return this.nonTransactionalDataSource;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public DataSource getServerDataSource() {
        return this.serverDataSource;
    }

    public void setServerDataSource(DataSource serverDataSource) {
        this.serverDataSource = serverDataSource;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public CredentialsSourceFactory getCredentialsSourceFactory() {
        return this.credentialsSourceFactory;
    }

    public void setCredentialsSourceFactory(CredentialsSourceFactory credentialsSourceFactory) {
        this.credentialsSourceFactory = credentialsSourceFactory;
    }
}

