/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.resourceloader;

import java.util.List;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;

class ParentChildResourceLoader
implements ResourceLoader {
    private final ResourceLoader parent;
    private final ResourceLoader child;
    private QName name;

    ParentChildResourceLoader(ResourceLoader parent, ResourceLoader child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent resource loader was null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child resource loader was null");
        }
        this.parent = parent;
        this.child = child;
        this.name = new QName(child.getName().toString() + " to parent " + parent.getName().toString());
    }

    @Override
    public <T> T getObject(ObjectDefinition definition) {
        Object object = this.child.getObject(definition);
        if (object == null) {
            object = this.parent.getObject(definition);
        }
        return object;
    }

    @Override
    public <T> T getService(QName qname) {
        Object service = this.child.getService(qname);
        if (service == null) {
            service = this.parent.getService(qname);
        }
        return service;
    }

    @Override
    public void start() throws Exception {
        if (!this.child.isStarted()) {
            this.child.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.child.isStarted()) {
            this.child.stop();
        }
    }

    @Override
    public void addResourceLoader(ResourceLoader resourceLoader) {
        this.child.addResourceLoader(resourceLoader);
    }

    @Override
    public void addResourceLoaderFirst(ResourceLoader resourceLoader) {
        this.child.addResourceLoaderFirst(resourceLoader);
    }

    @Override
    public ResourceLoader getResourceLoader(QName name) {
        ResourceLoader resourceLoader = this.child.getResourceLoader(name);
        if (resourceLoader == null && this.parent != null) {
            return this.parent.getResourceLoader(name);
        }
        return resourceLoader;
    }

    @Override
    public List<QName> getResourceLoaderNames() {
        return this.child.getResourceLoaderNames();
    }

    @Override
    public List<ResourceLoader> getResourceLoaders() {
        return this.child.getResourceLoaders();
    }

    @Override
    public void removeResourceLoader(QName name) {
        this.child.removeResourceLoader(name);
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getContents(String indent, boolean servicePerLine) {
        StringBuilder contents = new StringBuilder();
        contents.append(this.parent.getContents(indent, servicePerLine)).append("\n");
        contents.append(this.child.getContents(indent, servicePerLine));
        return contents.toString();
    }
}

