/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.web.spring.NotificationController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class ContentTypeController
extends MultiActionController {
    private static String view = "";
    protected NotificationService notificationService;
    protected NotificationContentTypeService notificationContentTypeService;
    protected NotificationAuthorizationService notificationAuthzService;
    private static final Logger LOG = LogManager.getLogger(NotificationController.class);

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNotificationContentTypeService(NotificationContentTypeService notificationContentTypeService) {
        this.notificationContentTypeService = notificationContentTypeService;
    }

    public void setNotificationAuthorizationService(NotificationAuthorizationService notificationAuthzService) {
        this.notificationAuthzService = notificationAuthzService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user = request.getRemoteUser();
        if (!this.notificationAuthzService.isUserAdministrator(user)) {
            response.setStatus(403);
            throw new SecurityException("User " + user + " is not a Notification System administrator");
        }
        return super.handleRequestInternal(request, response);
    }

    public ModelAndView displayContentTypes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "ContentTypeManager";
        Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
        HashMap<String, Collection<NotificationContentTypeBo>> model = new HashMap<String, Collection<NotificationContentTypeBo>>();
        model.put("contentTypes", contentTypes);
        return new ModelAndView(view, model);
    }

    public ModelAndView displayContentTypeForm(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        NotificationContentTypeBo notificationContentType;
        String actionrequested;
        view = "ContentTypeForm";
        String name = request.getParameter("name");
        LOG.debug("name param: " + name);
        if (name == null) {
            actionrequested = new String("add");
            notificationContentType = new NotificationContentTypeBo();
        } else {
            actionrequested = new String("update");
            notificationContentType = this.notificationContentTypeService.getNotificationContentType(name);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("notificationContentType", (Object)notificationContentType);
        model.put("actionrequested", actionrequested);
        return new ModelAndView(view, model);
    }

    public ModelAndView addContentType(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "ContentTypeManager";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String namespace = request.getParameter("namespace");
        String xsd = request.getParameter("xsd");
        String xsl = request.getParameter("xsl");
        LOG.debug("id: " + id);
        LOG.debug("name: " + name);
        LOG.debug("description: " + description);
        LOG.debug("namespace: " + namespace);
        LOG.debug("xsd: " + xsd);
        LOG.debug("xsl: " + xsl);
        NotificationContentTypeBo notificationContentType = new NotificationContentTypeBo();
        notificationContentType.setName(name);
        notificationContentType.setDescription(description);
        notificationContentType.setNamespace(namespace);
        notificationContentType.setXsd(xsd);
        notificationContentType.setXsl(xsl);
        this.notificationContentTypeService.saveNotificationContentType(notificationContentType);
        Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
        HashMap<String, Collection<NotificationContentTypeBo>> model = new HashMap<String, Collection<NotificationContentTypeBo>>();
        model.put("contentTypes", contentTypes);
        return new ModelAndView(view, model);
    }

    public ModelAndView updateContentType(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "ContentTypeManager";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String namespace = request.getParameter("namespace");
        String xsd = request.getParameter("xsd");
        String xsl = request.getParameter("xsl");
        LOG.debug("id: " + id);
        LOG.debug("name: " + name);
        LOG.debug("description: " + description);
        LOG.debug("namespace: " + namespace);
        LOG.debug("xsd: " + xsd);
        LOG.debug("xsl: " + xsl);
        NotificationContentTypeBo notificationContentType = this.notificationContentTypeService.getNotificationContentType(name);
        notificationContentType.setName(name);
        notificationContentType.setDescription(description);
        notificationContentType.setNamespace(namespace);
        notificationContentType.setXsd(xsd);
        notificationContentType.setXsl(xsl);
        this.notificationContentTypeService.saveNotificationContentType(notificationContentType);
        Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
        HashMap<String, Collection<NotificationContentTypeBo>> model = new HashMap<String, Collection<NotificationContentTypeBo>>();
        model.put("contentTypes", contentTypes);
        return new ModelAndView(view, model);
    }
}

