/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Function;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.api.search.SearchExpressionUtils;
import org.kuali.rice.core.api.uif.AttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.core.framework.resourceloader.ObjectDefinitionResolver;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.docsearch.SearchableAttributeDateTimeValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeFloatValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeLongValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeStringValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentSearchInternalUtils {
    private static final Logger LOG = LogManager.getLogger(DocumentSearchInternalUtils.class);
    private static final boolean CASE_SENSITIVE_DEFAULT = false;
    private static final String STRING_ATTRIBUTE_TABLE_NAME = "KREW_DOC_HDR_EXT_T";
    private static final String DATE_TIME_ATTRIBUTE_TABLE_NAME = "KREW_DOC_HDR_EXT_DT_T";
    private static final String DECIMAL_ATTRIBUTE_TABLE_NAME = "KREW_DOC_HDR_EXT_FLT_T";
    private static final String INTEGER_ATTRIBUTE_TABLE_NAME = "KREW_DOC_HDR_EXT_LONG_T";
    private static final List<SearchableAttributeConfiguration> CONFIGURATIONS = new ArrayList<SearchableAttributeConfiguration>();
    public static final List<Class<? extends SearchableAttributeValue>> SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST = new ArrayList<Class<? extends SearchableAttributeValue>>();

    private static ObjectMapper getObjectMapper() {
        return ObjectMapperHolder.objectMapper;
    }

    public static boolean isLookupCaseSensitive(RemotableAttributeField remotableAttributeField) {
        if (remotableAttributeField == null) {
            throw new IllegalArgumentException("remotableAttributeField was null");
        }
        AttributeLookupSettings lookupSettings = remotableAttributeField.getAttributeLookupSettings();
        if (lookupSettings != null && lookupSettings.isCaseSensitive() != null) {
            return lookupSettings.isCaseSensitive();
        }
        return false;
    }

    public static String getAttributeTableName(RemotableAttributeField attributeField) {
        return DocumentSearchInternalUtils.getConfigurationForField(attributeField).getTableName();
    }

    public static Class<?> getDataTypeClass(RemotableAttributeField attributeField) {
        return DocumentSearchInternalUtils.getConfigurationForField(attributeField).getDataTypeClass();
    }

    private static SearchableAttributeConfiguration getConfigurationForField(RemotableAttributeField attributeField) {
        for (SearchableAttributeConfiguration configuration : CONFIGURATIONS) {
            DataType dataType = attributeField.getDataType();
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (!configuration.getSupportedDataTypes().contains(dataType)) continue;
            return configuration;
        }
        throw new IllegalArgumentException("Failed to determine proper searchable attribute configuration for given data type of '" + attributeField.getDataType() + "'");
    }

    public static List<SearchableAttributeValue> getSearchableAttributeValueObjectTypes() {
        ArrayList<SearchableAttributeValue> searchableAttributeValueClasses = new ArrayList<SearchableAttributeValue>();
        for (Class<? extends SearchableAttributeValue> searchAttributeValueClass : SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST) {
            ObjectDefinition objDef = new ObjectDefinition(searchAttributeValueClass);
            SearchableAttributeValue attributeValue = (SearchableAttributeValue)ObjectDefinitionResolver.createObject((ObjectDefinition)objDef, (ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (boolean)false);
            searchableAttributeValueClasses.add(attributeValue);
        }
        return searchableAttributeValueClasses;
    }

    public static SearchableAttributeValue getSearchableAttributeValueByDataTypeString(String dataType) {
        Object returnableValue = null;
        if (StringUtils.isBlank((String)dataType)) {
            return returnableValue;
        }
        for (SearchableAttributeValue attValue : DocumentSearchInternalUtils.getSearchableAttributeValueObjectTypes()) {
            if (!dataType.equalsIgnoreCase(attValue.getAttributeDataType())) continue;
            if (returnableValue != null) {
                String errorMsg = "Found two SearchableAttributeValue objects with same data type string ('" + dataType + "' while ignoring case):  " + returnableValue.getClass().getName() + " and " + attValue.getClass().getName();
                LOG.error("getSearchableAttributeValueByDataTypeString() " + errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOG.debug("getSearchableAttributeValueByDataTypeString() SearchableAttributeValue class name is " + attValue.getClass().getName() + "... ojbConcreteClassName is " + attValue.getOjbConcreteClass());
            ObjectDefinition objDef = new ObjectDefinition(attValue.getClass());
            returnableValue = (SearchableAttributeValue)ObjectDefinitionResolver.createObject((ObjectDefinition)objDef, (ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (boolean)false);
        }
        return returnableValue;
    }

    public static String getDisplayValueWithDateOnly(DateTime value) {
        return DocumentSearchInternalUtils.getDisplayValueWithDateOnly(new Timestamp(value.getMillis()));
    }

    public static String getDisplayValueWithDateOnly(Timestamp value) {
        return RiceConstants.getDefaultDateFormat().format(new Date(value.getTime()));
    }

    public static DateTime getLowerDateTimeBound(String dateRange) throws ParseException {
        Range range = SearchExpressionUtils.parseRange((String)dateRange);
        if (range == null) {
            throw new IllegalArgumentException("Failed to parse date range from given string: " + dateRange);
        }
        if (range.getLowerBoundValue() != null) {
            java.util.Date lowerRangeDate = null;
            try {
                lowerRangeDate = CoreApiServiceLocator.getDateTimeService().convertToDate(range.getLowerBoundValue());
            }
            catch (ParseException pe) {
                GlobalVariables.getMessageMap().putError("dateFrom", "error.custom", new String[]{pe.getMessage()});
            }
            MutableDateTime dateTime = new MutableDateTime((Object)lowerRangeDate);
            dateTime.setMillisOfDay(0);
            return dateTime.toDateTime();
        }
        return null;
    }

    public static DateTime getUpperDateTimeBound(String dateRange) throws ParseException {
        Range range = SearchExpressionUtils.parseRange((String)dateRange);
        if (range == null) {
            throw new IllegalArgumentException("Failed to parse date range from given string: " + dateRange);
        }
        if (range.getUpperBoundValue() != null) {
            java.util.Date upperRangeDate = null;
            try {
                upperRangeDate = CoreApiServiceLocator.getDateTimeService().convertToDate(range.getUpperBoundValue());
            }
            catch (ParseException pe) {
                GlobalVariables.getMessageMap().putError("dateCreated", "error.custom", new String[]{pe.getMessage()});
            }
            MutableDateTime dateTime = new MutableDateTime((Object)upperRangeDate);
            dateTime.setMillisOfDay(86399999);
            return dateTime.toDateTime();
        }
        return null;
    }

    public static DocumentSearchCriteria unmarshalDocumentSearchCriteria(String string) throws IOException {
        DocumentSearchCriteria.Builder builder = (DocumentSearchCriteria.Builder)DocumentSearchInternalUtils.getObjectMapper().readValue(string, DocumentSearchCriteria.Builder.class);
        builder.normalizeDateTimes();
        return builder.build();
    }

    public static String marshalDocumentSearchCriteria(DocumentSearchCriteria criteria) throws IOException {
        return DocumentSearchInternalUtils.getObjectMapper().writeValueAsString((Object)criteria);
    }

    public static List<RemotableAttributeError> validateSearchFieldValues(String fieldName, SearchableAttributeValue attributeValue, List<String> searchValues, String errorMessagePrefix, List<String> resultingValues, Function<String, Collection<RemotableAttributeError>> customValidator) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (CollectionUtils.isEmpty(searchValues)) {
            return errors;
        }
        for (String searchValue : searchValues) {
            errors.addAll(DocumentSearchInternalUtils.validateSearchFieldValue(fieldName, attributeValue, searchValue, errorMessagePrefix, resultingValues, customValidator));
        }
        return Collections.unmodifiableList(errors);
    }

    public static List<RemotableAttributeError> validateSearchFieldValue(String fieldName, SearchableAttributeValue attributeValue, String enteredValue, String errorMessagePrefix, List<String> resultingValues, Function<String, Collection<RemotableAttributeError>> customValidator) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (enteredValue == null) {
            return errors;
        }
        List parsedValues = SQLUtils.getCleanedSearchableValues((String)enteredValue, (String)attributeValue.getAttributeDataType());
        for (String value : parsedValues) {
            errors.addAll(DocumentSearchInternalUtils.validateParsedSearchFieldValue(fieldName, attributeValue, value, errorMessagePrefix, resultingValues, customValidator));
        }
        return errors;
    }

    public static Collection<RemotableAttributeError> validateParsedSearchFieldValue(String fieldName, SearchableAttributeValue attributeValue, String parsedValue, String errorMessagePrefix, List<String> resultingValues, Function<String, Collection<RemotableAttributeError>> customValidator) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>(1);
        String value = parsedValue;
        if (attributeValue.allowsWildcards()) {
            value = value.replaceAll("\\*", "");
        }
        if (resultingValues != null) {
            resultingValues.add(value);
        }
        if (!attributeValue.isPassesDefaultValidation(value)) {
            errorMessagePrefix = StringUtils.isNotBlank((String)errorMessagePrefix) ? errorMessagePrefix : "Field";
            String errorMsg = errorMessagePrefix + " with value '" + value + "' does not conform to standard validation for field type.";
            LOG.debug("validateSimpleSearchFieldValue: " + errorMsg + " :: field type '" + attributeValue.getAttributeDataType() + "'");
            errors.add(RemotableAttributeError.Builder.create((String)fieldName, (String[])new String[]{errorMsg}).build());
        } else if (customValidator != null) {
            errors.addAll((Collection)customValidator.apply((Object)value));
        }
        return Collections.unmodifiableCollection(errors);
    }

    public static DataType convertValueToDataType(String dataTypeValue) {
        if (StringUtils.isBlank((String)dataTypeValue)) {
            return DataType.STRING;
        }
        if ("string".equals(dataTypeValue)) {
            return DataType.STRING;
        }
        if ("datetime".equals(dataTypeValue)) {
            return DataType.DATE;
        }
        if ("long".equals(dataTypeValue)) {
            return DataType.LONG;
        }
        if ("float".equals(dataTypeValue)) {
            return DataType.FLOAT;
        }
        throw new IllegalArgumentException("Invalid dataTypeValue was given: " + dataTypeValue);
    }

    static {
        SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST.add(SearchableAttributeStringValue.class);
        SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST.add(SearchableAttributeFloatValue.class);
        SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST.add(SearchableAttributeLongValue.class);
        SEARCHABLE_ATTRIBUTE_BASE_CLASS_LIST.add(SearchableAttributeDateTimeValue.class);
        CONFIGURATIONS.add(new SearchableAttributeConfiguration(STRING_ATTRIBUTE_TABLE_NAME, EnumSet.of(DataType.BOOLEAN, DataType.STRING, DataType.MARKUP), String.class));
        CONFIGURATIONS.add(new SearchableAttributeConfiguration(DATE_TIME_ATTRIBUTE_TABLE_NAME, EnumSet.of(DataType.DATE, DataType.TRUNCATED_DATE, DataType.DATETIME), Timestamp.class));
        CONFIGURATIONS.add(new SearchableAttributeConfiguration(DECIMAL_ATTRIBUTE_TABLE_NAME, EnumSet.of(DataType.FLOAT, DataType.DOUBLE, DataType.CURRENCY), Float.TYPE));
        CONFIGURATIONS.add(new SearchableAttributeConfiguration(INTEGER_ATTRIBUTE_TABLE_NAME, EnumSet.of(DataType.INTEGER, DataType.LONG), Long.TYPE));
    }

    public static class SearchableAttributeConfiguration {
        private final String tableName;
        private final EnumSet<DataType> supportedDataTypes;
        private final Class<?> dataTypeClass;

        public SearchableAttributeConfiguration(String tableName, EnumSet<DataType> supportedDataTypes, Class<?> dataTypeClass) {
            this.tableName = tableName;
            this.supportedDataTypes = supportedDataTypes;
            this.dataTypeClass = dataTypeClass;
        }

        public String getTableName() {
            return this.tableName;
        }

        public EnumSet<DataType> getSupportedDataTypes() {
            return this.supportedDataTypes;
        }

        public Class<?> getDataTypeClass() {
            return this.dataTypeClass;
        }
    }

    private static class ObjectMapperHolder {
        static final ObjectMapper objectMapper = ObjectMapperHolder.initializeObjectMapper();

        private ObjectMapperHolder() {
        }

        private static ObjectMapper initializeObjectMapper() {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            jsonMapper.registerModule((Module)new JodaModule());
            return jsonMapper;
        }
    }
}

