/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.kew.api.document.DocumentStatusTransition;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_APP_DOC_STAT_TRAN_T")
public class DocumentStatusTransition
extends PersistableBusinessObjectBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -2212481684546954746L;
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @Column(name="APP_DOC_STAT_TRAN_ID")
    private String statusTransitionId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="APP_DOC_STAT_FROM")
    private String oldAppDocStatus;
    @Column(name="APP_DOC_STAT_TO")
    private String newAppDocStatus;
    @Column(name="STAT_TRANS_DATE")
    private Timestamp statusTransitionDate;
    @ManyToOne
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private DocumentRouteHeaderValue documentRouteHeaderValue;

    public DocumentStatusTransition() {
    }

    public DocumentStatusTransition(String documentId, String oldStatus, String newStatus) {
        this.documentId = documentId;
        this.oldAppDocStatus = oldStatus;
        this.newAppDocStatus = newStatus;
        this.statusTransitionDate = new Timestamp(System.currentTimeMillis());
    }

    public String getStatusTransitionId() {
        return this._persistence_get_statusTransitionId();
    }

    public void setStatusTransitionId(String statusTransitionId) {
        this._persistence_set_statusTransitionId(statusTransitionId);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public String getOldAppDocStatus() {
        return this._persistence_get_oldAppDocStatus();
    }

    public void setOldAppDocStatus(String oldAppDocStatus) {
        this._persistence_set_oldAppDocStatus(oldAppDocStatus);
    }

    public String getNewAppDocStatus() {
        return this._persistence_get_newAppDocStatus();
    }

    public void setNewAppDocStatus(String newAppDocStatus) {
        this._persistence_set_newAppDocStatus(newAppDocStatus);
    }

    public Timestamp getStatusTransitionDate() {
        return this._persistence_get_statusTransitionDate();
    }

    public void setStatusTransitionDate(Timestamp statusTransitionDate) {
        this._persistence_set_statusTransitionDate(statusTransitionDate);
    }

    public DocumentStatusTransition deepCopy(Map<Object, Object> visited) {
        if (visited.containsKey((Object)this)) {
            return (DocumentStatusTransition)((Object)visited.get((Object)this));
        }
        DocumentStatusTransition copy = new DocumentStatusTransition();
        visited.put((Object)this, (Object)copy);
        copy._persistence_set_statusTransitionId(this._persistence_get_statusTransitionId());
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_oldAppDocStatus(this._persistence_get_oldAppDocStatus());
        copy._persistence_set_newAppDocStatus(this._persistence_get_newAppDocStatus());
        if (this._persistence_get_statusTransitionDate() != null) {
            copy._persistence_set_statusTransitionDate(new Timestamp(this._persistence_get_statusTransitionDate().getTime()));
        }
        if (this._persistence_get_documentRouteHeaderValue() != null) {
            copy._persistence_set_documentRouteHeaderValue(this._persistence_get_documentRouteHeaderValue().deepCopy(visited));
        }
        return copy;
    }

    public static DocumentStatusTransition from(org.kuali.rice.kew.api.document.DocumentStatusTransition im) {
        if (im == null) {
            return null;
        }
        DocumentStatusTransition transition = new DocumentStatusTransition(im.getDocumentId(), im.getOldStatus(), im.getNewStatus());
        transition.setStatusTransitionId(im.getId());
        if (im.getStatusTransitionDate() != null) {
            transition.setStatusTransitionDate(new Timestamp(im.getStatusTransitionDate().getMillis()));
        }
        return transition;
    }

    public static org.kuali.rice.kew.api.document.DocumentStatusTransition to(DocumentStatusTransition bo) {
        if (bo == null) {
            return null;
        }
        DocumentStatusTransition.Builder builder = DocumentStatusTransition.Builder.create((String)bo.getDocumentId(), (String)bo.getOldAppDocStatus(), (String)bo.getNewAppDocStatus());
        builder.setId(bo.getStatusTransitionId());
        if (bo.getStatusTransitionDate() != null) {
            builder.setStatusTransitionDate(new DateTime(bo.getStatusTransitionDate().getTime()));
        }
        return builder.build();
    }

    public DocumentRouteHeaderValue getDocumentRouteHeaderValue() {
        return this._persistence_get_documentRouteHeaderValue();
    }

    public void setDocumentRouteHeaderValue(DocumentRouteHeaderValue documentRouteHeaderValue) {
        this._persistence_set_documentRouteHeaderValue(documentRouteHeaderValue);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentStatusTransition();
    }

    public Object _persistence_get(String string) {
        if (string == "statusTransitionDate") {
            return this.statusTransitionDate;
        }
        if (string == "oldAppDocStatus") {
            return this.oldAppDocStatus;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "documentRouteHeaderValue") {
            return this.documentRouteHeaderValue;
        }
        if (string == "statusTransitionId") {
            return this.statusTransitionId;
        }
        if (string == "newAppDocStatus") {
            return this.newAppDocStatus;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "statusTransitionDate") {
            this.statusTransitionDate = (Timestamp)object;
            return;
        }
        if (string == "oldAppDocStatus") {
            this.oldAppDocStatus = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "documentRouteHeaderValue") {
            this.documentRouteHeaderValue = (DocumentRouteHeaderValue)object;
            return;
        }
        if (string == "statusTransitionId") {
            this.statusTransitionId = (String)object;
            return;
        }
        if (string == "newAppDocStatus") {
            this.newAppDocStatus = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Timestamp _persistence_get_statusTransitionDate() {
        this._persistence_checkFetched("statusTransitionDate");
        return this.statusTransitionDate;
    }

    public void _persistence_set_statusTransitionDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("statusTransitionDate");
        this._persistence_propertyChange("statusTransitionDate", this.statusTransitionDate, timestamp);
        this.statusTransitionDate = timestamp;
    }

    public String _persistence_get_oldAppDocStatus() {
        this._persistence_checkFetched("oldAppDocStatus");
        return this.oldAppDocStatus;
    }

    public void _persistence_set_oldAppDocStatus(String string) {
        this._persistence_checkFetchedForSet("oldAppDocStatus");
        this._persistence_propertyChange("oldAppDocStatus", this.oldAppDocStatus, string);
        this.oldAppDocStatus = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this._persistence_propertyChange("documentId", this.documentId, string);
        this.documentId = string;
    }

    public DocumentRouteHeaderValue _persistence_get_documentRouteHeaderValue() {
        this._persistence_checkFetched("documentRouteHeaderValue");
        return this.documentRouteHeaderValue;
    }

    public void _persistence_set_documentRouteHeaderValue(DocumentRouteHeaderValue documentRouteHeaderValue) {
        this._persistence_checkFetchedForSet("documentRouteHeaderValue");
        this._persistence_propertyChange("documentRouteHeaderValue", this.documentRouteHeaderValue, documentRouteHeaderValue);
        this.documentRouteHeaderValue = documentRouteHeaderValue;
    }

    public String _persistence_get_statusTransitionId() {
        this._persistence_checkFetched("statusTransitionId");
        return this.statusTransitionId;
    }

    public void _persistence_set_statusTransitionId(String string) {
        this._persistence_checkFetchedForSet("statusTransitionId");
        this._persistence_propertyChange("statusTransitionId", this.statusTransitionId, string);
        this.statusTransitionId = string;
    }

    public String _persistence_get_newAppDocStatus() {
        this._persistence_checkFetched("newAppDocStatus");
        return this.newAppDocStatus;
    }

    public void _persistence_set_newAppDocStatus(String string) {
        this._persistence_checkFetchedForSet("newAppDocStatus");
        this._persistence_propertyChange("newAppDocStatus", this.newAppDocStatus, string);
        this.newAppDocStatus = string;
    }
}

