/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class MessageSendingTransactionSynchronization
extends TransactionSynchronizationAdapter {
    private static final Logger LOG = LogManager.getLogger(MessageSendingTransactionSynchronization.class);
    public static final AtomicBoolean CALLED_TRANS_COMMITTED = new AtomicBoolean(false);
    public static final AtomicBoolean CALLED_TRANS_ROLLEDBACKED = new AtomicBoolean(false);
    private final PersistedMessageBO message;

    public MessageSendingTransactionSynchronization(PersistedMessageBO message) {
        this.message = message;
    }

    public void afterCompletion(int status) {
        if (status == 0) {
            KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(this.message));
            CALLED_TRANS_COMMITTED.set(true);
        } else {
            LOG.info("Message " + this.message + " not sent because transaction not committed.");
            CALLED_TRANS_ROLLEDBACKED.set(true);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

