/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.security.Signature;
import java.security.cert.Certificate;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.security.AbstractDigitalSigner;

public class ResponseHeaderDigitalSigner
extends AbstractDigitalSigner {
    private String alias;
    private Certificate certificate;
    private HttpServletResponse response;

    public ResponseHeaderDigitalSigner(Signature signature, String alias, HttpServletResponse response) {
        super(signature);
        this.alias = alias;
        this.response = response;
    }

    public ResponseHeaderDigitalSigner(Signature signature, String alias, Certificate certificate, HttpServletResponse response) {
        this(signature, alias, response);
        this.certificate = certificate;
    }

    public ResponseHeaderDigitalSigner(Signature signature, Certificate certificate, HttpServletResponse response) {
        super(signature);
        this.certificate = certificate;
        this.response = response;
    }

    @Override
    public void sign() throws Exception {
        if (StringUtils.isNotBlank((String)this.alias)) {
            this.response.setHeader("KEW_KEYSTORE_ALIAS", this.alias);
        }
        if (this.certificate != null) {
            this.response.setHeader("KEW_CERTIFICATE_ALIAS", this.getEncodedCertificate(this.certificate));
        }
        this.response.setHeader("KEW_DIGITAL_SIGNATURE", this.getEncodedSignature());
    }
}

