/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Collections;
import java.util.List;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBLifeCycleListener;
import org.apache.ojb.broker.PBListener;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBrokerEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.util.IdentityArrayList;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class PersistenceBrokerAbstractImpl
implements PersistenceBrokerInternal {
    private boolean txCheck;
    private List permanentStateListeners = Collections.synchronizedList(new IdentityArrayList());
    private List temporaryStateListeners = Collections.synchronizedList(new IdentityArrayList());
    private List permanentLifeCycleListeners = Collections.synchronizedList(new IdentityArrayList(100));
    private List temporaryLifeCycleListeners = Collections.synchronizedList(new IdentityArrayList(100));
    protected final PBStateEvent AFTER_OPEN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_OPEN);
    protected final PBStateEvent AFTER_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_BEGIN);
    protected final PBStateEvent AFTER_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_COMMIT);
    protected final PBStateEvent AFTER_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_ROLLBACK);
    protected final PBStateEvent BEFORE_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_BEGIN);
    protected final PBStateEvent BEFORE_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_COMMIT);
    protected final PBStateEvent BEFORE_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_ROLLBACK);
    protected final PBStateEvent BEFORE_CLOSE_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_CLOSE);
    protected PBLifeCycleEvent BEFORE_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_INSERT);
    protected PBLifeCycleEvent AFTER_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_INSERT);
    protected PBLifeCycleEvent BEFORE_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_DELETE);
    protected PBLifeCycleEvent AFTER_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_DELETE);
    protected PBLifeCycleEvent AFTER_LOOKUP_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    protected PBLifeCycleEvent BEFORE_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_UPDATE);
    protected PBLifeCycleEvent AFTER_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_UPDATE);

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.txCheck = configuration.getBoolean("TxCheck", false);
    }

    public boolean isTxCheck() {
        return this.txCheck;
    }

    public void setTxCheck(boolean bl) {
        this.txCheck = bl;
    }

    @Override
    public void addListener(PBListener pBListener) throws PersistenceBrokerException {
        this.addListener(pBListener, false);
    }

    @Override
    public void addListener(PBListener pBListener, boolean bl) throws PersistenceBrokerException {
        if (pBListener instanceof PBStateListener) {
            if (bl) {
                if (!this.permanentStateListeners.contains(pBListener)) {
                    this.permanentStateListeners.add(pBListener);
                }
            } else if (!this.temporaryStateListeners.contains(pBListener)) {
                this.temporaryStateListeners.add(pBListener);
            }
        }
        if (pBListener instanceof PBLifeCycleListener) {
            if (bl) {
                if (!this.permanentLifeCycleListeners.contains(pBListener)) {
                    this.permanentLifeCycleListeners.add(pBListener);
                }
            } else if (!this.temporaryLifeCycleListeners.contains(pBListener)) {
                this.temporaryLifeCycleListeners.add(pBListener);
            }
        }
    }

    @Override
    public void removeListener(PBListener pBListener) throws PersistenceBrokerException {
        if (pBListener instanceof PBStateListener) {
            this.permanentStateListeners.remove(pBListener);
            this.temporaryStateListeners.remove(pBListener);
        }
        if (pBListener instanceof PBLifeCycleListener) {
            this.permanentLifeCycleListeners.remove(pBListener);
            this.temporaryLifeCycleListeners.remove(pBListener);
        }
    }

    @Override
    public void removeAllListeners(boolean bl) throws PersistenceBrokerException {
        if (bl) {
            this.permanentStateListeners.clear();
            if (this.permanentLifeCycleListeners.size() > 10000) {
                this.permanentLifeCycleListeners = Collections.synchronizedList(new IdentityArrayList(100));
            } else {
                this.permanentLifeCycleListeners.clear();
            }
        }
        this.temporaryStateListeners.clear();
        if (this.temporaryLifeCycleListeners.size() > 10000) {
            this.temporaryLifeCycleListeners = Collections.synchronizedList(new IdentityArrayList(100));
        } else {
            this.temporaryLifeCycleListeners.clear();
        }
    }

    @Override
    public void removeAllListeners() throws PersistenceBrokerException {
        this.removeAllListeners(false);
    }

    @Override
    public void fireBrokerEvent(PersistenceBrokerEvent persistenceBrokerEvent) {
        if (persistenceBrokerEvent instanceof PBLifeCycleEvent) {
            this.fireBrokerEvent((PBLifeCycleEvent)persistenceBrokerEvent);
        } else if (persistenceBrokerEvent instanceof PBStateEvent) {
            this.fireBrokerEvent((PBStateEvent)persistenceBrokerEvent);
        } else {
            LoggerFactory.getDefaultLogger().error(PersistenceBrokerAbstractImpl.class.getName() + ": Unkown PersistenceBrokerEvent was fired " + persistenceBrokerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBrokerEvent(PBLifeCycleEvent pBLifeCycleEvent) {
        int n;
        if (pBLifeCycleEvent.getPersitenceBrokerAware() != null) {
            this.performCallBack(pBLifeCycleEvent);
        }
        List list = this.permanentLifeCycleListeners;
        synchronized (list) {
            for (n = this.permanentLifeCycleListeners.size() - 1; n >= 0; --n) {
                this.notifiyObjectLifeCycleListener((PBLifeCycleListener)this.permanentLifeCycleListeners.get(n), pBLifeCycleEvent);
            }
        }
        list = this.temporaryLifeCycleListeners;
        synchronized (list) {
            for (n = this.temporaryLifeCycleListeners.size() - 1; n >= 0; --n) {
                this.notifiyObjectLifeCycleListener((PBLifeCycleListener)this.temporaryLifeCycleListeners.get(n), pBLifeCycleEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBrokerEvent(PBStateEvent pBStateEvent) {
        int n;
        List list = this.permanentStateListeners;
        synchronized (list) {
            for (n = this.permanentStateListeners.size() - 1; n >= 0; --n) {
                this.notifiyStateListener((PBStateListener)this.permanentStateListeners.get(n), pBStateEvent);
            }
        }
        list = this.temporaryStateListeners;
        synchronized (list) {
            for (n = this.temporaryStateListeners.size() - 1; n >= 0; --n) {
                this.notifiyStateListener((PBStateListener)this.temporaryStateListeners.get(n), pBStateEvent);
            }
        }
    }

    private void performCallBack(PBLifeCycleEvent pBLifeCycleEvent) {
        if (pBLifeCycleEvent.getPersitenceBrokerAware() == null) {
            return;
        }
        switch (pBLifeCycleEvent.getEventType().typeId()) {
            case 6: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterLookup(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 3: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeUpdate(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 4: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterUpdate(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 1: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeInsert(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 7: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterInsert(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 2: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeDelete(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 5: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterDelete(pBLifeCycleEvent.getTriggeringBroker());
            }
        }
    }

    private void notifiyStateListener(PBStateListener pBStateListener, PBStateEvent pBStateEvent) {
        switch (pBStateEvent.getEventType().typeId()) {
            case 3: {
                pBStateListener.beforeCommit(pBStateEvent);
                break;
            }
            case 6: {
                pBStateListener.afterCommit(pBStateEvent);
                break;
            }
            case 2: {
                pBStateListener.beforeBegin(pBStateEvent);
                break;
            }
            case 5: {
                pBStateListener.afterBegin(pBStateEvent);
                break;
            }
            case 1: {
                pBStateListener.beforeClose(pBStateEvent);
                break;
            }
            case 7: {
                pBStateListener.afterOpen(pBStateEvent);
                break;
            }
            case 8: {
                pBStateListener.afterRollback(pBStateEvent);
                break;
            }
            case 4: {
                pBStateListener.beforeRollback(pBStateEvent);
            }
        }
    }

    private void notifiyObjectLifeCycleListener(PBLifeCycleListener pBLifeCycleListener, PBLifeCycleEvent pBLifeCycleEvent) {
        switch (pBLifeCycleEvent.getEventType().typeId()) {
            case 6: {
                pBLifeCycleListener.afterLookup(pBLifeCycleEvent);
                break;
            }
            case 3: {
                pBLifeCycleListener.beforeUpdate(pBLifeCycleEvent);
                break;
            }
            case 4: {
                pBLifeCycleListener.afterUpdate(pBLifeCycleEvent);
                break;
            }
            case 1: {
                pBLifeCycleListener.beforeInsert(pBLifeCycleEvent);
                break;
            }
            case 7: {
                pBLifeCycleListener.afterInsert(pBLifeCycleEvent);
                break;
            }
            case 2: {
                pBLifeCycleListener.beforeDelete(pBLifeCycleEvent);
                break;
            }
            case 5: {
                pBLifeCycleListener.afterDelete(pBLifeCycleEvent);
            }
        }
    }
}

