/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.Collection;
import org.drools.core.command.runtime.GetFactCountInEntryPointCommand;
import org.drools.core.command.runtime.rule.DeleteFromEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandleInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectsInEntryPointCommand;
import org.drools.core.command.runtime.rule.InsertObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.UpdateInEntryPointCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class CommandBasedEntryPoint
implements EntryPoint {
    private final ExecutableRunner runner;
    private final String entryPoint;

    public CommandBasedEntryPoint(ExecutableRunner runner, String entryPoint) {
        this.runner = runner;
        this.entryPoint = entryPoint;
    }

    public String getEntryPointId() {
        return this.entryPoint;
    }

    public FactHandle insert(Object object) {
        return (FactHandle)this.runner.execute((Command)new InsertObjectInEntryPointCommand(object, this.entryPoint));
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.runner.execute((Command)new DeleteFromEntryPointCommand(handle, this.entryPoint));
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.runner.execute((Command)new DeleteFromEntryPointCommand(handle, this.entryPoint, fhState));
    }

    public void update(FactHandle handle, Object object) {
        this.runner.execute((Command)new UpdateInEntryPointCommand(handle, object, this.entryPoint));
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        this.runner.execute((Command)new UpdateInEntryPointCommand(handle, object, this.entryPoint, modifiedProperties));
    }

    public FactHandle getFactHandle(Object object) {
        return (FactHandle)this.runner.execute((Command)new GetFactHandleInEntryPointCommand(object, this.entryPoint));
    }

    public Object getObject(FactHandle factHandle) {
        return this.runner.execute((Command)new GetObjectInEntryPointCommand(factHandle, this.entryPoint));
    }

    public Collection<? extends Object> getObjects() {
        return (Collection)this.runner.execute((Command)new GetObjectsInEntryPointCommand(null, this.entryPoint));
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return (Collection)this.runner.execute((Command)new GetObjectsInEntryPointCommand(filter, this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return (Collection)this.runner.execute((Command)new GetFactHandlesInEntryPointCommand(this.entryPoint));
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return (Collection)this.runner.execute((Command)new GetFactHandlesInEntryPointCommand(this.entryPoint, filter));
    }

    public long getFactCount() {
        return (Long)this.runner.execute((Command)new GetFactCountInEntryPointCommand(this.entryPoint));
    }
}

