/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Bag<T>
implements Collection<T>,
Serializable {
    private Map<T, Counter> map = new HashMap<T, Counter>();
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    public int getKeySize() {
        return this.map.size();
    }

    public int sizeFor(T t) {
        Counter i = this.map.get(t);
        return i != null ? i.get() : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(T t) {
        Counter i = this.map.get(t);
        if (i == null) {
            this.map.put(t, new Counter());
        } else {
            i.increment();
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Counter i = this.map.get(o);
        if (i == null) {
            return false;
        }
        if (i.decrement()) {
            this.map.remove(o);
        }
        --this.size;
        return true;
    }

    public boolean removeKey(Object o) {
        Counter i = this.map.remove(o);
        if (i != null) {
            this.size -= i.get();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result = this.remove(o) || result;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public String toString() {
        return this.map.toString();
    }

    public static class Counter
    implements Serializable {
        private int count;

        public Counter() {
            this(1);
        }

        public Counter(int count) {
            this.count = count;
        }

        public void increment() {
            ++this.count;
        }

        public boolean decrement() {
            return --this.count == 0;
        }

        public int get() {
            return this.count;
        }

        public String toString() {
            return "" + this.count;
        }
    }
}

