/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import java.util.List;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.LegendText;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class LegendComposer
implements RrdGraphConstants {
    private RrdGraphDef gdef;
    private ImageWorker worker;
    private int legX;
    private int legY;
    private int legWidth;
    private double interlegendSpace;
    private double leading;
    private double smallLeading;
    private double boxSpace;

    LegendComposer(RrdGraph rrdGraph, int legX, int legY, int legWidth) {
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
        this.legX = legX;
        this.legY = legY;
        this.legWidth = legWidth;
        this.interlegendSpace = rrdGraph.getInterlegendSpace();
        this.leading = rrdGraph.getLeading();
        this.smallLeading = rrdGraph.getSmallLeading();
        this.boxSpace = rrdGraph.getBoxSpace();
    }

    int placeComments() {
        Line line = new Line();
        for (CommentText comment : this.gdef.comments) {
            if (!comment.isValidGraphElement()) continue;
            if (!line.canAccomodate(comment)) {
                line.layoutAndAdvance(false);
                line.clear();
            }
            line.add(comment);
        }
        line.layoutAndAdvance(true);
        this.worker.dispose();
        return this.legY;
    }

    class Line {
        private String lastMarker;
        private double width;
        private int spaceCount;
        private boolean noJustification;
        private List<CommentText> comments = new ArrayList<CommentText>();

        Line() {
            this.clear();
        }

        void clear() {
            this.lastMarker = "";
            this.width = 0.0;
            this.spaceCount = 0;
            this.noJustification = false;
            this.comments.clear();
        }

        boolean canAccomodate(CommentText comment) {
            if (this.comments.size() == 0) {
                return true;
            }
            if (this.lastMarker.equals("\\l") || this.lastMarker.equals("\\c") || this.lastMarker.equals("\\r") || this.lastMarker.equals("\\j") || this.lastMarker.equals("\\s")) {
                return false;
            }
            double commentWidth = this.getCommentWidth(comment);
            if (!this.lastMarker.equals("\\g")) {
                commentWidth += LegendComposer.this.interlegendSpace;
            }
            return this.width + commentWidth <= (double)LegendComposer.this.legWidth;
        }

        void add(CommentText comment) {
            double commentWidth = this.getCommentWidth(comment);
            if (this.comments.size() > 0 && !this.lastMarker.equals("\\g")) {
                commentWidth += LegendComposer.this.interlegendSpace;
                ++this.spaceCount;
            }
            this.width += commentWidth;
            this.lastMarker = comment.marker;
            this.noJustification |= this.lastMarker.equals("\\J");
            this.comments.add(comment);
        }

        void layoutAndAdvance(boolean isLastLine) {
            if (this.comments.size() > 0) {
                if (this.lastMarker.equals("\\l")) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interlegendSpace);
                } else if (this.lastMarker.equals("\\r")) {
                    this.placeComments((double)(LegendComposer.this.legX + LegendComposer.this.legWidth) - this.width, LegendComposer.this.interlegendSpace);
                } else if (this.lastMarker.equals("\\c")) {
                    this.placeComments((double)LegendComposer.this.legX + ((double)LegendComposer.this.legWidth - this.width) / 2.0, LegendComposer.this.interlegendSpace);
                } else if (this.lastMarker.equals("\\j")) {
                    if (this.spaceCount > 0) {
                        this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interlegendSpace);
                    } else {
                        this.placeComments(LegendComposer.this.legX, LegendComposer.this.interlegendSpace);
                    }
                } else if (this.lastMarker.equals("\\s")) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interlegendSpace);
                } else if (this.noJustification || isLastLine) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interlegendSpace);
                } else {
                    this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interlegendSpace);
                }
                if (this.lastMarker.equals("\\s")) {
                    LegendComposer legendComposer = LegendComposer.this;
                    legendComposer.legY = (int)((double)legendComposer.legY + LegendComposer.this.smallLeading);
                } else {
                    LegendComposer legendComposer = LegendComposer.this;
                    legendComposer.legY = (int)((double)legendComposer.legY + LegendComposer.this.leading);
                }
            }
        }

        private double getCommentWidth(CommentText comment) {
            double commentWidth = LegendComposer.this.worker.getStringWidth(comment.resolvedText, ((LegendComposer)LegendComposer.this).gdef.smallFont);
            if (comment instanceof LegendText) {
                commentWidth += LegendComposer.this.boxSpace;
            }
            return commentWidth;
        }

        private void placeComments(double xStart, double space) {
            double x = xStart;
            for (CommentText comment : this.comments) {
                comment.x = (int)x;
                comment.y = LegendComposer.this.legY;
                x += this.getCommentWidth(comment);
                if (comment.marker.equals("\\g")) continue;
                x += space;
            }
        }
    }
}

