/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.RestServiceConfiguration;

public class RestServiceDefinition
extends AbstractServiceDefinition {
    private static final long serialVersionUID = 5892163789061959602L;
    private String resourceClass;
    private transient List<Object> resources;
    private BidiMap resourceToClassNameMap;
    private transient List<Object> providers;
    private transient Map<Object, Object> extensionMappings;
    private transient Map<Object, Object> languageMappings;

    public RestServiceDefinition() {
        this.setBusSecurity(false);
    }

    @Override
    public String getType() {
        return "REST";
    }

    @Override
    public void setBusSecurity(Boolean busSecurity) {
        if (busSecurity.booleanValue()) {
            throw new RiceRuntimeException("Rice does not support bus security (digital request/response signing) for RESTful services");
        }
        super.setBusSecurity(busSecurity);
    }

    public void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public String getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public void validate() {
        List<Object> resources = this.getResources();
        if (resources != null && !resources.isEmpty()) {
            this.resourceToClassNameMap = new DualHashBidiMap();
            for (Object resource : resources) {
                Class<?> resourceClass;
                if (this.getService() == null) {
                    this.setService(resource);
                }
                if ((resourceClass = resource.getClass()) == null) continue;
                Class[] interfaces = null;
                interfaces = resourceClass.isInterface() ? new Class[]{resourceClass} : resourceClass.getInterfaces();
                if (interfaces == null) continue;
                for (Class iface : interfaces) {
                    Path pathAnnotation = iface.getAnnotation(Path.class);
                    if (pathAnnotation != null) {
                        String pathAnnotationValue = pathAnnotation.value();
                        String resourceId = pathAnnotationValue == null || pathAnnotationValue.equals("/") ? iface.getSimpleName() : pathAnnotationValue;
                        this.resourceToClassNameMap.put((Object)resourceId, (Object)iface.getName());
                        continue;
                    }
                    this.resourceToClassNameMap.put((Object)iface.getSimpleName(), (Object)iface.getName());
                }
            }
        }
        super.validate();
        if (this.getResourceClass() == null) {
            Class<?>[] interfaces = this.getService().getClass().getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                this.setResourceClass(interfaces[0].getName());
            } else {
                throw new ConfigurationException("resource class must be set to export a REST service");
            }
        }
        try {
            Class.forName(this.getResourceClass());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("resource class '" + this.getResourceClass() + "' could not be found in the classpath", (Throwable)e);
        }
    }

    @Override
    protected ServiceConfiguration configure() {
        return RestServiceConfiguration.fromServiceDefinition(this);
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public void setResources(List<Object> resources) {
        this.resources = resources;
    }

    public Map<String, String> getResourceToClassNameMap() {
        return this.resourceToClassNameMap;
    }

    public boolean hasClass(String className) {
        if (this.resourceToClassNameMap == null) {
            return false;
        }
        return this.resourceToClassNameMap.containsValue((Object)className);
    }

    public List<Object> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }

    public Map<Object, Object> getExtensionMappings() {
        return this.extensionMappings;
    }

    public void setExtensionMappings(Map<Object, Object> extensionMappings) {
        this.extensionMappings = extensionMappings;
    }

    public Map<Object, Object> getLanguageMappings() {
        return this.languageMappings;
    }

    public void setLanguageMappings(Map<Object, Object> languageMappings) {
        this.languageMappings = languageMappings;
    }
}

