/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorManager {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorManager.class);
    private String defaultPU = "org.jbpm.persistence.jpa";

    public DeploymentDescriptorManager() {
    }

    public DeploymentDescriptorManager(String defaultPU) {
        this.defaultPU = defaultPU;
    }

    public DeploymentDescriptor getDefaultDescriptor() {
        DeploymentDescriptor defaultDesc = null;
        URL defaultDescriptorLocation = this.getDefaultdescriptorlocation();
        if (defaultDescriptorLocation != null) {
            try {
                logger.debug("Reading default descriptor from " + defaultDescriptorLocation);
                defaultDesc = DeploymentDescriptorIO.fromXml(defaultDescriptorLocation.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read default deployment descriptor from " + defaultDescriptorLocation, e);
            }
        } else {
            logger.debug("No descriptor found returning default instance");
            defaultDesc = new DeploymentDescriptorImpl(this.defaultPU);
        }
        return defaultDesc;
    }

    protected URL getDefaultdescriptorlocation() {
        URL locationUrl;
        block6: {
            String defaultDescriptorLocation = System.getProperty("org.kie.deployment.desc.location");
            locationUrl = null;
            if (defaultDescriptorLocation != null) {
                if (defaultDescriptorLocation.startsWith("classpath:")) {
                    String stripedLocation = defaultDescriptorLocation.replaceFirst("classpath:", "");
                    locationUrl = this.getClass().getResource(stripedLocation);
                    if (locationUrl == null) {
                        locationUrl = Thread.currentThread().getContextClassLoader().getResource(stripedLocation);
                    }
                } else {
                    try {
                        locationUrl = new URL(defaultDescriptorLocation);
                    }
                    catch (MalformedURLException e) {
                        locationUrl = this.getClass().getResource(defaultDescriptorLocation);
                        if (locationUrl != null) break block6;
                        locationUrl = Thread.currentThread().getContextClassLoader().getResource(defaultDescriptorLocation);
                    }
                }
            }
        }
        return locationUrl;
    }
}

