/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.validation;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleDelegationContract;
import org.kuali.rice.kew.api.validation.RuleValidationContextContract;
import org.w3c.dom.Element;

@XmlRootElement(name="ruleValidationContext")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RuleValidationContextType", propOrder={"rule", "ruleDelegation", "ruleAuthorPrincipalId", "_futureElements"})
public class RuleValidationContext
extends AbstractDataTransferObject
implements RuleValidationContextContract {
    @XmlElement(name="rule", required=true)
    private final Rule rule;
    @XmlElement(name="ruleDelegation", required=true)
    private final RuleDelegation ruleDelegation;
    @XmlElement(name="ruleAuthorPrincipalId", required=false)
    private final String ruleAuthorPrincipalId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RuleValidationContext() {
        this.rule = null;
        this.ruleDelegation = null;
        this.ruleAuthorPrincipalId = null;
    }

    private RuleValidationContext(Builder builder) {
        this.rule = builder.getRule().build();
        this.ruleDelegation = builder.getRuleDelegation() != null ? builder.getRuleDelegation().build() : null;
        this.ruleAuthorPrincipalId = builder.getRuleAuthorPrincipalId();
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public String getRuleAuthorPrincipalId() {
        return this.ruleAuthorPrincipalId;
    }

    @Override
    public RuleDelegation getRuleDelegation() {
        return this.ruleDelegation;
    }

    static class Elements {
        static final String RULE = "rule";
        static final String RULE_DELEGATION = "ruleDelegation";
        static final String RULE_AUTHOR_PRINCIPAL_ID = "ruleAuthorPrincipalId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "ruleValidationContext";
        static final String TYPE_NAME = "RuleValidationContextType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RuleValidationContextContract {
        private Rule.Builder rule;
        private RuleDelegation.Builder ruleDelegation;
        private String ruleAuthorPrincipalId;

        private Builder() {
        }

        public static Builder create(RuleContract rule) {
            if (rule == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = new Builder();
            builder.setRule(Rule.Builder.create(rule));
            return builder;
        }

        public static Builder create(RuleValidationContextContract contract) {
            return Builder.create(contract.getRule(), contract.getRuleDelegation(), contract.getRuleAuthorPrincipalId());
        }

        public static Builder create(RuleContract rule, RuleDelegationContract ruleDelegation, String ruleAuthorPrincipalId) {
            Builder builder = Builder.create(rule);
            if (ruleDelegation != null) {
                builder.setRuleDelegation(RuleDelegation.Builder.create(ruleDelegation));
            }
            builder.setRuleAuthorPrincipalId(ruleAuthorPrincipalId);
            return builder;
        }

        public RuleValidationContext build() {
            return new RuleValidationContext(this);
        }

        @Override
        public Rule.Builder getRule() {
            return this.rule;
        }

        @Override
        public RuleDelegation.Builder getRuleDelegation() {
            return this.ruleDelegation;
        }

        @Override
        public String getRuleAuthorPrincipalId() {
            return this.ruleAuthorPrincipalId;
        }

        public void setRule(Rule.Builder rule) {
            this.rule = rule;
        }

        public void setRuleDelegation(RuleDelegation.Builder ruleDelegation) {
            this.ruleDelegation = ruleDelegation;
        }

        public void setRuleAuthorPrincipalId(String ruleAuthorPrincipalId) {
            this.ruleAuthorPrincipalId = ruleAuthorPrincipalId;
        }
    }
}

