/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.annotation.Optionality;
import com.codiform.moo.property.AbstractProperty;
import com.codiform.moo.property.MapProperty;
import com.codiform.moo.translator.DefaultMapTargetFactory;
import com.codiform.moo.translator.TranslationTargetFactory;

public abstract class AbstractMapProperty
extends AbstractProperty
implements MapProperty {
    private final Optionality optionality;
    private final boolean removeOrphans;
    private final boolean update;
    private Class<? extends TranslationTargetFactory> factory;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private String keySource;
    private String valueSource;
    private boolean nullKeys;

    public AbstractMapProperty(com.codiform.moo.annotation.MapProperty annotation) {
        if (annotation != null) {
            this.optionality = annotation.optionality();
            this.removeOrphans = annotation.removeOrphans();
            this.update = annotation.update();
            this.factory = annotation.factory();
            this.keyClass = annotation.keyClass() == Object.class ? null : annotation.keyClass();
            this.valueClass = annotation.valueClass() == Object.class ? null : annotation.valueClass();
            this.nullKeys = annotation.nullKeys();
            this.keySource = annotation.keySource().trim();
            if (this.keySource.isEmpty()) {
                this.keySource = null;
            }
            this.valueSource = annotation.valueSource().trim();
            if (this.valueSource.isEmpty()) {
                this.valueSource = null;
            }
        } else {
            this.optionality = null;
            this.removeOrphans = true;
            this.update = false;
            this.factory = DefaultMapTargetFactory.class;
            this.keyClass = null;
            this.valueClass = null;
            this.keySource = null;
            this.nullKeys = true;
        }
    }

    @Override
    public boolean shouldUpdate() {
        return this.update;
    }

    @Override
    public boolean isSourceRequired(boolean defaultSetting) {
        return this.isSourceRequired(defaultSetting, this.optionality);
    }

    @Override
    public boolean shouldRemoveOrphans() {
        return this.removeOrphans;
    }

    @Override
    public boolean shouldBeTranslated() {
        return false;
    }

    @Override
    public Class<? extends TranslationTargetFactory> getFactory() {
        return this.factory;
    }

    @Override
    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public String getKeySource() {
        return this.keySource;
    }

    @Override
    public String getValueSource() {
        return this.valueSource;
    }

    @Override
    public boolean allowNullKeys() {
        return this.nullKeys;
    }
}

