/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.GetPropertyException;
import com.codiform.moo.SetPropertyException;
import com.codiform.moo.annotation.MapProperty;
import com.codiform.moo.property.AbstractMapProperty;
import java.lang.reflect.Field;

public class MapFieldProperty
extends AbstractMapProperty {
    private Field field;
    private String name;
    private String expression;
    private boolean explicit;
    private boolean ignore;

    public MapFieldProperty(Field field, MapProperty annotation, String name, String expression, boolean explicit, boolean ignore) {
        super(annotation);
        this.field = field;
        this.name = name;
        this.expression = expression;
        this.explicit = explicit;
        this.ignore = ignore;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourcePropertyExpression() {
        return this.expression;
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.checkValue(value);
        try {
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
        catch (IllegalAccessException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
    }

    @Override
    public boolean canSupportNull() {
        return true;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public boolean isIgnored() {
        return this.ignore;
    }

    @Override
    public boolean canGetValue() {
        return true;
    }

    @Override
    public Object getValue(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
        catch (IllegalAccessException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
    }
}

