/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.TranslationException;
import com.codiform.moo.UnsupportedTranslationException;
import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.property.MapProperty;
import com.codiform.moo.property.source.NoOpSourceProperty;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import com.codiform.moo.session.TranslationSource;
import com.codiform.moo.translator.DefaultMapTargetFactory;
import com.codiform.moo.translator.TranslationTargetFactory;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTranslator {
    private Configuration configuration;
    private Logger log;
    private SourcePropertyFactory sourcePropertyFactory;

    public MapTranslator(Configuration configuration, SourcePropertyFactory sourcePropertyFactory) {
        this.configuration = configuration;
        this.sourcePropertyFactory = sourcePropertyFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public Object translate(Object value, MapProperty property, TranslationSource translationSource) {
        if (this.shouldTranslate(property)) {
            return this.translateMap(value, property, translationSource);
        }
        if (this.shouldCopy(property)) {
            return this.copy(value, property, translationSource);
        }
        if (this.isCompatible(value, property)) {
            return value;
        }
        return this.copy(value, property, translationSource);
    }

    private Object translateMap(Object value, MapProperty property, TranslationSource translationSource) {
        if (value instanceof Map) {
            Object target = this.createTargetMap(value, property, translationSource);
            if (target instanceof Map) {
                this.translateMap((Map)value, (Map)target, property, translationSource);
                return target;
            }
            throw new TranslationException("Cannot translate map to target of type: " + target.getClass().getName());
        }
        throw new TranslationException("Cannot translate map from type: " + value.getClass().getName());
    }

    private void translateMap(Map<Object, Object> source, Map<Object, Object> target, MapProperty property, TranslationSource translationSource) {
        SourceProperty keySourceProperty = this.getSourceProperty(property.getKeySource());
        SourceProperty valueSourceProperty = this.getSourceProperty(property.getValueSource());
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object key = keySourceProperty.getValue(entry.getKey());
            if (key == null && !property.allowNullKeys() || (key = this.getKeyOrTranslation(key, property, translationSource)) == null && !property.allowNullKeys()) continue;
            Object value = valueSourceProperty.getValue(entry.getValue());
            value = this.getValueOrTranslation(value, property, translationSource);
            target.put(key, value);
        }
    }

    private Object getValueOrTranslation(Object value, MapProperty property, TranslationSource translationSource) {
        if (property.getValueClass() == null) {
            return value;
        }
        return translationSource.getTranslation(value, property.getValueClass());
    }

    private Object getKeyOrTranslation(Object key, MapProperty property, TranslationSource translationSource) {
        if (property.getKeyClass() == null) {
            return key;
        }
        return translationSource.getTranslation(key, property.getKeyClass());
    }

    private Object copy(Object value, MapProperty property, TranslationSource translationSource) {
        if (value instanceof Map) {
            Object target = this.createTargetMap(value, property, translationSource);
            if (target instanceof Map) {
                Map targetMap = (Map)target;
                targetMap.putAll((Map)value);
                return targetMap;
            }
            throw new TranslationException("Cannot translate Map to target of type: " + target.getClass().getName());
        }
        throw new TranslationException("Cannot translate collection from type: " + value.getClass().getName());
    }

    private Object createTargetMap(Object value, MapProperty property, TranslationSource cache) {
        Class<? extends TranslationTargetFactory> factoryType = property.getFactory();
        TranslationTargetFactory factory = cache.getTranslationTargetFactory(factoryType);
        Object targetMap = factory.getTranslationTargetInstance(value, property.getType());
        this.log.trace("Target factory type {} created target map of type {} for source {}", new Object[]{factoryType, targetMap.getClass(), value});
        return targetMap;
    }

    private boolean isCompatible(Object value, MapProperty property) {
        return property.getType().isInstance(value);
    }

    private boolean shouldCopy(MapProperty property) {
        return !this.hasDefaultFactory(property) || this.configuration.isPerformingDefensiveCopies();
    }

    private boolean hasDefaultFactory(MapProperty property) {
        return property.getFactory() == DefaultMapTargetFactory.class;
    }

    private boolean shouldTranslate(MapProperty property) {
        return property.getKeyClass() != null || property.getValueClass() != null || property.getKeySource() != null || property.getValueSource() != null;
    }

    public void updateMap(Object source, Map<Object, Object> destinationMap, TranslationSource translationSource, MapProperty property) {
        if (!(source instanceof Map)) {
            throw new UnsupportedTranslationException("Cannot update Map from " + source.getClass().getName());
        }
        Map sourceMap = (Map)source;
        this.updateMapByKey(sourceMap, destinationMap, translationSource, property);
    }

    private void updateMapByKey(Map<Object, Object> sourceMap, Map<Object, Object> destinationMap, TranslationSource translationSource, MapProperty property) {
        SourceProperty keySourceProperty = this.getSourceProperty(property.getKeySource());
        SourceProperty valueSourceProperty = this.getSourceProperty(property.getValueSource());
        for (Map.Entry<Object, Object> entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            if ((key = keySourceProperty.getValue(key)) == null && !property.allowNullKeys() || (key = this.getKeyOrTranslation(key, property, translationSource)) == null && !property.allowNullKeys()) continue;
            Object sourceValue = entry.getValue();
            sourceValue = valueSourceProperty.getValue(sourceValue);
            sourceValue = this.getValueOrTranslation(sourceValue, property, translationSource);
            Object destinationValue = destinationMap.get(key);
            if (destinationValue != null && sourceValue != null) {
                translationSource.update(sourceValue, destinationValue);
                continue;
            }
            destinationMap.put(key, sourceValue);
        }
        if (property.shouldRemoveOrphans()) {
            this.removeOrphans(sourceMap, destinationMap);
        }
    }

    private void removeOrphans(Map<Object, Object> sourceMap, Map<Object, Object> destinationMap) {
        HashSet<Object> toRemove = new HashSet<Object>(destinationMap.keySet());
        toRemove.removeAll(sourceMap.keySet());
        for (Object e : toRemove) {
            destinationMap.remove(e);
        }
    }

    private SourceProperty getSourceProperty(String sourceExpression) {
        if (sourceExpression == null) {
            return new NoOpSourceProperty();
        }
        return this.sourcePropertyFactory.getSourceProperty(sourceExpression);
    }
}

