/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.framework.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

@KcBusinessRule(value="budgetCostShareAuditRule")
public class BudgetCostShareAuditRule
extends CostShareRuleResearchDocumentBase {
    public static final String BUDGET_COST_SHARE_ERROR_KEY = "budgetCostShareAuditErrors";
    private static final String[] PARAMS = new String[]{"Cost Sharing"};

    @KcEventMethod
    public boolean processCostShareAuditRules(BudgetAuditEvent event) {
        Budget budget = event.getBudget();
        if (!budget.isCostSharingApplicable().booleanValue()) {
            return true;
        }
        List<BudgetCostShare> costShares = budget.getBudgetCostShares();
        boolean retval = true;
        if (budget.getUnallocatedCostSharing().isNonZero() && budget.isCostSharingEnforced().booleanValue()) {
            retval = false;
            if (costShares.size() == 0) {
                this.getAuditErrors(BUDGET_COST_SHARE_ERROR_KEY, "Budget Cost Sharing").add(new AuditError("document.budget.budgetCostShare", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetCostSharing", PARAMS));
            }
            this.getAuditErrors(BUDGET_COST_SHARE_ERROR_KEY, "Budget Cost Sharing").add(new AuditError("document.budget.budgetCostShare", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetCostSharing", PARAMS));
        }
        int i = 0;
        for (BudgetCostShare costShare : costShares) {
            String source = costShare.getSourceAccount();
            Integer fiscalYear = costShare.getProjectPeriod();
            if (null == source || source.length() == 0) {
                retval = false;
                this.getAuditErrors(BUDGET_COST_SHARE_ERROR_KEY, "Budget Cost Sharing").add(new AuditError("document.budget.budgetCostShares[" + i + "].sourceAccount", "error.budget.distribution.sourceMissing", "budgetDistributionAndIncome.budgetCostSharing", this.getParamsForMissingSourceEntry(i)));
            }
            int numberOfProjectPeriods = -1;
            if (budget.getBudgetPeriods() != null) {
                numberOfProjectPeriods = budget.getBudgetPeriods().size();
            }
            this.validateProjectPeriod(fiscalYear, "document.budget.budgetCostShares[" + i + "].projectPeriod", numberOfProjectPeriods);
            if (this.getCostShareService().validateProjectPeriodAsProjectPeriod()) {
                ArrayList<AuditError> errors = new ArrayList<AuditError>();
                this.validatePeriodNumber(costShare, "document.budget.budgetCostShares[" + i + "].projectPeriod", numberOfProjectPeriods, errors);
                if (!errors.isEmpty()) {
                    this.getAuditErrors(BUDGET_COST_SHARE_ERROR_KEY, "Budget Cost Sharing").addAll(errors);
                }
            }
            ++i;
        }
        return retval;
    }

    @KcEventMethod
    public boolean processCostShareAuditRules(BudgetAuditRuleEvent event) {
        Budget budget = event.getBudget();
        boolean retval = true;
        if (budget.isCostSharingApplicable().booleanValue() && budget.isCostSharingEnforced().booleanValue()) {
            List<BudgetCostShare> costShares = budget.getBudgetCostShares();
            retval &= this.verifyCostSharingAllocation(budget, costShares);
            retval &= this.verifySourceAccount(budget, costShares);
        }
        return retval;
    }

    protected boolean verifySourceAccount(Budget budget, List<BudgetCostShare> costShares) {
        BudgetConstants.BudgetAuditRules budgetCostSharingRule = BudgetConstants.BudgetAuditRules.COST_SHARING;
        boolean isValid = true;
        for (int i = 0; i < costShares.size(); ++i) {
            BudgetCostShare costShare = costShares.get(i);
            String source = costShare.getSourceAccount();
            Integer fiscalYear = costShare.getProjectPeriod();
            if (StringUtils.isEmpty((CharSequence)source) || source.length() == 0) {
                this.getAuditErrors(budgetCostSharingRule.getErrorKey(), budgetCostSharingRule.getLabel()).add(new AuditError(budgetCostSharingRule.getPageId(), "error.budget.distribution.sourceMissing", budgetCostSharingRule.getPageId(), this.getParamsForMissingSourceEntry(i)));
                isValid = false;
            }
            int numberOfProjectPeriods = budget.getBudgetPeriods() != null ? budget.getBudgetPeriods().size() : -1;
            this.validateProjectPeriod(fiscalYear, budgetCostSharingRule.getPageId(), numberOfProjectPeriods);
            if (!this.getCostShareService().validateProjectPeriodAsProjectPeriod()) continue;
            isValid &= this.verifyPeriodNumber(costShare, budgetCostSharingRule.getPageId(), numberOfProjectPeriods);
        }
        return isValid;
    }

    public boolean verifyPeriodNumber(BudgetCostShare costShare, String projectPeriodField, int numberOfProjectPeriods) {
        int projectPeriodInt = Integer.parseInt(costShare.getProjectPeriod().toString().trim());
        BudgetConstants.BudgetAuditRules budgetCostSharingRule = BudgetConstants.BudgetAuditRules.COST_SHARING;
        if (projectPeriodInt <= 0 || projectPeriodInt > numberOfProjectPeriods) {
            AuditError auditError = new AuditError(projectPeriodField, "error.awardCostShare.projectPeriod.range", "budgetDistributionAndIncome.budgetCostSharing", new String[]{Integer.toString(projectPeriodInt), Integer.toString(numberOfProjectPeriods), Integer.toString(numberOfProjectPeriods)});
            this.getAuditErrors(budgetCostSharingRule.getErrorKey(), budgetCostSharingRule.getLabel()).add(auditError);
            return false;
        }
        return true;
    }

    protected boolean verifyCostSharingAllocation(Budget budget, List<BudgetCostShare> costShares) {
        BudgetConstants.BudgetAuditRules budgetCostSharingRule = BudgetConstants.BudgetAuditRules.COST_SHARING;
        if (budget.getUnallocatedCostSharing().isNonZero()) {
            if (costShares.isEmpty()) {
                this.getAuditErrors(budgetCostSharingRule.getErrorKey(), budgetCostSharingRule.getLabel()).add(new AuditError("budget.budgetCostShare", "error.budget.distribution.unallocatedMustBeZero", budgetCostSharingRule.getPageId(), PARAMS));
            } else {
                for (int i = 0; i < costShares.size(); ++i) {
                    this.getAuditErrors(budgetCostSharingRule.getErrorKey(), budgetCostSharingRule.getLabel()).add(new AuditError("budget.budgetCostShares[" + i + "].shareAmount", "error.budget.distribution.unallocatedMustBeZero", budgetCostSharingRule.getPageId(), PARAMS));
                }
            }
            return false;
        }
        return true;
    }

    private String[] getParamsForMissingSourceEntry(int i) {
        return new String[]{String.format("%s entry #%d", PARAMS[0], i + 1)};
    }

    private List<AuditError> getAuditErrors(String costShareKey, String costShareLabel) {
        return this.getAuditProblems("Error", costShareKey, costShareLabel);
    }

    private List<AuditError> getAuditWarnings(String costShareKey, String costShareLabel) {
        return this.getAuditProblems("Warnings", costShareKey, costShareLabel);
    }

    private List<AuditError> getAuditProblems(String problemType, String costShareKey, String costShareLabel) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(costShareKey)) {
            GlobalVariables.getAuditErrorMap().put(costShareKey, new AuditCluster(costShareLabel, auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(costShareKey)).getAuditErrorList();
        }
        return auditErrors;
    }
}

