/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.notification;

import java.util.List;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.notification.CommonCommitteeNotificationRoleQualifierService;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.exception.UnknownRoleException;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.springframework.util.CollectionUtils;

public class CommitteeNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 6642334312368480034L;
    private CommitteeBase committee;
    private CommitteeScheduleBase committeeSchedule;
    private String actionTypeCode;
    private String contextName;

    public CommitteeNotificationContext(CommitteeScheduleBase committeeSchedule, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.committee = committeeSchedule.getParentCommittee();
        this.committeeSchedule = committeeSchedule;
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService(KcServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
        CommonCommitteeNotificationRoleQualifierService committeeNotificationRoleQualifierService = this.getCommitteeNotificationRoleQualifierService();
        this.setNotificationRoleQualifierService(committeeNotificationRoleQualifierService);
        committeeNotificationRoleQualifierService.setCommitteeSchedule(this.committeeSchedule);
        committeeNotificationRoleQualifierService.setCommittee(this.committee);
    }

    @Override
    public String getModuleCode() {
        return "11";
    }

    @Override
    public String getDocumentNumber() {
        return this.committee.getCommitteeDocument().getDocumentNumber();
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (CollectionUtils.isEmpty(notificationRecipient.getRoleQualifiers())) {
            super.populateRoleQualifiers(notificationRecipient);
        }
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return null;
    }

    public CommonCommitteeNotificationRoleQualifierService getCommitteeNotificationRoleQualifierService() {
        return KcServiceLocator.getService(CommonCommitteeNotificationRoleQualifierService.class);
    }
}

