/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.subaward.api;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.subaward.dto.SubawardDto;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
@Controller(value="subawardDocumentController")
public class SubawardDocumentController
extends RestController
implements InitializingBean {
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="subAwardService")
    private SubAwardService subawardService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    private List<String> subawardDtoProperties;

    public void afterPropertiesSet() throws IntrospectionException {
        this.subawardDtoProperties = this.getSubawardDtoProperties();
    }

    protected List<String> getSubawardDtoProperties() throws IntrospectionException {
        return Stream.of(Introspector.getBeanInfo(SubawardDto.class).getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/subaward-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<SubawardDto> getSubaward(@RequestParam(value="subawardCode", required=false) String subawardCode, @RequestParam(value="subawardId", required=false) String subawardId, @RequestParam(value="activeVersionOnly", required=false) boolean activeVersionOnly) {
        HashMap<String, String> criteria;
        this.assertUserHasReadAccess();
        ArrayList<SubawardDto> subawards = new ArrayList<SubawardDto>();
        if (StringUtils.isBlank((CharSequence)subawardCode) && StringUtils.isBlank((CharSequence)subawardId)) {
            throw new NotImplementedException("GET all Subawards has not been implemented.");
        }
        if (StringUtils.isNotBlank((CharSequence)subawardCode) && StringUtils.isNotBlank((CharSequence)subawardId)) {
            throw new UnprocessableEntityException("Specify either subawardCode or subawardId.");
        }
        if (StringUtils.isNotBlank((CharSequence)subawardId)) {
            criteria = new HashMap<String, String>();
            criteria.put("subAwardId", subawardId);
            subawards.add(this.commonApiService.convertObject(this.businessObjectService.findByPrimaryKey(SubAward.class, criteria), SubawardDto.class));
        }
        if (StringUtils.isNotBlank((CharSequence)subawardCode)) {
            criteria = new HashMap();
            criteria.put("subAwardCode", subawardCode);
            if (activeVersionOnly) {
                criteria.put("subAwardSequenceStatus", "ACTIVE");
            }
            subawards.addAll(this.businessObjectService.findMatching(SubAward.class, criteria).stream().map(subaward -> this.commonApiService.convertObject(subaward, SubawardDto.class)).collect(Collectors.toList()));
        }
        return subawards;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/v1/subaward-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String createSubawardDocument(@RequestBody SubawardDto subawardDto, @RequestParam(value="route", required=false) boolean route) throws WorkflowException {
        this.assertUserHasWriteAccess();
        RestAuditLogger auditLogger = this.getRestAuditLoggerFactory().getNewAuditLogger(SubawardDto.class, this.subawardDtoProperties);
        this.getCommonApiService().clearErrors();
        SubAward subaward = this.getCommonApiService().convertObject(subawardDto, SubAward.class);
        subaward.setSubAwardCode(this.getSubawardService().getNextSubAwardCode());
        subaward.setSequenceNumber(1);
        subaward.setSubAwardSequenceStatus(VersionStatus.PENDING.name());
        subaward.setNewVersion(false);
        subaward.setSubAwardContactsList(subawardDto.getSubawardContactList().stream().map(contactDto -> {
            SubAwardContact subawardContact = this.commonApiService.convertObject(contactDto, SubAwardContact.class);
            subawardContact.setSubAwardCode(subaward.getSubAwardCode());
            subawardContact.setSequenceNumber(subaward.getSequenceNumber());
            this.getCommonApiService().validatePerson(null, subawardContact.getRolodexId());
            return subawardContact;
        }).collect(Collectors.toList()));
        if (subawardDto.getSubawardCustomDataList() != null) {
            subaward.setSubAwardCustomDataList(subawardDto.getSubawardCustomDataList().stream().map(customDataDto -> {
                SubAwardCustomData subAwardCustomData = this.commonApiService.convertObject(customDataDto, SubAwardCustomData.class);
                subAwardCustomData.setSubAwardCode(subaward.getSubAwardCode());
                subAwardCustomData.setSequenceNumber(subaward.getSequenceNumber());
                return subAwardCustomData;
            }).collect(Collectors.toList()));
        }
        if (subawardDto.getSubAwardAmountInfoList() != null) {
            subaward.setSubAwardAmountInfoList(subawardDto.getSubAwardAmountInfoList().stream().map(subAwardAmountInfoDto -> {
                SubAwardAmountInfo subAwardAmountInfo = this.commonApiService.convertObject(subAwardAmountInfoDto, SubAwardAmountInfo.class);
                subAwardAmountInfo.setSubAwardCode(subaward.getSubAwardCode());
                subAwardAmountInfo.setSequenceNumber(subaward.getSequenceNumber());
                return subAwardAmountInfo;
            }).collect(Collectors.toList()));
        }
        SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getNewDocument(SubAwardDocument.class);
        subawardDocument.getDocumentHeader().setDocumentDescription(subawardDto.getDocumentDescription());
        subawardDocument.setSubAward(subaward);
        subaward.refreshNonUpdateableReferences();
        this.getCommonApiService().validatePerson(subaward.getRequisitionerId(), null);
        if (!new SubAwardDocumentRule().processAddSubAwardBusinessRules(subaward)) {
            throw new UnprocessableEntityException(GlobalVariables.getMessageMap().getErrorMessages().toString());
        }
        this.commonApiService.saveDocument((Document)subawardDocument);
        if (route) {
            this.getCommonApiService().routeDocument((Document)subawardDocument);
        }
        auditLogger.addNewItem(subawardDto);
        auditLogger.saveAuditLog();
        return subawardDocument.getDocumentNumber();
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/v1/subaward-documents/{documentNumber}"}, params={"route"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void routeSubawardDocument(@PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.getCommonApiService().clearErrors();
        SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber.toString());
        this.getCommonApiService().routeDocument((Document)subawardDocument);
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", SubAward.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", SubAward.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public SubAwardService getSubawardService() {
        return this.subawardService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

