/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.controller.rest.audit;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.kuali.coeus.sys.framework.controller.rest.RestBeanWrapperFactory;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLog;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerDao;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.springframework.beans.BeanWrapper;

public class RestAuditLoggerImpl
implements RestAuditLogger {
    private final Class<?> dataObjectClass;
    private final List<String> propertiesToTrack;
    private RestAuditLog restAuditLog;
    private final RestAuditLoggerDao restAuditLoggerDao;
    private final RestBeanWrapperFactory restBeanWrapperFactory;

    public RestAuditLoggerImpl(String username, Class<?> dataObjectClass, List<String> propertiesToTrack, RestAuditLoggerDao restAuditLoggerDao, RestBeanWrapperFactory restBeanWrapperFactory) {
        this.dataObjectClass = dataObjectClass;
        this.propertiesToTrack = propertiesToTrack;
        this.restAuditLoggerDao = restAuditLoggerDao;
        this.restAuditLog = new RestAuditLog(username, dataObjectClass.getCanonicalName());
        this.restBeanWrapperFactory = restBeanWrapperFactory;
    }

    @Override
    public void addModifiedItem(Object currentItem, Object updatedItem) {
        this.restAuditLog.getModified().add(this.getUpdatedAuditLogItem(currentItem, updatedItem));
    }

    Map<String, Object> getUpdatedAuditLogItem(Object current, Object updated) {
        BeanWrapper currentBean = this.restBeanWrapperFactory.newInstance(current);
        currentBean.setAutoGrowNestedPaths(true);
        BeanWrapper updatedBean = this.restBeanWrapperFactory.newInstance(updated);
        updatedBean.setAutoGrowNestedPaths(true);
        return this.propertiesToTrack.stream().map(name -> {
            Object newValue;
            Object currentValue = currentBean.getPropertyValue(name);
            if (this.areValuesEqual(currentValue, newValue = updatedBean.getPropertyValue(name))) {
                return CollectionUtils.entry(name, currentValue);
            }
            Map diffs = Stream.of(CollectionUtils.entry("old", currentValue), CollectionUtils.entry("new", newValue)).collect(CollectionUtils.nullSafeEntriesToMap());
            return CollectionUtils.entry(name, diffs);
        }).collect(CollectionUtils.nullSafeEntriesToMap());
    }

    protected boolean areValuesEqual(Object currentValue, Object newValue) {
        return Objects.equals(currentValue, newValue);
    }

    @Override
    public void addNewItem(Object newItem) {
        this.restAuditLog.getAdded().add(this.getAuditLogItem(newItem));
    }

    Map<String, Object> getAuditLogItem(Object current) {
        BeanWrapper currentBean = this.restBeanWrapperFactory.newInstance(current);
        currentBean.setAutoGrowNestedPaths(true);
        return this.propertiesToTrack.stream().map(name -> CollectionUtils.entry(name, currentBean.getPropertyValue(name))).collect(CollectionUtils.nullSafeEntriesToMap());
    }

    @Override
    public void addDeletedItem(Object deletedItem) {
        this.restAuditLog.getDeleted().add(this.getAuditLogItem(deletedItem));
    }

    @Override
    public void saveAuditLog() {
        this.restAuditLog.setDate(Instant.now());
        this.restAuditLoggerDao.saveAuditLog(this.dataObjectClass, this.restAuditLog);
        this.restAuditLog = new RestAuditLog(this.restAuditLog.getUsername(), this.dataObjectClass.getCanonicalName());
    }

    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public List<String> getPropertiesToTrack() {
        return this.propertiesToTrack;
    }

    public RestAuditLog getRestAuditLog() {
        return this.restAuditLog;
    }

    public RestAuditLoggerDao getRestAuditLoggerDao() {
        return this.restAuditLoggerDao;
    }

    public RestBeanWrapperFactory getRestBeanWrapperFactory() {
        return this.restBeanWrapperFactory;
    }
}

