/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolVersionService;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionServiceImplBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;

public class IacucProtocolVersionServiceImpl
extends ProtocolVersionServiceImplBase
implements IacucProtocolVersionService {
    private IacucProtocolProcedureService iacucProtocolProcedureService;

    @Override
    protected String getProtocolDocumentTypeHook() {
        return "IacucProtocolDocument";
    }

    @Override
    protected ProtocolBase createProtocolNewVersionHook(ProtocolBase protocol) throws Exception {
        IacucProtocol iacucProtocol = (IacucProtocol)protocol;
        iacucProtocol = this.versioningService.createNewVersion(iacucProtocol);
        this.setNewProtocolId(iacucProtocol);
        this.initPersonId(iacucProtocol);
        this.getIacucProtocolProcedureService().resetAllProtocolStudyProcedures(iacucProtocol);
        return iacucProtocol;
    }

    @Override
    protected ProtocolModuleQuestionnaireBeanBase getNewInstanceProtocolModuleQuestionnaireBeanHook(ProtocolBase protocol) {
        return new IacucProtocolModuleQuestionnaireBean((IacucProtocol)protocol);
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return IacucProtocol.class;
    }

    @Override
    protected ProtocolDocumentBase createNewProtocolDocumentInstanceHook() {
        return new IacucProtocolDocument();
    }

    @Override
    protected String getProtocolSequenceIdHook() {
        return "SEQ_IACUC_PROTOCOL_ID";
    }

    protected String getProtocolPersonSequenceId() {
        return "SEQ_IACUC_PROTOCOL_ID";
    }

    public IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return this.iacucProtocolProcedureService;
    }

    public void setIacucProtocolProcedureService(IacucProtocolProcedureService iacucProtocolProcedureService) {
        this.iacucProtocolProcedureService = iacucProtocolProcedureService;
    }

    private void initPersonId(ProtocolBase protocol) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            Integer nextPersonId = this.getSequenceAccessorService().getNextAvailableSequenceNumber(this.getProtocolPersonSequenceId()).intValue();
            person.setProtocolPersonId(nextPersonId);
        }
    }
}

