/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.lookup.keyvalue.CommitteeIdByUnitValuesFinderService;
import org.kuali.coeus.common.committee.impl.service.CommitteeScheduleServiceBase;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolVersionService;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolEditableBean;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionDoc;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewService;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewal;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendmentBean;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveBean;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtBean;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaBean;
import org.kuali.kra.iacuc.actions.correction.IacucAdminCorrectionBean;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecision;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionService;
import org.kuali.kra.iacuc.actions.delete.IacucProtocolDeleteBean;
import org.kuali.kra.iacuc.actions.followup.IacucFollowupActionService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredBean;
import org.kuali.kra.iacuc.actions.notifycommittee.IacucProtocolNotifyCommitteeBean;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucBean;
import org.kuali.kra.iacuc.actions.print.IacucProtocolQuestionnairePrintingService;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionService;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableBean;
import org.kuali.kra.iacuc.actions.undo.IacucProtocolUndoLastActionBean;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolWithdrawBean;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.committee.lookup.keyvalue.IacucCommitteeIdByUnitValuesFinderService;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeScheduleService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondenceAuthorizationService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondenceType;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.iacuc.questionnaire.IacucSubmissionQuestionnaireHelper;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.ProtocolActionBean;
import org.kuali.kra.protocol.actions.ProtocolEditableBean;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveBean;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.protocol.actions.correction.AdminCorrectionBean;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.decision.CommitteeDecisionService;
import org.kuali.kra.protocol.actions.decision.CommitteePersonBase;
import org.kuali.kra.protocol.actions.delete.ProtocolDeleteBean;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.notifycommittee.ProtocolNotifyCommitteeBean;
import org.kuali.kra.protocol.actions.print.CorrespondencePrintOption;
import org.kuali.kra.protocol.actions.print.ProtocolQuestionnairePrintingService;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.protocol.actions.submit.ValidProtocolActionActionBase;
import org.kuali.kra.protocol.actions.undo.UndoLastActionBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.CorrespondenceTypeModuleIdConstants;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceAuthorizationService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucActionHelper
extends ActionHelperBase {
    private static final Logger LOG = LogManager.getLogger(IacucActionHelper.class);
    private static final long serialVersionUID = 777750088765246427L;
    private boolean canDeleteIacucProtocol;
    private boolean canDeleteIacucProtocolUnavailable;
    private boolean canReviewNotRequired;
    private boolean canReviewNotRequiredUnavailable;
    private boolean canNotifyIacuc = false;
    private boolean canNotifyIacucUnavailable = false;
    private boolean canDesignatedMemberApproval = false;
    private boolean canDesignatedMemberApprovalUnavailable = false;
    private boolean canHold = false;
    private boolean canHoldUnavailable = false;
    private boolean canLiftHold = false;
    private boolean canLiftHoldUnavailable = false;
    private boolean canRequestToLiftHold = false;
    private boolean canRequestToLiftHoldUnavailable = false;
    private boolean canRequestSuspend = false;
    private boolean canRequestSuspendUnavailable = false;
    private boolean canTable = false;
    private boolean canTableUnavailable = false;
    private boolean canIacucAcknowledge = false;
    private boolean canIacucAcknowledgeUnavailable = false;
    private boolean canIacucDeactivate = false;
    private boolean canIacucDeactivateUnavailable = false;
    private boolean canIacucRequestDeactivate = false;
    private boolean canIacucRequestDeactivateUnavailable = false;
    private boolean canAddDeactivateReviewerComments = false;
    private boolean canRemoveFromAgenda = false;
    private boolean canAssignCmt = false;
    private boolean canAssignCmtUnavailable = false;
    private boolean submissionQuestionnaireExist;
    private boolean toAnswerSubmissionQuestionnaire;
    protected IacucProtocolTableBean iacucProtocolTableBean;
    protected IacucProtocolAssignCmtBean protocolAssignCmtBean;
    protected IacucProtocolModifySubmissionBean iacucProtocolModifySubmissionBean;
    protected IacucProtocolNotifyIacucBean iacucProtocolNotifyIacucBean;
    protected IacucProtocolGenericActionBean iacucProtocolDeactivateBean;
    protected IacucProtocolGenericActionBean iacucAcknowledgeBean;
    protected IacucProtocolGenericActionBean iacucProtocolHoldBean;
    protected IacucProtocolGenericActionBean iacucProtocolLiftHoldBean;
    protected IacucProtocolGenericActionBean iacucProtocolRemoveFromAgendaBean;
    protected ProtocolReviewNotRequiredBean iacucProtocolReviewNotRequiredBean;
    protected IacucProtocolRequestBean iacucProtocolDeactivateRequestBean;
    protected IacucProtocolRequestBean iacucProtocolLiftHoldRequestBean;
    protected IacucProtocolRequestBean iacucProtocolSuspendRequestBean;
    protected IacucProtocolRequestBean iacucProtocolWithdrawSubmissionBean;
    protected boolean canCreateContinuation = false;
    protected boolean canCreateContinuationUnavailable = false;
    protected boolean hasContinuations;
    protected String continuationSummary;
    protected ProtocolAmendmentBean protocolContinuationAmendmentBean;
    private List<KeyValue> assignCmtActionCommitteeIdByUnitKeyValues;
    private List<KeyValue> modifySubmissionActionCommitteeIdByUnitKeyValues;

    public IacucActionHelper(ProtocolFormBase form) throws Exception {
        super(form);
    }

    @Override
    public void initializeProtocolActions() throws Exception {
        super.initializeProtocolActions();
        this.protocolAssignCmtBean = new IacucProtocolAssignCmtBean(this);
        this.iacucProtocolTableBean = new IacucProtocolTableBean(this);
        this.iacucProtocolModifySubmissionBean = new IacucProtocolModifySubmissionBean(this);
        this.iacucProtocolNotifyIacucBean = new IacucProtocolNotifyIacucBean(this, "iacucProtocolNotifyIacucBean");
        this.iacucProtocolDeactivateBean = this.buildProtocolGenericActionBean("303", "actionHelper.iacucProtocolDeactivateBean");
        this.iacucAcknowledgeBean = new IacucProtocolGenericActionBean(this, "actionHelper.iacucAcknowledgeBean");
        this.iacucProtocolHoldBean = new IacucProtocolGenericActionBean(this, "actionHelper.iacucProtocolHoldBean");
        this.iacucProtocolLiftHoldBean = new IacucProtocolGenericActionBean(this, "actionHelper.iacucProtocolLiftHoldBean");
        this.iacucProtocolDeactivateRequestBean = new IacucProtocolRequestBean(this, "107", "102", "iacucProtocolDeactivateRequestBean");
        this.iacucProtocolLiftHoldRequestBean = new IacucProtocolRequestBean(this, "108", "103", "iacucProtocolLiftHoldRequestBean");
        this.iacucProtocolSuspendRequestBean = new IacucProtocolRequestBean(this, "311", "111", "iacucProtocolSuspendRequestBean");
        this.iacucProtocolWithdrawSubmissionBean = new IacucProtocolRequestBean(this, "131", "131", "iacucWithdrawProtocolSubmissionRequestBean");
        this.iacucProtocolRemoveFromAgendaBean = new IacucProtocolGenericActionBean(this, "actionHelper.iacucProtocolRemoveFromAgendaBean");
        this.iacucProtocolReviewNotRequiredBean = new IacucProtocolReviewNotRequiredBean(this);
        this.initIacucSpecificActionBeanTaskMap();
    }

    private void initIacucSpecificActionBeanTaskMap() {
        this.actionBeanTaskMap.put("modifyIacucProtocolSubmission", this.iacucProtocolModifySubmissionBean);
        this.actionBeanTaskMap.put("iacucProtocolTable", this.iacucProtocolTableBean);
        this.actionBeanTaskMap.put("iacucProtocolAssignToCmt", this.protocolAssignCmtBean);
        this.actionBeanTaskMap.put("iacucProtocolTable", this.iacucProtocolTableBean);
        this.actionBeanTaskMap.put("iacucProtocolNotifyIacuc", this.iacucProtocolNotifyIacucBean);
        this.actionBeanTaskMap.put("iacucAcknowledgement", this.iacucAcknowledgeBean);
        this.actionBeanTaskMap.put("iacucProtocolDeactivate", this.iacucProtocolDeactivateBean);
        this.actionBeanTaskMap.put("iacucProtocolRequestDeactivate", this.iacucProtocolDeactivateRequestBean);
        this.actionBeanTaskMap.put("iacucProtocolRequestLiftHold", this.iacucProtocolLiftHoldRequestBean);
        this.actionBeanTaskMap.put("iacucProtocolRequestSuspension", this.iacucProtocolSuspendRequestBean);
        this.actionBeanTaskMap.put("iacucWithdrawSubmission", this.iacucProtocolWithdrawSubmissionBean);
        this.actionBeanTaskMap.put("iacucProtocolHold", this.iacucProtocolHoldBean);
        this.actionBeanTaskMap.put("iacucProtocolLiftHold", this.iacucProtocolLiftHoldBean);
        this.actionBeanTaskMap.put("protocolRemoveFromAgenda", this.iacucProtocolRemoveFromAgendaBean);
        this.actionBeanTaskMap.put("createContinuation", this.protocolContinuationAmendmentBean);
    }

    public IacucProtocolAssignCmtBean getProtocolAssignCmtBean() {
        return this.protocolAssignCmtBean;
    }

    public void setProtocolAssignCmtBean(IacucProtocolAssignCmtBean protocolAssignCmtBean) {
        this.protocolAssignCmtBean = protocolAssignCmtBean;
    }

    public IacucProtocolModifySubmissionBean getIacucProtocolModifySubmissionBean() {
        return this.iacucProtocolModifySubmissionBean;
    }

    public void setIacucProtocolModifySubmissionBean(IacucProtocolModifySubmissionBean iacucProtocolModifySubmissionBean) {
        this.iacucProtocolModifySubmissionBean = iacucProtocolModifySubmissionBean;
    }

    public IacucProtocolTableBean getIacucProtocolTableBean() {
        return this.iacucProtocolTableBean;
    }

    public void setIacucProtocolTableBean(IacucProtocolTableBean iacucProtocolTableBean) {
        this.iacucProtocolTableBean = iacucProtocolTableBean;
    }

    @Override
    protected java.sql.Date buildApprovalDate(ProtocolBase protocol) {
        java.sql.Date approvalDate = protocol.getApprovalDate();
        if (approvalDate == null || protocol.isNew() || protocol.isRenewal() || ((IacucProtocol)protocol).isContinuation()) {
            CommitteeScheduleBase committeeSchedule = protocol.getProtocolSubmission().getCommitteeSchedule();
            approvalDate = committeeSchedule != null ? committeeSchedule.getScheduledDate() : new java.sql.Date(System.currentTimeMillis());
        }
        return approvalDate;
    }

    protected java.sql.Date buildExpirationDate(ProtocolBase protocol, java.sql.Date approvalDate) {
        java.sql.Date expirationDate = protocol.getExpirationDate();
        if (expirationDate == null || protocol.isNew() || protocol.isRenewal() || ((IacucProtocol)protocol).isContinuation()) {
            Date newExpirationDate = DateUtils.addYears((Date)approvalDate, (int)this.getDefaultExpirationDateDifference());
            newExpirationDate = DateUtils.addDays((Date)newExpirationDate, (int)-1);
            expirationDate = org.kuali.coeus.sys.framework.util.DateUtils.convertToSqlDate(newExpirationDate);
        }
        return expirationDate;
    }

    @Override
    public void prepareView() throws Exception {
        super.prepareView();
        this.prepareModifySubmissionActionView();
        this.prepareAssignCommitteeActionView();
        this.canNotifyIacuc = this.hasPermission("iacucProtocolNotifyIacuc");
        this.canNotifyIacucUnavailable = this.hasPermission("iacucProtocolNotifyIacucUnavailable");
        this.canHold = this.hasPermission("iacucProtocolHold");
        this.canHoldUnavailable = this.hasPermission("iacucProtocolHoldUnavailable");
        this.canLiftHold = this.hasPermission("iacucProtocolLiftHold");
        this.canLiftHoldUnavailable = this.hasPermission("iacucProtocolLiftHoldUnavailable");
        this.canRequestToLiftHold = this.hasPermission("iacucProtocolRequestLiftHold");
        this.canRequestToLiftHoldUnavailable = this.hasPermission("iacucProtocolRequestLiftHoldUnavailable");
        this.canRequestSuspend = this.hasPermission("iacucProtocolRequestSuspension");
        this.canRequestSuspendUnavailable = this.hasPermission("iacucProtocolRequestSuspensionUnavailable");
        this.canIacucAcknowledge = this.hasPermission("iacucAcknowledgement");
        this.canIacucAcknowledgeUnavailable = this.hasPermission("iacucAcknowledgementUnavailable");
        this.canIacucDeactivate = this.hasPermission("iacucProtocolDeactivate");
        this.canIacucDeactivateUnavailable = this.hasPermission("iacucProtocolDeactivateUnavailable");
        this.canIacucRequestDeactivate = this.hasPermission("iacucProtocolRequestDeactivate");
        this.canIacucRequestDeactivateUnavailable = this.hasPermission("iacucProtocolRequestDeactivateUnavailable");
        this.canWithdrawSubmission = this.hasPermission("iacucWithdrawSubmission");
        this.canWithdrawSubmissionUnavailable = this.hasPermission("iacucWithdrawSubmissionUnavailable");
        this.canDesignatedMemberApproval = this.hasPermission("iacucProtocolDesignatedApproval");
        this.canDesignatedMemberApprovalUnavailable = this.hasPermission("iacucProtocolDesignatedApprovalUnavailable");
        this.canLiftHold = this.hasPermission("iacucProtocolLiftHold");
        this.canLiftHoldUnavailable = this.hasPermission("iacucProtocolLiftHoldUnavailable");
        this.canRequestToLiftHold = this.hasPermission("iacucProtocolRequestLiftHold");
        this.canRequestToLiftHoldUnavailable = this.hasPermission("iacucProtocolRequestLiftHoldUnavailable");
        this.canReturnToPI = this.hasPermission("protocolReturnToPI");
        this.canReturnToPIUnavailable = this.hasPermission("protocolReturnToPIUnavailable");
        this.canReviewNotRequired = this.hasPermission("reviewNotRequiredIacucProtocol");
        this.canReviewNotRequiredUnavailable = this.hasPermission("reviewNotRequiredIacucProtocolUnavailable");
        this.canTable = this.hasPermission("iacucProtocolTable");
        this.canTableUnavailable = this.hasPermission("iacucProtocolTableUnavailable");
        this.canAddDeactivateReviewerComments = this.hasDeactivateRequestLastAction();
        this.canRemoveFromAgenda = this.hasPermission("protocolRemoveFromAgenda");
        this.canCreateContinuation = this.hasCreateContinuationPermission();
        this.canCreateContinuationUnavailable = this.hasCreateContinuationUnavailablePermission();
        this.hidePrivateFinalFlagsForPublicCommentsAttachments = this.checkToHidePrivateFinalFlagsForPublicCommentsAttachments();
        this.initSummaryDetails();
        this.setAmendmentDetails();
        this.initFilterDatesView();
        this.canAssignReviewersCmtSel = this.canSubmitProtocol ? this.hasAssignReviewersCmtSel() : false;
    }

    @Override
    protected void initializeAlternateNotifyActionFlag() {
        this.useAlternateNotifyAction = this.getParameterService().getParameterValueAsBoolean(this.getProtocolDocumentBOClassHook(), "ALTERNATE_NOTIFY_IACUC_ACTION_PARAM", Boolean.valueOf(false));
    }

    @Override
    public void prepareCommentsView() {
        super.prepareCommentsView();
        this.iacucProtocolDeactivateBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.iacucAcknowledgeBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.iacucProtocolRemoveFromAgendaBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.iacucProtocolHoldBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.iacucProtocolLiftHoldBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
    }

    public static boolean hasAssignCmtSchedPermission(String userId, String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolNumber", protocolNumber);
        BusinessObjectService bos = KcServiceLocator.getService(BusinessObjectService.class);
        IacucProtocol protocol = (IacucProtocol)((List)bos.findMatching(IacucProtocol.class, fieldValues)).get(0);
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocol", protocol);
        TaskAuthorizationService tas = KcServiceLocator.getService(TaskAuthorizationService.class);
        return tas.isAuthorized(userId, task);
    }

    @Override
    protected boolean hasFollowupAction(String actionCode) {
        return false;
    }

    public IacucProtocolSubmitAction getIacucProtocolSubmitAction() {
        return (IacucProtocolSubmitAction)this.protocolSubmitAction;
    }

    @Override
    public ProtocolFormBase getProtocolForm() {
        return this.form;
    }

    @Override
    public IacucProtocol getProtocol() {
        return (IacucProtocol)this.form.getProtocolDocument().getProtocol();
    }

    public IacucProtocolGenericActionBean getIacucProtocolDeactivateBean() {
        return this.iacucProtocolDeactivateBean;
    }

    public void setIacucProtocolDeactivateBean(IacucProtocolGenericActionBean iacucProtocolDeactivateBean) {
        this.iacucProtocolDeactivateBean = iacucProtocolDeactivateBean;
    }

    @Override
    protected ModuleQuestionnaireBean getQuestionnaireBean(String moduleCode, String moduleKey, String subModuleCode, String subModuleKey, boolean finalDoc) {
        return new IacucProtocolModuleQuestionnaireBean(moduleCode, moduleKey, subModuleCode, subModuleKey, finalDoc);
    }

    @Override
    public ProtocolActionBean getActionBean(String taskName) {
        return (ProtocolActionBean)this.actionBeanTaskMap.get(taskName);
    }

    @Override
    public boolean isCanAbandon() {
        return this.canAbandon;
    }

    @Override
    public ProtocolCorrespondence getProtocolCorrespondence() {
        return this.protocolCorrespondence;
    }

    @Override
    public void setProtocolCorrespondence(ProtocolCorrespondence protocolCorrespondence) {
        this.protocolCorrespondence = protocolCorrespondence;
    }

    @Override
    public boolean getIsApproveOpenForFollowup() {
        return this.hasFollowupAction("204");
    }

    @Override
    public boolean getIsDisapproveOpenForFollowup() {
        return this.hasFollowupAction("301");
    }

    @Override
    public boolean getIsReturnForSMROpenForFollowup() {
        return this.hasFollowupAction("209");
    }

    @Override
    public boolean getIsReturnForSRROpenForFollowup() {
        return this.hasFollowupAction("211");
    }

    @Override
    public boolean isOpenForFollowup() {
        return this.getIsApproveOpenForFollowup() || this.getIsDisapproveOpenForFollowup() || this.getIsReturnForSMROpenForFollowup() || this.getIsReturnForSRROpenForFollowup();
    }

    public boolean isCanDesignatedMemberApproval() {
        return this.canDesignatedMemberApproval;
    }

    public boolean isCanDesignatedMemberApprovalUnavailable() {
        return this.canDesignatedMemberApprovalUnavailable;
    }

    public boolean isCanHold() {
        return this.canHold;
    }

    public boolean isCanHoldUnavailable() {
        return this.canHoldUnavailable;
    }

    public boolean isCanLiftHold() {
        return this.canLiftHold;
    }

    public boolean isCanLiftHoldUnavailable() {
        return this.canLiftHoldUnavailable;
    }

    public boolean isCanRequestToLiftHold() {
        return this.canRequestToLiftHold;
    }

    public boolean isCanRequestToLiftHoldUnavailable() {
        return this.canRequestToLiftHoldUnavailable;
    }

    public boolean isCanRequestSuspend() {
        return this.canRequestSuspend;
    }

    public boolean isCanRequestSuspendUnavailable() {
        return this.canRequestSuspendUnavailable;
    }

    public boolean isCanTable() {
        return this.canTable;
    }

    public boolean isCanTableUnavailable() {
        return this.canTableUnavailable;
    }

    public boolean isCanNotifyIacuc() {
        return this.canNotifyIacuc;
    }

    public boolean isCanNotifyIacucUnavailable() {
        return this.canNotifyIacucUnavailable;
    }

    public boolean isCanDeleteIacucProtocol() {
        return this.canDeleteIacucProtocol;
    }

    public boolean isCanDeleteIacucProtocolUnavailable() {
        return this.canDeleteIacucProtocolUnavailable;
    }

    public boolean isCanReviewNotRequired() {
        return this.canReviewNotRequired;
    }

    public boolean isCanReviewNotRequiredUnavailable() {
        return this.canReviewNotRequiredUnavailable;
    }

    public boolean isCanIacucRequestDeactivate() {
        return this.canIacucRequestDeactivate;
    }

    public boolean isCanIacucRequestDeactivateUnavailable() {
        return this.canIacucRequestDeactivateUnavailable;
    }

    @Override
    protected String getParameterValue(String parameterName) {
        String result = this.getParameterService().getParameterValueAsString(IacucProtocolDocument.class, parameterName);
        if (result == null) {
            result = super.getParameterValue(parameterName);
        }
        return result;
    }

    protected IacucProtocol getIacucProtocol() {
        return this.getProtocol();
    }

    public boolean getCanAssignCmt() {
        return this.canAssignCmt;
    }

    public void setCanAssignCmt(boolean canAssignCmt) {
        this.canAssignCmt = canAssignCmt;
    }

    public boolean getCanAssignCmtUnavailable() {
        return this.canAssignCmtUnavailable;
    }

    public void setCanAssignCmtUnavailable(boolean canAssignCmtUnavailable) {
        this.canAssignCmtUnavailable = canAssignCmtUnavailable;
    }

    @Override
    protected IacucProtocolTask createNewAmendRenewDeleteTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolAmendRenewDelete", (IacucProtocol)protocol);
    }

    public boolean isCanWithdrawSubmission() {
        return this.canWithdrawSubmission;
    }

    public void setCanWithdrawSubmission(boolean canWithdrawSubmission) {
        this.canWithdrawSubmission = canWithdrawSubmission;
    }

    public boolean isCanWithdrawSubmissionUnavailable() {
        return this.canWithdrawSubmissionUnavailable;
    }

    public void setCanWithdrawSubmissionUnavailable(boolean canWithdrawSubmissionUnavailable) {
        this.canWithdrawSubmissionUnavailable = canWithdrawSubmissionUnavailable;
    }

    @Override
    protected IacucProtocolTask createNewAmendRenewDeleteUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolAmendRenewDeleteUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolDeleteBean getNewProtocolDeleteBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolDeleteBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected Class<? extends ReviewCommentsService> getReviewCommentsServiceClassHook() {
        return IacucReviewCommentsService.class;
    }

    @Override
    protected IacucProtocolGenericActionBean buildProtocolGenericActionBean(String actionTypeCode, String errorPropertyKey) {
        IacucProtocolGenericActionBean bean = new IacucProtocolGenericActionBean(this, errorPropertyKey);
        bean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        bean.getReviewCommentsBean().setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(bean.getReviewCommentsBean().getReviewComments()));
        IacucProtocolAction protocolAction = (IacucProtocolAction)this.findProtocolAction(actionTypeCode, this.getProtocol().getProtocolActions(), this.getProtocol().getProtocolSubmission());
        if (protocolAction != null) {
            bean.setComments(protocolAction.getComments());
            bean.setActionDate(new java.sql.Date(protocolAction.getActionDate().getTime()));
        }
        return bean;
    }

    public ProtocolOnlineReviewService getOnlineReviewService() {
        return KcServiceLocator.getService(IacucProtocolOnlineReviewService.class);
    }

    public List<String> getReviewRecommendations() {
        ArrayList<String> recommendations = new ArrayList<String>();
        List<ProtocolOnlineReviewDocumentBase> reviewDocs = this.getOnlineReviewService().getProtocolReviewDocumentsForCurrentSubmission(this.getProtocol());
        for (ProtocolOnlineReviewDocumentBase doc : reviewDocs) {
            IacucProtocolOnlineReview review = (IacucProtocolOnlineReview)doc.getProtocolOnlineReview();
            if (!ObjectUtils.isNotNull((Object)review) || !ObjectUtils.isNotNull((Object)review.getDeterminationReviewTypeCode())) continue;
            recommendations.add(review.getProtocolReviewer().getFullName() + "--" + this.getReviewType(review.getDeterminationReviewTypeCode()));
        }
        return recommendations;
    }

    protected String getReviewType(String code) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reviewTypeCode", code);
        List types = (List)this.getBusinessObjectService().findMatching(IacucProtocolReviewType.class, criteria);
        return !types.isEmpty() ? ((IacucProtocolReviewType)types.get(0)).getDescription() : "";
    }

    @Override
    protected ProtocolTaskBase createNewAbandonTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("iacucProtocolAbandon", (IacucProtocol)protocol);
    }

    @Override
    protected String getAbandonActionTypeHook() {
        return "117";
    }

    @Override
    protected String getAbandonPropertyKeyHook() {
        return "actionHelper.protocolAbandonBean";
    }

    @Override
    protected String getExpireKeyHook() {
        return "302";
    }

    @Override
    protected String getTerminateKeyHook() {
        return "306";
    }

    @Override
    protected String getSuspendKeyHook() {
        return "307";
    }

    @Override
    protected ProtocolSubmitAction getNewProtocolSubmitActionInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolSubmitAction((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolNotifyCommitteeBean getNewProtocolNotifyCommitteeBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolNotifyCommitteeBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolModuleQuestionnaireBeanBase getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolModuleQuestionnaireBean((IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getModifySubmissionAvailableTaskHook() {
        return new IacucProtocolTask("modifyIacucProtocolSubmission", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getModifySubmissionUnavailableTaskHook() {
        return new IacucProtocolTask("modifyIacucProtocolSubmissionUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewSubmitProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("submitIacucProtocol", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewSubmitProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("submitIacucProtocolUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewNotifyCommitteeTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolNotifyCommittee", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewNotifyCommitteeUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolNotifyCommitteeUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolWithdrawBean getNewProtocolWithdrawBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolWithdrawBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAdministrativelyWithdrawBean getNewProtocolAdminWithdrawBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolAdministrativelyWithdrawBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAdministrativelyIncompleteBean getNewProtocolAdminIncompleteBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolAdministrativelyIncompleteBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAmendmentBean getNewProtocolAmendmentBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolAmendmentBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolTaskBase getNewAmendmentProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucAmendment", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewAmendmentProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucAmendmentUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewWithdrawProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolWithdraw", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewWithdrawProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolWithdrawUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolVersionService getProtocolVersionService() {
        if (this.protocolVersionService == null) {
            this.protocolVersionService = KcServiceLocator.getService(IacucProtocolVersionService.class);
        }
        return this.protocolVersionService;
    }

    @Override
    protected String getCoeusModule() {
        return "9";
    }

    @Override
    public void initSummaryDetails() throws Exception {
        if (this.currentSequenceNumber == -1) {
            this.currentSequenceNumber = this.getProtocol().getSequenceNumber();
        } else if (this.currentSequenceNumber > this.getProtocol().getSequenceNumber()) {
            this.currentSequenceNumber = this.getProtocol().getSequenceNumber();
        }
        IacucProtocolSummary iacucProtocolSummary = null;
        String protocolNumber = this.getProtocol().getProtocolNumber();
        IacucProtocol protocol = (IacucProtocol)this.getProtocolVersionService().getProtocolVersion(protocolNumber, this.currentSequenceNumber);
        if (protocol != null) {
            iacucProtocolSummary = (IacucProtocolSummary)protocol.getProtocolSummary();
        }
        IacucProtocolSummary iacucPrevProtocolSummary = null;
        if (this.currentSequenceNumber > 0 && (protocol = (IacucProtocol)this.getProtocolVersionService().getProtocolVersion(protocolNumber, this.currentSequenceNumber - 1)) != null) {
            iacucPrevProtocolSummary = (IacucProtocolSummary)protocol.getProtocolSummary();
        }
        if (iacucProtocolSummary != null && iacucPrevProtocolSummary != null) {
            iacucProtocolSummary.compare(iacucPrevProtocolSummary);
            iacucPrevProtocolSummary.compare(iacucProtocolSummary);
        }
        this.protocolSummary = iacucProtocolSummary;
        this.prevProtocolSummary = iacucPrevProtocolSummary;
        this.setSummaryQuestionnaireExist(this.hasAnsweredQuestionnaire(protocol.isAmendment() || protocol.isRenewal() || protocol.isContinuation() ? "1" : "0", protocol.getSequenceNumber().toString()));
    }

    public boolean isIacucAdmin() {
        return this.getSystemAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", "IACUC Administrator");
    }

    @Override
    protected void setAmendmentDetails() throws Exception {
        if (!this.currentTaskName.equalsIgnoreCase("modifyIacucAmendmentSections")) {
            IacucProtocolAmendmentBean amendmentBean = (IacucProtocolAmendmentBean)this.getProtocolAmendmentBean();
            String originalProtocolNumber = this.getProtocol().isAmendment() ? this.getProtocol().getProtocolAmendRenewal().getProtocolNumber() : this.getProtocol().getProtocolNumber();
            List<ProtocolBase> protocols = this.getProtocolAmendRenewServiceHook().getAmendmentAndRenewals(originalProtocolNumber);
            ProtocolAmendRenewalBase correctAmendment = this.getCorrectAmendment((List)protocols);
            if (ObjectUtils.isNotNull((Object)correctAmendment)) {
                this.setSubmissionHasNoAmendmentDetails(false);
                amendmentBean.setSummary(correctAmendment.getSummary());
                amendmentBean.setGeneralInfo(correctAmendment.hasModule("001"));
                amendmentBean.setProtocolPersonnel(correctAmendment.hasModule("002"));
                amendmentBean.setAreasOfResearch(correctAmendment.hasModule("004"));
                amendmentBean.setAddModifyAttachments(correctAmendment.hasModule("008"));
                amendmentBean.setFundingSource(correctAmendment.hasModule("024"));
                amendmentBean.setOthers(correctAmendment.hasModule("023"));
                amendmentBean.setProtocolOrganizations(correctAmendment.hasModule("017"));
                amendmentBean.setProtocolPermissions(correctAmendment.hasModule("025"));
                amendmentBean.setProtocolReferencesAndOtherIdentifiers(correctAmendment.hasModule("016"));
                amendmentBean.setQuestionnaire(correctAmendment.hasModule("026"));
                amendmentBean.setSpecialReview(correctAmendment.hasModule("007"));
                amendmentBean.setSubjects(correctAmendment.hasModule("006"));
                amendmentBean.setThreers(correctAmendment.hasModule("036"));
                amendmentBean.setSpeciesAndGroups(correctAmendment.hasModule("032"));
                amendmentBean.setProcedures(correctAmendment.hasModule("031"));
                amendmentBean.setProtocolExceptions(correctAmendment.hasModule("033"));
            } else {
                this.setSubmissionHasNoAmendmentDetails(true);
            }
        }
    }

    @Override
    protected IacucProtocolAmendRenewal getCorrectAmendment(List<ProtocolBase> protocols) {
        for (ProtocolBase protocol : protocols) {
            if (!protocol.isAmendment() && !protocol.isRenewalWithAmendment() || !ObjectUtils.isNotNull((Object)protocol.getProtocolSubmission().getSubmissionNumber()) || protocol.getProtocolSubmission().getSubmissionNumber() != this.currentSubmissionNumber) continue;
            IacucProtocol iacucProtocol = (IacucProtocol)protocol;
            return (IacucProtocolAmendRenewal)iacucProtocol.getProtocolAmendRenewal();
        }
        return null;
    }

    @Override
    protected String getAdminApprovalProtocolActionTypeHook() {
        return "215";
    }

    @Override
    protected ProtocolApproveBean getNewProtocolApproveBeanInstanceHook(ActionHelperBase actionHelper, String errorPropertyKey) {
        return new IacucProtocolApproveBean((IacucActionHelper)actionHelper, errorPropertyKey);
    }

    @Override
    protected ProtocolTaskBase getNewAdminApproveProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminApproveProtocol", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewAdminApproveUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminApproveProtocolUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getExpireTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolExpire", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getExpireUnavailableTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolExpireUnavailable", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getTerminateTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolTerminate", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getTerminateUnavailableTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolTerminateUnavailable", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getSuspendTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolSuspend", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getSuspendUnavailableTaskInstanceHook(ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolUnavailableSuspend", (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolTaskBase getNewAdminWithdrawProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminWithdrawProtocol", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewAdminWithdrawUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminWithdrawProtocolUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewAdminMarkIncompleteProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminMarkIncompleteProtocol", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewAdminMarkIncompleteUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("adminMarkIncompleteProtocolUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolAssignToAgendaBean getNewProtocolAssignToAgendaBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucProtocolAssignToAgendaBean((IacucActionHelper)actionHelper);
    }

    @Override
    protected ProtocolTaskBase createNewAssignToAgendaTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolAssignToAgenda", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase createNewAssignToAgendaUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("protocolAssignToAgendaUnavailable", (IacucProtocol)protocol);
    }

    public IacucProtocolNotifyIacucBean getIacucProtocolNotifyIacucBean() {
        return this.iacucProtocolNotifyIacucBean;
    }

    public void setIacucProtocolNotifyIacucBean(IacucProtocolNotifyIacucBean iacucProtocolNotifyIacucBean) {
        this.iacucProtocolNotifyIacucBean = iacucProtocolNotifyIacucBean;
    }

    public void addNotifyIacucAttachment() {
        this.getIacucProtocolNotifyIacucBean().getActionAttachments().add(this.getIacucProtocolNotifyIacucBean().getNewActionAttachment());
        this.getIacucProtocolNotifyIacucBean().setNewActionAttachment(new ProtocolActionAttachment());
    }

    public boolean validFile(ProtocolActionAttachment attachment, String propertyName) {
        boolean valid = true;
        if (attachment.getFile() == null || StringUtils.isBlank((CharSequence)attachment.getFile().getFileName())) {
            valid = false;
            KcServiceLocator.getService(ErrorReporter.class).reportError("actionHelper." + propertyName + ".newActionAttachment.file", "error.attachment.required", new String[0]);
        }
        return valid;
    }

    protected CommitteeDecisionService<? extends CommitteeDecision<? extends CommitteePersonBase>> getCommitteeDecisionService() {
        return KcServiceLocator.getService(IacucCommitteeDecisionService.class);
    }

    @Override
    public int getTotalSubmissions() {
        return this.getProtocolSubmitActionService().getTotalSubmissions(this.getProtocol());
    }

    private IacucProtocolSubmitActionService getProtocolSubmitActionService() {
        return KcServiceLocator.getService(IacucProtocolSubmitActionService.class);
    }

    protected IacucCommitteeDecision getNewCommitteeDecisionInstanceHook(ActionHelperBase actionHelper) {
        return new IacucCommitteeDecision((IacucActionHelper)actionHelper);
    }

    @Override
    protected Class<? extends ProtocolSubmissionDocBase> getProtocolSubmissionDocClassHook() {
        return IacucProtocolSubmissionDoc.class;
    }

    protected Class<? extends FollowupActionService<? extends ValidProtocolActionActionBase>> getFollowupActionServiceClassHook() {
        return IacucFollowupActionService.class;
    }

    @Override
    protected String getProtocolActionTypeCodeForManageReviewCommentsHook() {
        return "310";
    }

    @Override
    protected String getFullApprovalProtocolActionTypeHook() {
        return "204";
    }

    @Override
    protected String getSMRProtocolActionTypeHook() {
        return "209";
    }

    @Override
    protected String getSRRProtocolActionTypeHook() {
        return "211";
    }

    @Override
    protected String getReturnToPIActionTypeHook() {
        return "210";
    }

    @Override
    protected String getDisapprovedProtocolActionTypeHook() {
        return "301";
    }

    public IacucProtocolGenericActionBean getIacucAcknowledgeBean() {
        return this.iacucAcknowledgeBean;
    }

    public void setIacucAcknowledgeBean(IacucProtocolGenericActionBean iacucAcknowledgeBean) {
        this.iacucAcknowledgeBean = iacucAcknowledgeBean;
    }

    public boolean isCanIacucAcknowledge() {
        return this.canIacucAcknowledge;
    }

    public boolean isCanIacucAcknowledgeUnavailable() {
        return this.canIacucAcknowledgeUnavailable;
    }

    @Override
    protected void populateExistingAmendmentBean(ProtocolAmendmentBean amendmentBean, List<String> moduleTypeCodes) {
        IacucProtocolAmendRenewal protocolAmendRenewal = (IacucProtocolAmendRenewal)this.getProtocol().getProtocolAmendRenewal();
        amendmentBean.setSummary(protocolAmendRenewal.getSummary());
        for (ProtocolAmendRenewModuleBase module : protocolAmendRenewal.getModules()) {
            moduleTypeCodes.add(module.getProtocolModuleTypeCode());
            if (StringUtils.equals((CharSequence)"001", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setGeneralInfo(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"008", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setAddModifyAttachments(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"004", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setAreasOfResearch(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"024", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setFundingSource(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"023", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setOthers(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"017", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolOrganizations(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"002", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolPersonnel(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"016", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolReferencesAndOtherIdentifiers(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"007", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setSpecialReview(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"006", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setSubjects(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"025", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolPermissions(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"026", (CharSequence)module.getProtocolModuleTypeCode())) {
                amendmentBean.setQuestionnaire(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"036", (CharSequence)module.getProtocolModuleTypeCode())) {
                ((IacucProtocolAmendmentBean)amendmentBean).setThreers(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"032", (CharSequence)module.getProtocolModuleTypeCode())) {
                ((IacucProtocolAmendmentBean)amendmentBean).setSpeciesAndGroups(true);
                continue;
            }
            if (StringUtils.equals((CharSequence)"031", (CharSequence)module.getProtocolModuleTypeCode())) {
                ((IacucProtocolAmendmentBean)amendmentBean).setProcedures(true);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"033", (CharSequence)module.getProtocolModuleTypeCode())) continue;
            ((IacucProtocolAmendmentBean)amendmentBean).setProtocolExceptions(true);
        }
    }

    @Override
    protected ProtocolAmendRenewService getProtocolAmendRenewServiceHook() {
        return KcServiceLocator.getService(IacucProtocolAmendRenewService.class);
    }

    @Override
    protected void enableModuleOption(String moduleTypeCode, ProtocolEditableBean amendmentBean) {
        if (StringUtils.equals((CharSequence)"001", (CharSequence)moduleTypeCode)) {
            amendmentBean.setGeneralInfoEnabled(true);
        } else if (StringUtils.equals((CharSequence)"008", (CharSequence)moduleTypeCode)) {
            amendmentBean.setAddModifyAttachmentsEnabled(true);
        } else if (StringUtils.equals((CharSequence)"004", (CharSequence)moduleTypeCode)) {
            amendmentBean.setAreasOfResearchEnabled(true);
        } else if (StringUtils.equals((CharSequence)"024", (CharSequence)moduleTypeCode)) {
            amendmentBean.setFundingSourceEnabled(true);
        } else if (StringUtils.equals((CharSequence)"023", (CharSequence)moduleTypeCode)) {
            amendmentBean.setOthersEnabled(true);
        } else if (StringUtils.equals((CharSequence)"017", (CharSequence)moduleTypeCode)) {
            amendmentBean.setProtocolOrganizationsEnabled(true);
        } else if (StringUtils.equals((CharSequence)"002", (CharSequence)moduleTypeCode)) {
            amendmentBean.setProtocolPersonnelEnabled(true);
        } else if (StringUtils.equals((CharSequence)"016", (CharSequence)moduleTypeCode)) {
            amendmentBean.setProtocolReferencesEnabled(true);
        } else if (StringUtils.equals((CharSequence)"007", (CharSequence)moduleTypeCode)) {
            amendmentBean.setSpecialReviewEnabled(true);
        } else if (StringUtils.equals((CharSequence)"006", (CharSequence)moduleTypeCode)) {
            amendmentBean.setSubjectsEnabled(true);
        } else if (StringUtils.equals((CharSequence)"025", (CharSequence)moduleTypeCode)) {
            amendmentBean.setProtocolPermissionsEnabled(true);
        } else if (StringUtils.equals((CharSequence)"026", (CharSequence)moduleTypeCode)) {
            amendmentBean.setQuestionnaireEnabled(true);
        } else if (StringUtils.equals((CharSequence)"036", (CharSequence)moduleTypeCode)) {
            ((IacucProtocolEditableBean)amendmentBean).setThreersEnabled(true);
        } else if (StringUtils.equals((CharSequence)"032", (CharSequence)moduleTypeCode)) {
            ((IacucProtocolEditableBean)amendmentBean).setSpeciesAndGroupsEnabled(true);
        } else if (StringUtils.equals((CharSequence)"031", (CharSequence)moduleTypeCode)) {
            ((IacucProtocolEditableBean)amendmentBean).setProceduresEnabled(true);
        } else if (StringUtils.equals((CharSequence)"033", (CharSequence)moduleTypeCode)) {
            ((IacucProtocolEditableBean)amendmentBean).setProtocolExceptionsEnabled(true);
        }
    }

    @Override
    protected void enableModuleOption(ProtocolAmendmentBean amendmentBean, ProtocolAmendRenewalBase correctAmendment) {
        amendmentBean.setGeneralInfo(correctAmendment.hasModule("001"));
        amendmentBean.setProtocolPersonnel(correctAmendment.hasModule("002"));
        amendmentBean.setAreasOfResearch(correctAmendment.hasModule("004"));
        amendmentBean.setAddModifyAttachments(correctAmendment.hasModule("008"));
        amendmentBean.setFundingSource(correctAmendment.hasModule("024"));
        amendmentBean.setOthers(correctAmendment.hasModule("023"));
        amendmentBean.setProtocolOrganizations(correctAmendment.hasModule("017"));
        amendmentBean.setProtocolPermissions(correctAmendment.hasModule("025"));
        amendmentBean.setProtocolReferencesAndOtherIdentifiers(correctAmendment.hasModule("016"));
        amendmentBean.setQuestionnaire(correctAmendment.hasModule("026"));
        amendmentBean.setSpecialReview(correctAmendment.hasModule("007"));
        amendmentBean.setSubjects(correctAmendment.hasModule("006"));
        ((IacucProtocolAmendmentBean)amendmentBean).setThreers(correctAmendment.hasModule("036"));
        ((IacucProtocolAmendmentBean)amendmentBean).setSpecialReview(correctAmendment.hasModule("032"));
        ((IacucProtocolAmendmentBean)amendmentBean).setProcedures(correctAmendment.hasModule("031"));
        ((IacucProtocolAmendmentBean)amendmentBean).setProtocolExceptions(correctAmendment.hasModule("033"));
    }

    private void prepareAssignCommitteeActionView() {
        this.canAssignCmt = this.hasPermission("iacucProtocolAssignToCmt");
        this.canAssignCmtUnavailable = this.hasPermission("iacucProtocolAssignToCmtUnavailable");
        if (this.canAssignCmt) {
            Collection<?> committees = this.getCommitteeIdByUnitValuesFinderService().getAssignmentCommittees(this.getProtocol().getLeadUnitNumber(), this.getDocRouteStatus(), this.protocolAssignCmtBean.getCommitteeId());
            this.assignCmtActionCommitteeIdByUnitKeyValues = this.getKeyValuesForCommitteeSelection(committees);
        }
    }

    private void prepareModifySubmissionActionView() {
        this.iacucProtocolModifySubmissionBean.prepareView();
        if (this.canModifyProtocolSubmission) {
            Collection<?> committees = this.getCommitteeIdByUnitValuesFinderService().getAssignmentCommittees(this.getProtocol().getLeadUnitNumber(), this.getDocRouteStatus(), this.iacucProtocolModifySubmissionBean.getCommitteeId());
            this.modifySubmissionActionCommitteeIdByUnitKeyValues = this.getKeyValuesForCommitteeSelection(committees);
        }
    }

    @Override
    protected ProtocolTaskBase getModifyAmendmentSectionsProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("modifyIacucAmendmentSections", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getModifyAmendmentSectionsUnavailableProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("modifyIacucAmendmentSectionsUnavailable", (IacucProtocol)protocol);
    }

    private boolean hasDeactivateRequestLastAction() {
        return "107".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    public boolean isCanIacucDeactivate() {
        return this.canIacucDeactivate;
    }

    public void setCanIacucDeactivate(boolean canIacucDeactivate) {
        this.canIacucDeactivate = canIacucDeactivate;
    }

    public boolean isCanIacucDeactivateUnavailable() {
        return this.canIacucDeactivateUnavailable;
    }

    public void setCanIacucDeactivateUnavailable(boolean canIacucDeactivateUnavailable) {
        this.canIacucDeactivateUnavailable = canIacucDeactivateUnavailable;
    }

    public boolean isCanAddDeactivateReviewerComments() {
        return this.canAddDeactivateReviewerComments;
    }

    public void setCanAddDeactivateReviewerComments(boolean canAddDeactivateReviewerComments) {
        this.canAddDeactivateReviewerComments = canAddDeactivateReviewerComments;
    }

    public IacucProtocolRequestBean getIacucProtocolDeactivateRequestBean() {
        return this.iacucProtocolDeactivateRequestBean;
    }

    public void setIacucProtocolDeactivateRequestBean(IacucProtocolRequestBean iacucProtocolDeactivateRequestBean) {
        this.iacucProtocolDeactivateRequestBean = iacucProtocolDeactivateRequestBean;
    }

    public IacucProtocolRequestBean getIacucProtocolLiftHoldRequestBean() {
        return this.iacucProtocolLiftHoldRequestBean;
    }

    public void setIacucProtocolLiftHoldRequestBean(IacucProtocolRequestBean iacucProtocolLiftHoldRequestBean) {
        this.iacucProtocolLiftHoldRequestBean = iacucProtocolLiftHoldRequestBean;
    }

    public void setCanIacucRequestDeactivate(boolean canIacucRequestDeactivate) {
        this.canIacucRequestDeactivate = canIacucRequestDeactivate;
    }

    public void setCanIacucRequestDeactivateUnavailable(boolean canIacucRequestDeactivateUnavailable) {
        this.canIacucRequestDeactivateUnavailable = canIacucRequestDeactivateUnavailable;
    }

    @Override
    public boolean isSubmissionQuestionnaireExist() {
        return this.submissionQuestionnaireExist;
    }

    @Override
    public void setSubmissionQuestionnaireExist(boolean submissionQuestionnaireExist) {
        this.submissionQuestionnaireExist = submissionQuestionnaireExist;
    }

    @Override
    public boolean isToAnswerSubmissionQuestionnaire() {
        return this.toAnswerSubmissionQuestionnaire;
    }

    @Override
    public void setToAnswerSubmissionQuestionnaire(boolean toAnswerSubmissionQuestionnaire) {
        this.toAnswerSubmissionQuestionnaire = toAnswerSubmissionQuestionnaire;
    }

    public IacucProtocolGenericActionBean getIacucProtocolHoldBean() {
        return this.iacucProtocolHoldBean;
    }

    public void setIacucProtocolHoldBean(IacucProtocolGenericActionBean iacucProtocolHoldBean) {
        this.iacucProtocolHoldBean = iacucProtocolHoldBean;
    }

    public IacucProtocolGenericActionBean getIacucProtocolLiftHoldBean() {
        return this.iacucProtocolLiftHoldBean;
    }

    @Override
    protected ProtocolTaskBase getAdminCorrectionProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("iacucProtocolAdminCorrection", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getAdminCorrectionUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("iacucProtocolAdminCorrectionUnavailable", (IacucProtocol)protocol);
    }

    @Override
    protected AdminCorrectionBean getNewAdminCorrectionBeanInstanceHook(ActionHelperBase actionHelper) {
        return new IacucAdminCorrectionBean((IacucActionHelper)actionHelper);
    }

    public IacucProtocolRequestBean getIacucProtocolSuspendRequestBean() {
        return this.iacucProtocolSuspendRequestBean;
    }

    public void setIacucProtocolSuspendRequestBean(IacucProtocolRequestBean iacucProtocolSuspendRequestBean) {
        this.iacucProtocolSuspendRequestBean = iacucProtocolSuspendRequestBean;
    }

    public IacucProtocolRequestBean getIacucProtocolWithdrawSubmissionBean() {
        return this.iacucProtocolWithdrawSubmissionBean;
    }

    public void setIacucProtocolWithdrawSubmissionBean(IacucProtocolRequestBean iacucProtocolWithdrawSubmissionBean) {
        this.iacucProtocolWithdrawSubmissionBean = iacucProtocolWithdrawSubmissionBean;
    }

    @Override
    protected UndoLastActionBean getNewUndoLastActionBeanInstanceHook() {
        return new IacucProtocolUndoLastActionBean(this, "actionHelper.undoLastActionBean");
    }

    @Override
    protected ProtocolQuestionnairePrintingService getProtocolQuestionnairePrintingServiceHook() {
        return KcServiceLocator.getService(IacucProtocolQuestionnairePrintingService.class);
    }

    public boolean getCanRemoveFromAgenda() {
        return this.canRemoveFromAgenda;
    }

    public void setCanRemoveFromAgenda(boolean canRemoveFromAgenda) {
        this.canRemoveFromAgenda = canRemoveFromAgenda;
    }

    public IacucProtocolGenericActionBean getIacucProtocolRemoveFromAgendaBean() {
        return this.iacucProtocolRemoveFromAgendaBean;
    }

    public void setIacucProtocolRemoveFromAgendaBean(IacucProtocolGenericActionBean iacucProtocolRemoveFromAgendaBean) {
        this.iacucProtocolRemoveFromAgendaBean = iacucProtocolRemoveFromAgendaBean;
    }

    public ProtocolReviewNotRequiredBean getProtocolReviewNotRequiredBean() {
        return this.iacucProtocolReviewNotRequiredBean;
    }

    public void setProtocolReviewNotRequiredBean(ProtocolReviewNotRequiredBean iacucProtocolReviewNotRequiredBean) {
        this.iacucProtocolReviewNotRequiredBean = iacucProtocolReviewNotRequiredBean;
    }

    @Override
    protected ProtocolTaskBase getNewRenewalProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucRenewal", (IacucProtocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewRenewalProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucRenewalUnavailable", (IacucProtocol)protocol);
    }

    @Override
    public void initAmendmentBeans(boolean forceReset) throws Exception {
        super.initAmendmentBeans(forceReset);
        if (this.protocolContinuationAmendmentBean == null || forceReset) {
            this.protocolContinuationAmendmentBean = this.createAmendmentBean();
        }
    }

    @Override
    protected ProtocolAmendmentBean createAmendmentBean() throws Exception {
        this.protocolAmendmentBean = super.createAmendmentBean();
        this.protocolContinuationAmendmentBean = this.getNewProtocolAmendmentBeanInstanceHook(this);
        this.configureAmendmentBean(this.protocolContinuationAmendmentBean);
        return this.protocolAmendmentBean;
    }

    @Override
    protected ProtocolAmendmentBean configureAmendmentBean(ProtocolAmendmentBean amendmentBean) throws Exception {
        List<String> moduleTypeCodes;
        if (StringUtils.isNotEmpty((CharSequence)this.getProtocol().getProtocolNumber()) && !this.getProtocol().isNew()) {
            moduleTypeCodes = this.getProtocolAmendRenewServiceHook().getAvailableModules(this.getProtocol().getAmendedProtocolNumber());
            this.populateExistingAmendmentBean(amendmentBean, moduleTypeCodes);
        } else {
            moduleTypeCodes = this.getProtocolAmendRenewServiceHook().getAvailableModules(this.getProtocol().getProtocolNumber());
        }
        for (String moduleTypeCode : moduleTypeCodes) {
            this.enableModuleOption(moduleTypeCode, amendmentBean);
        }
        return amendmentBean;
    }

    @Override
    protected boolean hasModifyAmendmentSectionsPermission() {
        ProtocolTaskBase task = this.getModifyAmendmentSectionsProtocolTaskInstanceHook(this.getProtocol());
        return !this.getProtocol().isRenewalWithoutAmendment() && !this.getProtocol().isContinuationWithoutAmendment() && this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasCreateContinuationPermission() {
        ProtocolTaskBase task = this.getNewContinuationProtocolTaskInstance(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected boolean hasCreateContinuationUnavailablePermission() {
        ProtocolTaskBase task = this.getNewContinuationProtocolUnavailableTaskInstance(this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected ProtocolTaskBase getNewContinuationProtocolTaskInstance(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucContinuation", (IacucProtocol)protocol);
    }

    protected ProtocolTaskBase getNewContinuationProtocolUnavailableTaskInstance(ProtocolBase protocol) {
        return new IacucProtocolTask("createIacucContinuationUnavailable", (IacucProtocol)protocol);
    }

    public boolean getCanCreateContinuation() {
        return this.canCreateContinuation;
    }

    public boolean getCanCreateContinuationUnavailable() {
        return this.canCreateContinuationUnavailable;
    }

    public boolean getHasContinuations() throws Exception {
        List protocols;
        this.hasContinuations = this.getProtocol().isContinuation() ? true : !(protocols = (List)((IacucProtocolAmendRenewService)this.getProtocolAmendRenewServiceHook()).getContinuations(this.getProtocol().getProtocolNumber())).isEmpty();
        return this.hasContinuations;
    }

    public String getContinuationSummary() {
        return this.continuationSummary;
    }

    public void setContinuationSummary(String continuationSummary) {
        this.continuationSummary = continuationSummary;
    }

    public ProtocolAmendmentBean getProtocolContinuationAmendmentBean() {
        return this.protocolContinuationAmendmentBean;
    }

    public void setProtocolContinuationAmendmentBean(ProtocolAmendmentBean protocolContinuationAmendmentBean) {
        this.protocolContinuationAmendmentBean = protocolContinuationAmendmentBean;
    }

    @Override
    public int getDefaultExpirationDateDifference() {
        try {
            int retVal = Integer.parseInt(this.getParameterService().getParameterValueAsString("KC-IACUC", "Document", "PROTCOL_DEFAULT_EXPIRATION_DATE_DIFFERENCE", "1"));
            return retVal;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return 1;
        }
    }

    @Override
    protected Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook() {
        return IacucCommitteeScheduleService.class;
    }

    @Override
    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook() {
        return IacucProtocolDocument.class;
    }

    @Override
    protected ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase protocol, String actionTypeCode, String submissionNumber, boolean finalDoc) {
        return new IacucSubmissionQuestionnaireHelper(protocol, actionTypeCode, submissionNumber, finalDoc);
    }

    @Override
    protected boolean hasApproveOtherPermission() {
        IacucProtocolTask task = new IacucProtocolTask("protocolApproveOther", this.getIacucProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    @Override
    protected void initializeSubmissionConstraintHook() {
        this.submissionConstraint = this.getParameterValue("IACUC_COMM_SELECTION_DURING_SUBMISSION");
    }

    @Override
    protected ProtocolTaskBase getNewProtocolTaskInstanceHook(String taskName) {
        return new IacucProtocolTask(taskName, this.getIacucProtocol());
    }

    @Override
    protected Class<? extends ProtocolCorrespondenceAuthorizationService> getProtocolCorrespondenceAuthorizationServiceClassHook() {
        return IacucProtocolCorrespondenceAuthorizationService.class;
    }

    @Override
    protected Class<? extends CommitteeIdByUnitValuesFinderService<?>> getCommitteeIdByUnitValuesFinderServiceClassHook() {
        return IacucCommitteeIdByUnitValuesFinderService.class;
    }

    public List<KeyValue> getAssignCmtActionCommitteeIdByUnitKeyValues() {
        return this.assignCmtActionCommitteeIdByUnitKeyValues;
    }

    public List<KeyValue> getModifySubmissionActionCommitteeIdByUnitKeyValues() {
        return this.modifySubmissionActionCommitteeIdByUnitKeyValues;
    }

    @Override
    protected void initPrintCorrespondence() {
        ArrayList<CorrespondencePrintOption> printOptions = new ArrayList<CorrespondencePrintOption>();
        HashMap values = new HashMap();
        List correspondenceTypes = (List)KcServiceLocator.getService(BusinessObjectService.class).findMatching(IacucProtocolCorrespondenceType.class, values);
        for (IacucProtocolCorrespondenceType correspondenceType : correspondenceTypes) {
            if (!StringUtils.equals((CharSequence)correspondenceType.getModuleId(), (CharSequence)CorrespondenceTypeModuleIdConstants.PROTOCOL.getCode())) continue;
            CorrespondencePrintOption printOption = new CorrespondencePrintOption();
            printOption.setDescription(correspondenceType.getDescription());
            printOption.setLabel(correspondenceType.getDescription());
            printOption.setCorrespondenceId(1L);
            printOption.setProtocolCorrespondenceTemplate(correspondenceType.getDefaultProtocolCorrespondenceTemplate());
            printOptions.add(printOption);
        }
        this.setCorrespondencesToPrint(printOptions);
    }

    private boolean hasAssignReviewersCmtSel() {
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolAssignReviewersCmtSel", this.getIacucProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public boolean isReviewersDisplayToBeSuppressed() {
        boolean retVal = false;
        IacucProtocolSubmitAction submitBean = (IacucProtocolSubmitAction)this.getProtocolSubmitAction();
        if (!this.canAssignReviewersCmtSel || StringUtils.isBlank((CharSequence)submitBean.getScheduleId()) || StringUtils.isBlank((CharSequence)submitBean.getCommitteeId())) {
            retVal = true;
        }
        return retVal;
    }
}

