/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolActionRequestService;
import org.kuali.kra.iacuc.actions.IacucProtocolActionType;
import org.kuali.kra.iacuc.actions.IacucProtocolRequestAction;
import org.kuali.kra.iacuc.actions.abandon.IacucProtocolAbandonService;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucAmendmentEvent;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucContinuationEvent;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucRenewalEvent;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewService;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendmentBean;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveBean;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveEvent;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveService;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtBean;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtEvent;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtService;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaBean;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaEvent;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaService;
import org.kuali.kra.iacuc.actions.correction.IacucAdminCorrectionBean;
import org.kuali.kra.iacuc.actions.correction.IacucProtocolAdminCorrectionEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecision;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionEvent;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionEvent;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionService;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredBean;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredEvent;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredService;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucService;
import org.kuali.kra.iacuc.actions.notifyiacuc.NotifyIacucNotificationRenderer;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestEvent;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestService;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionService;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableBean;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableService;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolWithdrawService;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondence;
import org.kuali.kra.iacuc.notification.IacucProtocolAssignReviewerNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRequestBean;
import org.kuali.kra.iacuc.notification.IacucProtocolRequestActionNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolReviewDeterminationNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolWithReasonNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucRequestActionNotificationBean;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolQuestionnaireAuditRule;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolActionBean;
import org.kuali.kra.protocol.actions.ProtocolActionRequestServiceImpl;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.correction.AdminCorrectionBean;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRequestBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolQuestionnaireAuditRuleBase;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class IacucProtocolActionRequestServiceImpl
extends ProtocolActionRequestServiceImpl
implements IacucProtocolActionRequestService {
    private static final Logger LOG = LogManager.getLogger(IacucProtocolActionRequestServiceImpl.class);
    private static Map<String, String> motionTypeMap = new HashMap<String, String>(){
        {
            this.put("1", "Approve Action");
            this.put("2", "Disapprove");
            this.put("3", "Return for Specific Minor Revisions");
            this.put("4", "Return for Substantive Revisions Required");
        }
    };
    protected static List<String> requestSubmissionTypes = Arrays.asList("111", "103", "102");
    private IacucProtocolApproveService protocolApproveService;
    private IacucProtocolSubmitActionService protocolSubmitActionService;
    private IacucProtocolAmendRenewService protocolAmendRenewService;
    private IacucProtocolAssignToAgendaService protocolAssignToAgendaService;
    private IacucProtocolReviewNotRequiredService protocolReviewNotRequiredService;
    private IacucProtocolRequestService protocolRequestService;
    private IacucProtocolGenericActionService protocolGenericActionService;
    private IacucProtocolAbandonService protocolAbandonService;
    private IacucProtocolModifySubmissionService modifySubmissionService;
    private IacucProtocolTableService protocolTableService;
    private IacucProtocolWithdrawService protocolWithdrawService;
    private IacucProtocolNotifyIacucService protocolNotifyService;
    private IacucCommitteeDecisionService committeeDecisionService;
    private IacucProtocolAssignCmtService assignToCmtService;
    private IacucProtocolActionService protocolActionService;
    private static final String ACTION_NAME_CONTINUATION_WITHOUT_AMENDMENT = "Create Continuation without Amendment";
    private static final String ACTION_NAME_CONTINUATION_WITH_AMENDMENT = "Create Continuation with Amendment";
    private static final String ACTION_NAME_REMOVE_FROM_AGENDA = "Removed Agenda";
    private static final String ACTION_NAME_ACKNOWLEDGEMENT = "IACUC Acknowledgement";
    private static final String ACTION_NAME_HOLD = "IACUC Hold";
    private static final String ACTION_NAME_LIFT_HOLD = "IACUC Lift Hold";
    private static final String ACTION_NAME_DEACTIVATED = "Deactivated";
    private static final String ACTION_NAME_MODIFY_SUBMISSION = "Modify Submission";
    private static final String ACTION_NAME_TABLE_PROTOCOL = "Table ProtocolBase";
    private static final String ACTION_NAME_ADMINISTRATIVELY_WITHDRAW = "Administratively Withdraw";
    private static final String ACTION_NAME_NOTIFY = "Notify IACUC";
    private static final String ACTION_NAME_REVIEW_TYPE_DETERMINATION = "Send Review Type Determination Notification";
    private static final String ACTION_NAME_ADMINISTRATIVELY_INCOMPLETE = "Administratively Mark Incomplete";
    private static final String ACTION_NAME_ASSIGN_TO_COMMITTEE = "Assign to Committee";

    @Override
    public boolean isFullApprovalAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        if (this.hasPermission("protocolApprove", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolApproveEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateAmendmentAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolAmendmentBean protocolAmendmentBean = (IacucProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolAmendmentBean();
        if (this.hasPermission("createIacucAmendment", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateIacucAmendmentEvent(document, "actionHelper.protocolCreateAmendment", (ProtocolAmendmentBean)protocolAmendmentBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateRenewalAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        String renewalSummary = protocolForm.getActionHelper().getRenewalSummary();
        if (this.hasPermission("createIacucRenewal", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateIacucRenewalEvent(document, "actionHelper.renewalSummary", renewalSummary));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateRenewalWithAmendmentAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolAmendmentBean renewAmendmentBean = (IacucProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolRenewAmendmentBean();
        if (this.hasPermission("createIacucRenewal", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateIacucAmendmentEvent(document, "actionHelper.protocolCreateRenewalWithAmendment", (ProtocolAmendmentBean)renewAmendmentBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateContinuationAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        String continuationSummary = actionHelper.getContinuationSummary();
        if (this.hasPermission("createIacucContinuation", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateIacucContinuationEvent(document, "actionHelper.continuationSummary", continuationSummary));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isCreateContinuationWithAmendmentAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolAmendmentBean continuationAmendmentBean = (IacucProtocolAmendmentBean)actionHelper.getProtocolContinuationAmendmentBean();
        if (this.hasPermission("createIacucContinuation", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new CreateIacucAmendmentEvent(document, "actionHelper.protocolCreateContinuationWithAmendment", (ProtocolAmendmentBean)continuationAmendmentBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAssignToAgendaAuthorized(IacucProtocolForm protocolForm) {
        protocolForm.getActionHelper().setCurrentTask("protocolAssignToAgenda");
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        IacucProtocolAssignToAgendaBean actionBean = (IacucProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolAssignToAgenda", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolAssignToAgendaEvent(document, actionBean));
                actionBean.prepareView();
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isRemoveFromAgendaAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("protocolRemoveFromAgenda", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isProtocolReviewNotRequiredAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolReviewNotRequiredBean actionBean = (IacucProtocolReviewNotRequiredBean)actionHelper.getProtocolReviewNotRequiredBean();
        if (this.hasPermission("reviewNotRequiredIacucProtocol", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolReviewNotRequiredEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isGrantAdminApprovalAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolAdminApprovalBean();
        if (this.hasPermission("adminApproveProtocol", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolApproveEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isRequestActionAuthorized(IacucProtocolForm protocolForm, String taskName) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        if (StringUtils.isNotBlank((CharSequence)taskName)) {
            requestAuthorized = this.hasPermission(taskName, document.getProtocol());
        }
        return requestAuthorized;
    }

    @Override
    public boolean isDisapproveProtocolAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        if (this.hasPermission("protocolDisapprove", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isTerminateProtocolAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        if (this.hasGenericPermission("iacucProtocolTerminate", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isExpireProtocolAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        if (this.hasGenericPermission("iacucProtocolExpire", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isSuspendProtocolAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        if (this.hasGenericPermission("iacucProtocolSuspend", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAcknowledgementAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucAcknowledgeBean();
        if (this.hasPermission("iacucAcknowledgement", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isHoldAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolHoldBean();
        if (this.hasPermission("iacucProtocolHold", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isLiftHoldAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolLiftHoldBean();
        if (this.hasPermission("iacucProtocolLiftHold", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isReturnForSMRAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        if (this.hasPermission("protocolReturnForSMR", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isReturnForSRRAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        if (this.hasPermission("protocolReturnForSRR", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isReturnToPIAuthorized(IacucProtocolForm protocolForm) {
        boolean requestAuthorized = false;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        if (this.hasPermission("protocolReturnToPI", document.getProtocol())) {
            requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
        }
        return requestAuthorized;
    }

    @Override
    public boolean isDeactivateAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("iacucProtocolDeactivate", document.getProtocol())) {
                IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
                IacucProtocolGenericActionBean actionBean = actionHelper.getIacucProtocolDeactivateBean();
                requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isOpenProtocolForAdminCorrectionAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        AdminCorrectionBean actionBean = protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("iacucProtocolAdminCorrection", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolAdminCorrectionEvent(document, "actionHelper.protocolAdminCorrectionBean", actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAbandonAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        requestAuthorized = this.hasPermission("iacucProtocolAbandon", document.getProtocol());
        return requestAuthorized;
    }

    @Override
    public boolean isModifySubmissionActionAuthorized(IacucProtocolForm protocolForm, List<ProtocolReviewerBeanBase> reviewers) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        IacucProtocolModifySubmissionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolModifySubmissionBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("modifyIacucProtocolSubmission", document.getProtocol())) {
                actionBean.setReviewers(reviewers);
                requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolModifySubmissionEvent(document, actionBean));
                protocolForm.setReinitializeModifySubmissionFields(false);
                actionBean.prepareView();
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isTableProtocolAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("iacucProtocolTable", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAdministrativelyWithdrawProtocolAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("adminWithdrawProtocol", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isWithdrawProtocolAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("protocolWithdraw", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAdministrativelyMarkIncompleteProtocolAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            requestAuthorized = this.hasPermission("adminMarkIncompleteProtocol", document.getProtocol());
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isSubmitCommitteeDecisionAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucCommitteeDecision actionBean = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
            requestAuthorized = this.applyRules((DocumentEvent)new IacucCommitteeDecisionEvent(document, actionBean));
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isAssignCommitteeAuthorized(IacucProtocolForm protocolForm) {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        boolean requestAuthorized = false;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolAssignCmtBean actionBean = actionHelper.getProtocolAssignCmtBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("iacucProtocolAssignToCmt", document.getProtocol())) {
                requestAuthorized = this.applyRules((DocumentEvent)new IacucProtocolAssignCmtEvent(document, actionBean));
            }
        } else {
            this.updateDocumentStatusChangedMessage();
        }
        return requestAuthorized;
    }

    @Override
    public boolean isWithdrawRequestActionAuthorized(IacucProtocolForm protocolForm) {
        return this.hasPermission("iacucWithdrawSubmission", protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void grantFullApproval(IacucProtocolForm protocolForm) throws Exception {
        String actionDescription2;
        String actionDescription;
        String actionType;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolApproveService().grantFullApproval(document, actionBean);
        IacucProtocolSubmission submission = (IacucProtocolSubmission)protocol.getProtocolSubmission();
        if (StringUtils.equals((CharSequence)submission.getProtocolReviewTypeCode(), (CharSequence)"2")) {
            actionType = "212";
            actionDescription = "Designated Member Approval";
            actionDescription2 = "Designated Member Approved";
        } else {
            actionType = "204";
            actionDescription = "Full Approval";
            actionDescription2 = "Approved";
        }
        this.generateActionCorrespondence(actionType, protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(actionDescription);
        protocolForm.getProtocolHelper().prepareView();
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            GlobalVariables.getUserSession().addObject("approvalComplCorrespondence", GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY"));
            GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
        } else {
            IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer(document.getProtocol());
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(document.getProtocol(), actionType, actionDescription2, renderer);
            this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        }
    }

    @Override
    public void submitForReview(IacucProtocolForm protocolForm, List<ProtocolReviewerBeanBase> reviewers) throws Exception {
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        IacucProtocolSubmitAction submitAction = (IacucProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction();
        submitAction.setReviewers(reviewers);
        this.getProtocolSubmitActionService().submitToIacucForReview(protocol, submitAction);
        this.generateActionCorrespondence("101", protocolForm.getProtocolDocument().getProtocol());
        IacucProtocolNotificationRenderer submitRenderer = new IacucProtocolNotificationRenderer(protocol);
        IacucProtocolNotificationContext submitContext = new IacucProtocolNotificationContext(protocol, null, "101", "Submit", submitRenderer);
        this.getNotificationService().sendNotificationAndPersist(submitContext, new IacucProtocolNotification(), protocol);
    }

    @Override
    public String createAmendment(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        String newDocId = this.getProtocolAmendRenewService().createAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
        this.generateActionCorrespondence("102", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Amendment", true);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "323", "Amendment Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String createRenewal(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        String newDocId = this.getProtocolAmendRenewService().createRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getRenewalSummary());
        this.generateActionCorrespondence("104", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Renewal without Amendment", true);
        protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(protocolForm.getActionHelper().getRenewalSummary());
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "322", "Renewal Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String createRenewalWithAmendment(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocolAmendmentBean renewAmendmentBean = (IacucProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolRenewAmendmentBean();
        String newDocId = this.getProtocolAmendRenewService().createRenewalWithAmendment(protocolDocument, renewAmendmentBean);
        this.generateActionCorrespondence("909", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, "Create Renewal with Amendment", true);
        protocolForm.getActionHelper().setProtocolAmendmentBean(renewAmendmentBean);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "909", "Renewal With Amendment Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String createContinuation(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        String newDocId = this.getProtocolAmendRenewService().createContinuation(protocolDocument, actionHelper.getContinuationSummary());
        this.generateActionCorrespondence("103", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, ACTION_NAME_CONTINUATION_WITHOUT_AMENDMENT, true);
        protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(actionHelper.getContinuationSummary());
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "322", "Continuation Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String createContinuationWithAmendment(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolAmendmentBean continuationAmendmentBean = (IacucProtocolAmendmentBean)actionHelper.getProtocolContinuationAmendmentBean();
        String newDocId = this.getProtocolAmendRenewService().createContinuationWithAmendment(protocolDocument, continuationAmendmentBean);
        this.generateActionCorrespondence("105", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocId, ACTION_NAME_CONTINUATION_WITH_AMENDMENT, true);
        protocolForm.getActionHelper().setProtocolAmendmentBean(continuationAmendmentBean);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "105", "Continuation With Amendment Created");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String assignToAgenda(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolAssignToAgendaBean actionBean = (IacucProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolAssignToAgendaService().assignToAgenda(protocol, actionBean);
        this.generateActionCorrespondence("200", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Assign to Agenda");
        ProtocolActionBase lastAction = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction();
        ProtocolActionTypeBase lastActionType = lastAction.getProtocolActionType();
        String description = lastActionType.getDescription();
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "200", description);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocolActions");
    }

    @Override
    public String removeFromAgenda(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolGenericActionBean actionBean = actionHelper.getIacucProtocolRemoveFromAgendaBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolAssignToAgendaService().removeFromAgenda(protocol, actionBean);
        this.generateActionCorrespondence("312", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_REMOVE_FROM_AGENDA);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "312", actionBean.getComments());
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocolActions");
    }

    @Override
    public String protocolReviewNotRequired(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolReviewNotRequiredBean actionBean = (IacucProtocolReviewNotRequiredBean)actionHelper.getProtocolReviewNotRequiredBean();
        this.getProtocolReviewNotRequiredService().reviewNotRequired(document, actionBean);
        this.generateActionCorrespondence("207", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Review Not Required");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(document.getIacucProtocol(), "207", "Review Not Required");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String grantAdminApproval(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolAdminApprovalBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolApproveService().grantAdminApproval(document, actionBean);
        this.generateActionCorrespondence("215", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Administrative Approval");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(document.getProtocol(), "215", "Admin Approval");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String performRequestAction(IacucProtocolForm protocolForm, String taskName) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocolRequestAction requestAction = IacucProtocolRequestAction.valueOfTaskName(taskName);
        IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(protocolForm, taskName);
        if (requestBean != null) {
            boolean valid = this.applyRules((DocumentEvent)new IacucProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean));
            requestBean.setAnswerHeaders(this.getAnswerHeaders(protocolForm, requestAction.getActionTypeCode()));
            if (valid &= this.isMandatoryQuestionnaireComplete(requestBean.getAnswerHeaders(), "actionHelper." + requestAction.getBeanName() + ".datavalidation")) {
                this.getProtocolRequestService().submitRequest(protocolForm.getIacucProtocolDocument().getIacucProtocol(), requestBean);
                this.generateActionCorrespondence(requestBean.getProtocolActionTypeCode(), protocolForm.getProtocolDocument().getProtocol());
                this.recordProtocolActionSuccess(requestAction.getActionName());
                return this.sendRequestNotification(protocolForm, requestBean.getProtocolActionTypeCode(), requestBean.getReason(), "iacucProtocolActions");
            }
        }
        return "basic";
    }

    @Override
    public String disapproveProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().disapprove(protocol, actionBean);
        this.generateActionCorrespondence("301", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Disapprove");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "301", "Disapproved");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String expireProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().expire(protocol, actionBean);
        this.generateActionCorrespondence("302", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Expire");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "302", "Expired");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String terminateProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().terminate(protocol, actionBean);
        this.generateActionCorrespondence("306", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Terminate");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "306", "Terminated");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String suspendProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().suspend(protocol, actionBean);
        this.generateActionCorrespondence("307", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Suspend");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "307", "Suspended");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String acknowledgement(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucAcknowledgeBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().iacucAcknowledgement(protocol, actionBean);
        this.generateActionCorrespondence("206", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_ACKNOWLEDGEMENT);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "206", ACTION_NAME_ACKNOWLEDGEMENT);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocolActions");
    }

    @Override
    public String hold(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolHoldBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().iacucHold(protocol, actionBean);
        this.generateActionCorrespondence("305", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_HOLD);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "305", ACTION_NAME_HOLD);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String liftHold(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolLiftHoldBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().iacucLiftHold(protocol, actionBean);
        this.generateActionCorrespondence("208", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_LIFT_HOLD);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "208", ACTION_NAME_LIFT_HOLD);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String returnForSMR(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnForSMR(protocol, actionBean);
        this.generateActionCorrespondence("209", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return for Specific Minor Revisions", false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "209", "Minor Revisions Required");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String returnForSRR(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnForSRR(protocol, actionBean);
        this.generateActionCorrespondence("211", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return for Substantive Revisions Required", false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "211", "Major Revisions Required");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String returnToPI(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnToPI(protocol, actionBean);
        this.generateActionCorrespondence("210", protocolForm.getProtocolDocument().getProtocol());
        this.refreshAfterProtocolAction(protocolForm, newDocument.getDocumentNumber(), "Return To PI", false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)newDocument.getProtocol(), "210", "Return To PI");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String deactivate(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolGenericActionBean actionBean = actionHelper.getIacucProtocolDeactivateBean();
        this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
        this.getProtocolGenericActionService().iacucDeactivate(protocol, actionBean);
        this.generateActionCorrespondence("303", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_DEACTIVATED);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "303", ACTION_NAME_DEACTIVATED);
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String openProtocolForAdminCorrection(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        document.getProtocol().setCorrectionMode(true);
        protocolForm.getProtocolHelper().prepareView();
        IacucAdminCorrectionBean adminCorrectionBean = (IacucAdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
        document.updateProtocolStatus("113", adminCorrectionBean.getComments());
        this.generateActionCorrespondence("113", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess("Make Administrative Correction");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "113", "Administrative Correction");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String abandon(IacucProtocolForm protocolForm) throws Exception {
        this.getProtocolAbandonService().abandonProtocol(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolAbandonBean());
        this.generateActionCorrespondence("117", protocolForm.getProtocolDocument().getProtocol());
        protocolForm.getProtocolHelper().prepareView();
        this.recordProtocolActionSuccess("Abandon");
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocolForm.getIacucProtocolDocument().getIacucProtocol(), "117", "Abandon");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, "iacucProtocolActions", (ProtocolNotificationRequestBeanBase)notificationBean, false));
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String modifySubmissionAction(IacucProtocolForm protocolForm, List<ProtocolReviewerBeanBase> reviewers) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolModifySubmissionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolModifySubmissionBean();
        actionBean.setReviewers(reviewers);
        this.getModifySubmissionService().modifySubmission(document, actionBean, reviewers);
        this.recordProtocolActionSuccess(ACTION_NAME_MODIFY_SUBMISSION);
        this.performNotificationRendering(protocolForm, reviewers);
        IacucProtocolNotificationRenderer assignRenderer = new IacucProtocolNotificationRenderer(protocol);
        IacucProtocolNotificationContext assignContext = new IacucProtocolNotificationContext(protocol, null, "309", "Modified", assignRenderer);
        this.getNotificationService().sendNotificationAndPersist(assignContext, new IacucProtocolNotification(), protocol);
        protocolForm.setReinitializeModifySubmissionFields(true);
        this.generateActionCorrespondence("309", protocolForm.getProtocolDocument().getProtocol());
        return "basic";
    }

    @Override
    public String tableProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        IacucProtocolTableBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolTableBean();
        IacucProtocolDocument pd = this.getProtocolTableService().tableProtocol(protocol, actionBean);
        IacucProtocol newIacucProtocol = pd.getProtocol();
        this.generateActionCorrespondence("203", newIacucProtocol);
        this.refreshAfterProtocolAction(protocolForm, pd.getDocumentNumber(), ACTION_NAME_TABLE_PROTOCOL, false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(newIacucProtocol, "203", "Tabled");
        ProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(newIacucProtocol, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false);
        protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
        this.synchronizeCorrespondenceAndNotification(protocol, newProtocolCorrespondence, notificationBean, protocolForm, newIacucProtocol);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String administrativelyWithdrawProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        boolean isVersion = this.isVersion(protocol);
        ProtocolDocumentBase pd = this.getProtocolWithdrawService().administrativelyWithdraw(protocol, protocolForm.getActionHelper().getProtocolAdminWithdrawBean());
        IacucProtocol newIacucProtocol = (IacucProtocol)pd.getProtocol();
        this.generateActionCorrespondence("300", newIacucProtocol);
        this.refreshAfterProtocolAction(protocolForm, pd.getDocumentNumber(), ACTION_NAME_ADMINISTRATIVELY_WITHDRAW, false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(newIacucProtocol, "300", "Administratively Withdrawn");
        ProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(newIacucProtocol, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false);
        protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
        this.synchronizeWithdrawProcess(isVersion, protocol, newProtocolCorrespondence, notificationBean, protocolForm, newIacucProtocol);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String withdrawProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getProtocol();
        boolean isVersion = this.isVersion(protocol);
        ProtocolDocumentBase pd = this.getProtocolWithdrawService().withdraw(protocol, protocolForm.getActionHelper().getProtocolWithdrawBean());
        IacucProtocol newIacucProtocol = (IacucProtocol)pd.getProtocol();
        this.generateActionCorrespondence("115", newIacucProtocol);
        this.refreshAfterProtocolAction(protocolForm, pd.getDocumentNumber(), "Withdraw", false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(newIacucProtocol, "115", "Withdrawn");
        ProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(newIacucProtocol, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false);
        protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
        this.synchronizeWithdrawProcess(isVersion, protocol, newProtocolCorrespondence, notificationBean, protocolForm, newIacucProtocol);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    private void synchronizeWithdrawProcess(boolean isVersion, IacucProtocol previousProtocol, ProtocolCorrespondence newProtocolCorrespondence, IacucProtocolNotificationRequestBean notificationBean, IacucProtocolForm protocolForm, IacucProtocol currentProtocol) {
        if (isVersion) {
            this.synchronizeCorrespondenceAndNotification(previousProtocol, newProtocolCorrespondence, notificationBean, protocolForm, currentProtocol);
        }
    }

    private void synchronizeCorrespondenceAndNotification(IacucProtocol previousProtocol, ProtocolCorrespondence newProtocolCorrespondence, IacucProtocolNotificationRequestBean notificationBean, IacucProtocolForm protocolForm, IacucProtocol currentProtocol) {
        ProtocolNotificationContextBase context = this.getProtocolNotificationContextHook(notificationBean, protocolForm);
        IacucProtocol notificationProtocol = null;
        if (newProtocolCorrespondence != null) {
            this.getProtocolActionCorrespondenceGenerationService().attachProtocolCorrespondence(previousProtocol, newProtocolCorrespondence.getCorrespondence(), newProtocolCorrespondence.getProtoCorrespTypeCode());
            notificationProtocol = previousProtocol;
        } else {
            notificationProtocol = currentProtocol;
        }
        this.getNotificationService().sendNotificationAndPersist(context, this.getProtocolNotificationInstanceHook(), notificationProtocol);
    }

    private boolean isVersion(IacucProtocol protocol) {
        boolean isVersion = "100".equals(protocol.getProtocolStatusCode()) || "101".equals(protocol.getProtocolStatusCode()) || "103".equals(protocol.getProtocolStatusCode());
        return isVersion;
    }

    @Override
    public String notifyProtocol(IacucProtocolForm protocolForm) throws Exception {
        String returnPath = "basic";
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.getIacucProtocolNotifyIacucBean().setAnswerHeaders(this.getAnswerHeaders(protocolForm, "114"));
        if (this.isMandatoryQuestionnaireComplete(actionHelper.getIacucProtocolNotifyIacucBean().getAnswerHeaders(), "actionHelper.protocolNotifyIacucBean.datavalidation")) {
            String returnTab = "iacucProtocolActions";
            if (protocolForm.getActionHelper().isUseAlternateNotifyAction()) {
                String newDocId = this.getProtocolAmendRenewService().createFYI(protocolForm.getProtocolDocument(), actionHelper.getIacucProtocolNotifyIacucBean());
                protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
                this.generateActionCorrespondence("114", protocolForm.getProtocolDocument().getProtocol());
                this.refreshAfterProtocolAction(protocolForm, newDocId, "Create FYI", true);
                returnTab = "iacucProtocol";
            } else {
                this.getProtocolNotifyService().submitIacucNotification((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), actionHelper.getIacucProtocolNotifyIacucBean());
                protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
                this.generateActionCorrespondence("114", protocolForm.getProtocolDocument().getProtocol());
                this.recordProtocolActionSuccess(ACTION_NAME_NOTIFY);
            }
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "114", ACTION_NAME_NOTIFY);
            actionHelper.setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, returnTab, (ProtocolNotificationRequestBeanBase)notificationBean, false));
            returnPath = this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, returnTab);
        }
        return returnPath;
    }

    @Override
    public String sendReviewDeterminationNotificationAction(IacucProtocolForm protocolForm) throws Exception {
        String returnPath = "basic";
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolModifySubmissionBean bean = actionHelper.getIacucProtocolModifySubmissionBean();
        Date dueDate = bean.getDueDate();
        IacucProtocolReviewDeterminationNotificationRenderer renderer = new IacucProtocolReviewDeterminationNotificationRenderer(protocol, dueDate);
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "908", "Review Type Determination", renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            returnPath = "iacucProtocolNotificationEditor";
        } else {
            this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        }
        this.generateActionCorrespondence("908", protocolForm.getProtocolDocument().getProtocol());
        this.recordProtocolActionSuccess(ACTION_NAME_REVIEW_TYPE_DETERMINATION);
        return returnPath;
    }

    @Override
    public String administrativelyMarkIncompleteProtocol(IacucProtocolForm protocolForm) throws Exception {
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        boolean isVersion = this.isVersion(protocol);
        ProtocolDocumentBase pd = this.getProtocolWithdrawService().administrativelyMarkIncomplete(protocol, protocolForm.getActionHelper().getProtocolAdminIncompleteBean());
        IacucProtocol newIacucProtocol = (IacucProtocol)pd.getProtocol();
        this.generateActionCorrespondence("216", newIacucProtocol);
        this.refreshAfterProtocolAction(protocolForm, pd.getDocumentNumber(), ACTION_NAME_ADMINISTRATIVELY_INCOMPLETE, false);
        IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(newIacucProtocol, "216", "Administratively Marked Incomplete");
        ProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(newIacucProtocol, "iacucProtocol", (ProtocolNotificationRequestBeanBase)notificationBean, false);
        protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
        this.synchronizeWithdrawProcess(isVersion, protocol, newProtocolCorrespondence, notificationBean, protocolForm, newIacucProtocol);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, "iacucProtocol");
    }

    @Override
    public String submitCommitteeDecision(IacucProtocolForm protocolForm) throws Exception {
        IacucCommitteeDecision actionBean = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
        this.getCommitteeDecisionService().processCommitteeDecision(protocolForm.getProtocolDocument().getProtocol(), actionBean);
        protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)motionTypeMap.get(actionBean.getMotionTypeCode())), "OPEN");
        this.recordProtocolActionSuccess("Record Committee Decision");
        this.generateActionCorrespondence("318", protocolForm.getProtocolDocument().getProtocol());
        return "basic";
    }

    @Override
    public String assignCommittee(IacucProtocolForm protocolForm) throws Exception {
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolAssignCmtBean actionBean = actionHelper.getProtocolAssignCmtBean();
        if (protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission() != null) {
            this.getAssignToCmtService().assignToCommittee(protocolForm.getProtocolDocument().getProtocol(), actionBean);
            this.recordProtocolActionSuccess(ACTION_NAME_ASSIGN_TO_COMMITTEE);
            protocolForm.setReinitializeModifySubmissionFields(true);
            this.generateActionCorrespondence("313", protocolForm.getProtocolDocument().getProtocol());
        }
        return "basic";
    }

    @Override
    public String performNotificationRendering(IacucProtocolForm protocolForm, List<ProtocolReviewerBeanBase> beans) {
        String returnPath = "basic";
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolAssignReviewerNotificationRenderer renderer = new IacucProtocolAssignReviewerNotificationRenderer(protocol, "added");
        List<ProtocolNotificationRequestBeanBase> addReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "create", true);
        List<ProtocolNotificationRequestBeanBase> removeReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "remove", false);
        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
            ProtocolNotificationRequestBeanBase notificationBean = addReviewerNotificationBeans.get(0);
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)notificationBean.getProtocol(), (IacucProtocolOnlineReview)notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                boolean sendNotification = this.checkToSendNotification(protocolForm, renderer, addReviewerNotificationBeans, "iacucProtocolActions");
                String string = returnPath = sendNotification ? "iacucProtocolNotificationEditor" : "iacucProtocolActions";
                if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
                    GlobalVariables.getUserSession().addObject("removeReviewer", removeReviewerNotificationBeans);
                }
            }
        } else if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
            renderer = new IacucProtocolAssignReviewerNotificationRenderer(protocol, "removed");
            ProtocolNotificationRequestBeanBase notificationBean = removeReviewerNotificationBeans.get(0);
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, (IacucProtocolOnlineReview)notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                boolean sendNotification = this.checkToSendNotification(protocolForm, renderer, removeReviewerNotificationBeans, "iacucProtocolActions");
                returnPath = sendNotification ? "iacucProtocolNotificationEditor" : "iacucProtocolActions";
            }
        }
        return returnPath;
    }

    private List<ProtocolNotificationRequestBeanBase> getNotificationRequestBeans(List<ProtocolReviewerBeanBase> beans, String actionFlag, boolean notNullFlag) {
        ArrayList<ProtocolNotificationRequestBeanBase> notificationRequestBeans = new ArrayList<ProtocolNotificationRequestBeanBase>();
        for (ProtocolReviewerBeanBase bean : beans) {
            if (!StringUtils.equals((CharSequence)actionFlag, (CharSequence)bean.getActionFlag()) || notNullFlag != !StringUtils.isEmpty((CharSequence)bean.getReviewerTypeCode())) continue;
            notificationRequestBeans.add(bean.getNotificationRequestBean());
        }
        return notificationRequestBeans;
    }

    protected boolean checkToSendNotification(ProtocolFormBase protocolForm, IacucProtocolNotificationRenderer renderer, List<ProtocolNotificationRequestBeanBase> notificationRequestBeans, String promptAfterNotification) {
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)notificationRequestBeans.get(0).getProtocol(), (IacucProtocolOnlineReview)notificationRequestBeans.get(0).getProtocolOnlineReview(), notificationRequestBeans.get(0).getActionType(), notificationRequestBeans.get(0).getDescription(), renderer);
        context.setPopulateRole(true);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            List<NotificationTypeRecipient> notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients();
            ArrayList<NotificationTypeRecipient> allRecipients = new ArrayList<NotificationTypeRecipient>();
            for (NotificationTypeRecipient recipient : notificationRecipients) {
                try {
                    NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                    context.populateRoleQualifiers(copiedRecipient);
                    allRecipients.add(copiedRecipient);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            for (int i = 1; notificationRequestBeans.size() > i; ++i) {
                context = new IacucProtocolNotificationContext((IacucProtocol)notificationRequestBeans.get(i).getProtocol(), (IacucProtocolOnlineReview)notificationRequestBeans.get(i).getProtocolOnlineReview(), notificationRequestBeans.get(i).getActionType(), notificationRequestBeans.get(i).getDescription(), renderer);
                context.setPopulateRole(true);
                protocolForm.getNotificationHelper().initializeDefaultValues(context);
                List<NotificationTypeRecipient> recipients = protocolForm.getNotificationHelper().getNotificationRecipients();
                for (NotificationTypeRecipient recipient : recipients) {
                    try {
                        NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                        context.populateRoleQualifiers(copiedRecipient);
                        allRecipients.add(copiedRecipient);
                    }
                    catch (Exception ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            protocolForm.getNotificationHelper().setNotificationRecipients(allRecipients);
            if (promptAfterNotification == null) {
                context.setForwardName("holdingPage");
            } else {
                context.setForwardName(promptAfterNotification);
            }
            return true;
        }
        return false;
    }

    private IacucProtocolRequestBean getProtocolRequestBean(ProtocolFormBase protocolForm, String taskName) {
        IacucProtocolRequestBean protocolRequestBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(protocolForm, taskName);
        if (protocolActionBean != null && protocolActionBean instanceof IacucProtocolRequestBean) {
            protocolRequestBean = (IacucProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    @Override
    public String withdrawRequestAction(IacucProtocolForm protocolForm) throws Exception {
        boolean valid;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolRequestAction requestAction = IacucProtocolRequestAction.valueOfTaskName("iacucWithdrawSubmission");
        IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(protocolForm, "iacucWithdrawSubmission");
        if (requestBean != null && (valid = this.applyRules((DocumentEvent)new IacucProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean)))) {
            List<ProtocolSubmissionBase> submissions = protocol.getProtocolSubmissions();
            ProtocolSubmissionBase submission = null;
            for (ProtocolSubmissionBase sub : submissions) {
                if (!requestSubmissionTypes.contains(sub.getSubmissionTypeCode())) continue;
                submission = sub;
            }
            if (submission != null) {
                submission.setSubmissionStatusCode("204");
                IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, (IacucProtocolSubmission)submission, "131");
                protocolAction.setComments(requestBean.getReason());
                protocolAction.setActionDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                protocolAction.setSubmissionIdFk(submission.getSubmissionId());
                protocolAction.setSubmissionNumber(submission.getSubmissionNumber());
                document.getProtocol().getProtocolActions().add(protocolAction);
                this.getProtocolActionService().updateProtocolStatus(protocolAction, document.getProtocol());
                this.getBusinessObjectService().save((PersistableBusinessObject)submission);
                this.recordProtocolActionSuccess(requestAction.getActionName());
                return this.sendRequestNotification(protocolForm, requestBean.getProtocolActionTypeCode(), requestBean.getReason(), "iacucProtocolActions");
            }
        }
        return "basic";
    }

    @Override
    protected ProtocolTaskBase getProtocolTaskInstanceHook(String taskName, ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, (IacucProtocol)protocol);
        return task;
    }

    @Override
    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String protocolActionTypeCode) {
        return new IacucProtocolActionsCorrespondence(protocolActionTypeCode);
    }

    @Override
    protected Class<? extends ProtocolActionTypeBase> getProtocolActionTypeBOClassHook() {
        return IacucProtocolActionType.class;
    }

    @Override
    protected String getProtocolCreatedActionTypeHook() {
        return "100";
    }

    public IacucProtocolApproveService getProtocolApproveService() {
        return this.protocolApproveService;
    }

    public void setProtocolApproveService(IacucProtocolApproveService protocolApproveService) {
        this.protocolApproveService = protocolApproveService;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return IacucProtocol.class;
    }

    @Override
    protected ProtocolTaskBase getProtocolGenericActionTaskInstanceHook(String genericActionName, ProtocolBase protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucGenericProtocolAction", (IacucProtocol)protocol, genericActionName);
        return task;
    }

    @Override
    protected String getProtocolRejectedInRoutingActionTypeHook() {
        return "401";
    }

    @Override
    protected String getProtocolRecalledInRoutingActionTypeHook() {
        return null;
    }

    public IacucProtocolSubmitActionService getProtocolSubmitActionService() {
        return this.protocolSubmitActionService;
    }

    public void setProtocolSubmitActionService(IacucProtocolSubmitActionService protocolSubmitActionService) {
        this.protocolSubmitActionService = protocolSubmitActionService;
    }

    public IacucProtocolAmendRenewService getProtocolAmendRenewService() {
        return this.protocolAmendRenewService;
    }

    public void setProtocolAmendRenewService(IacucProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }

    public IacucProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public void setProtocolActionService(IacucProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    protected String getNotificationEditorHook() {
        return "iacucProtocolNotificationEditor";
    }

    @Override
    protected ProtocolNotification getProtocolNotificationInstanceHook() {
        return new IacucProtocolNotification();
    }

    @Override
    protected ProtocolNotificationContextBase getProtocolNotificationContextHook(ProtocolNotificationRequestBeanBase notificationRequestBean, ProtocolFormBase protocolForm) {
        IacucProtocolNotificationRenderer renderer = null;
        IacucProtocol protocol = (IacucProtocol)notificationRequestBean.getProtocol();
        if (StringUtils.equals((CharSequence)"114", (CharSequence)notificationRequestBean.getActionType())) {
            renderer = new NotifyIacucNotificationRenderer(protocol, ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolNotifyIacucBean().getComment());
        } else if (StringUtils.equals((CharSequence)"906", (CharSequence)notificationRequestBean.getActionType()) || StringUtils.equals((CharSequence)"115", (CharSequence)notificationRequestBean.getActionType())) {
            renderer = new IacucProtocolWithReasonNotificationRenderer(protocol, protocolForm.getActionHelper().getProtocolDeleteBean());
        } else if (StringUtils.equals((CharSequence)"107", (CharSequence)notificationRequestBean.getActionType()) || StringUtils.equals((CharSequence)"108", (CharSequence)notificationRequestBean.getActionType())) {
            IacucRequestActionNotificationBean requestNotificationRequestBean = (IacucRequestActionNotificationBean)notificationRequestBean;
            renderer = new IacucProtocolRequestActionNotificationRenderer(protocol, requestNotificationRequestBean.getReason());
        } else if (StringUtils.equals((CharSequence)"311", (CharSequence)notificationRequestBean.getActionType())) {
            IacucProtocolRequestBean iacucProtocolSuspendRequestBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolSuspendRequestBean();
            renderer = new NotifyIacucNotificationRenderer(protocol, iacucProtocolSuspendRequestBean.getReason());
        } else {
            renderer = new IacucProtocolNotificationRenderer(protocol);
        }
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), renderer);
        return context;
    }

    @Override
    protected Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook() {
        return IacucProtocolCorrespondence.class;
    }

    public IacucProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return this.protocolAssignToAgendaService;
    }

    public void setProtocolAssignToAgendaService(IacucProtocolAssignToAgendaService protocolAssignToAgendaService) {
        this.protocolAssignToAgendaService = protocolAssignToAgendaService;
    }

    public IacucProtocolReviewNotRequiredService getProtocolReviewNotRequiredService() {
        return this.protocolReviewNotRequiredService;
    }

    public void setProtocolReviewNotRequiredService(IacucProtocolReviewNotRequiredService protocolReviewNotRequiredService) {
        this.protocolReviewNotRequiredService = protocolReviewNotRequiredService;
    }

    @Override
    protected ModuleQuestionnaireBean getProtocolModuleQuestionnaireBeanInstanceHook(ProtocolFormBase protocolForm, String actionTypeCode) {
        return new IacucProtocolModuleQuestionnaireBean("9", protocolForm.getProtocolDocument().getProtocol().getProtocolNumber() + "T", "2", actionTypeCode, false);
    }

    public IacucProtocolRequestService getProtocolRequestService() {
        return this.protocolRequestService;
    }

    public void setProtocolRequestService(IacucProtocolRequestService protocolRequestService) {
        this.protocolRequestService = protocolRequestService;
    }

    @Override
    protected ProtocolNotificationRequestBeanBase getRequestActionNotificationBeanInstanceHook(ProtocolBase protocol, String protocolActionTypeCode, String description, String reason) {
        return new IacucRequestActionNotificationBean((IacucProtocol)protocol, protocolActionTypeCode, description, reason);
    }

    @Override
    protected ProtocolQuestionnaireAuditRuleBase getProtocolQuestionnaireAuditRuleInstanceHook() {
        return new IacucProtocolQuestionnaireAuditRule();
    }

    public IacucProtocolGenericActionService getProtocolGenericActionService() {
        return this.protocolGenericActionService;
    }

    public void setProtocolGenericActionService(IacucProtocolGenericActionService protocolGenericActionService) {
        this.protocolGenericActionService = protocolGenericActionService;
    }

    public IacucProtocolAbandonService getProtocolAbandonService() {
        return this.protocolAbandonService;
    }

    public void setProtocolAbandonService(IacucProtocolAbandonService protocolAbandonService) {
        this.protocolAbandonService = protocolAbandonService;
    }

    public IacucProtocolModifySubmissionService getModifySubmissionService() {
        return this.modifySubmissionService;
    }

    public void setModifySubmissionService(IacucProtocolModifySubmissionService modifySubmissionService) {
        this.modifySubmissionService = modifySubmissionService;
    }

    public IacucProtocolTableService getProtocolTableService() {
        return this.protocolTableService;
    }

    public void setProtocolTableService(IacucProtocolTableService protocolTableService) {
        this.protocolTableService = protocolTableService;
    }

    public IacucProtocolWithdrawService getProtocolWithdrawService() {
        return this.protocolWithdrawService;
    }

    public void setProtocolWithdrawService(IacucProtocolWithdrawService protocolWithdrawService) {
        this.protocolWithdrawService = protocolWithdrawService;
    }

    public IacucProtocolNotifyIacucService getProtocolNotifyService() {
        return this.protocolNotifyService;
    }

    public void setProtocolNotifyService(IacucProtocolNotifyIacucService protocolNotifyService) {
        this.protocolNotifyService = protocolNotifyService;
    }

    public IacucCommitteeDecisionService getCommitteeDecisionService() {
        return this.committeeDecisionService;
    }

    public void setCommitteeDecisionService(IacucCommitteeDecisionService committeeDecisionService) {
        this.committeeDecisionService = committeeDecisionService;
    }

    public IacucProtocolAssignCmtService getAssignToCmtService() {
        return this.assignToCmtService;
    }

    public void setAssignToCmtService(IacucProtocolAssignCmtService assignToCmtService) {
        this.assignToCmtService = assignToCmtService;
    }
}

