/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.decision;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class IacucCommitteeMemberValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = 1547047028487421985L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmissionBase submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        ProtocolBase protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            String committeeId = submission.getCommitteeId();
            Object committee = this.getCommitteeService().getCommitteeById(committeeId);
            if (committee != null) {
                List<CommitteeMembershipBase> members = ((CommitteeBase)committee).getCommitteeMemberships();
                for (CommitteeMembershipBase member : members) {
                    if (!member.isActive() || !this.isReviewerAttendingMeeting(member)) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(member.getCommitteeMembershipId().toString(), member.getPersonName()));
                }
            }
        }
        return keyValues;
    }

    private ProtocolSubmissionBase getCurrentSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"103") && !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"102")) continue;
            return submission;
        }
        return null;
    }

    private ProtocolBase getProtocol() {
        Object formOrView = this.getFormOrView();
        if (formOrView != null && formOrView instanceof ProtocolFormBase) {
            return ((ProtocolFormBase)formOrView).getProtocolDocument().getProtocol();
        }
        return null;
    }

    private boolean isReviewerAttendingMeeting(CommitteeMembershipBase member) {
        CommitteeScheduleBase schedule;
        ProtocolBase prot = this.getProtocol();
        boolean retVal = false;
        if (prot != null && (schedule = prot.getProtocolSubmission().getCommitteeSchedule()) != null) {
            List<CommitteeScheduleAttendanceBase> attendees = schedule.getCommitteeScheduleAttendances();
            for (CommitteeScheduleAttendanceBase attendee : attendees) {
                if (!attendee.isCommitteeMember(member)) continue;
                return true;
            }
        }
        return retVal;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

