/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.print;

import edu.mit.coeus.xml.iacuc.CommitteeMasterDataType;
import edu.mit.coeus.xml.iacuc.NextScheduleDateType;
import edu.mit.coeus.xml.iacuc.RenewalReminderDocument;
import edu.mit.coeus.xml.iacuc.RenewalReminderType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.print.IacucProtocolXmlStream;
import org.kuali.kra.iacuc.committee.bo.IacucCommittee;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeXmlStream;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.print.ProtocolXmlStreamBase;
import org.kuali.kra.protocol.actions.print.RenewalReminderStreamBase;

public class IacucRenewalReminderStream
extends RenewalReminderStreamBase<RenewalReminderDocument> {
    private ProtocolXmlStreamBase protocolXmlStream;
    private IacucCommitteeXmlStream committeeXmlStream;

    @Override
    public Class<RenewalReminderDocument> type() {
        return RenewalReminderDocument.class;
    }

    @Override
    public Map<String, RenewalReminderDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
        RenewalReminderDocument renewalReminderDocument = RenewalReminderDocument.Factory.newInstance();
        RenewalReminderType renewalReminder = RenewalReminderType.Factory.newInstance();
        renewalReminder.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        String committeeId = (String)reportParameters.get("committeeId");
        CommitteeBase committee = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", committeeId);
        Collection committees = this.getBusinessObjectService().findMatching(IacucCommittee.class, fieldValues);
        if (committees.size() > 0) {
            committee = (CommitteeBase)Collections.max(committees);
        }
        CommitteeMasterDataType committeeMasterData = CommitteeMasterDataType.Factory.newInstance();
        this.committeeXmlStream.setCommitteeMasterData(committee, committeeMasterData);
        renewalReminder.setCommitteeMasterData(committeeMasterData);
        List committeSchedules = committee.getCommitteeSchedules();
        int rowNumber = 0;
        for (CommitteeScheduleBase committeeSchedule : committeSchedules) {
            if (rowNumber < 5) break;
            if (!committeeSchedule.getScheduledDate().after(this.getDateTimeService().getCurrentDate()) && !committeeSchedule.getScheduledDate().equals(this.getDateTimeService().getCurrentDate())) continue;
            NextScheduleDateType nextScheduleDateType = renewalReminder.addNewNextScheduleDate();
            nextScheduleDateType.setScheduleDate(this.getDateTimeService().getCalendar((Date)committeeSchedule.getScheduledDate()));
            nextScheduleDateType.setScheduleNumber(++rowNumber);
        }
        if (reportParameters.get("protoCorrespTypeCode") != null && ("23".equals(reportParameters.get("protoCorrespTypeCode")) || "24".equals(reportParameters.get("protoCorrespTypeCode")))) {
            this.setActionDate(protocol);
        }
        if (reportParameters.get("submissionNumber") == null) {
            renewalReminder.setProtocol(((IacucProtocolXmlStream)this.protocolXmlStream).getProtocol(protocol));
        } else {
            renewalReminder.setProtocol(((IacucProtocolXmlStream)this.protocolXmlStream).getProtocol(protocol, (Integer)reportParameters.get("submissionNumber")));
        }
        HashMap<String, RenewalReminderDocument> xmlObjectMap = new HashMap<String, RenewalReminderDocument>();
        renewalReminderDocument.setRenewalReminder(renewalReminder);
        xmlObjectMap.put("Renewal reminder", renewalReminderDocument);
        return xmlObjectMap;
    }

    private void setActionDate(ProtocolBase protocol) {
    }

    public void setProtocolXmlStream(ProtocolXmlStreamBase protocolXmlStream) {
        this.protocolXmlStream = protocolXmlStream;
    }

    public void setCommitteeXmlStream(IacucCommitteeXmlStream committeeXmlStream) {
        this.committeeXmlStream = committeeXmlStream;
    }
}

