/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.permissions.impl.web.bean.AssignedRole;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateAuthorizationService;
import org.kuali.kra.irb.actions.print.ProtocolPrintPermissionUtils;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolNotepad;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.reference.ProtocolReference;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReview;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryXmlStreamBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.w3.x2001.protocolSummarySchema.ProtoAmendRenewalType;
import org.w3.x2001.protocolSummarySchema.ProtocolActionsType;
import org.w3.x2001.protocolSummarySchema.ProtocolCorrespondentType;
import org.w3.x2001.protocolSummarySchema.ProtocolDetailsType;
import org.w3.x2001.protocolSummarySchema.ProtocolDocumentType;
import org.w3.x2001.protocolSummarySchema.ProtocolDocumentsType;
import org.w3.x2001.protocolSummarySchema.ProtocolFundingSourceType;
import org.w3.x2001.protocolSummarySchema.ProtocolInvestigatorType;
import org.w3.x2001.protocolSummarySchema.ProtocolKeyPersonsType;
import org.w3.x2001.protocolSummarySchema.ProtocolLocationType;
import org.w3.x2001.protocolSummarySchema.ProtocolModulesType;
import org.w3.x2001.protocolSummarySchema.ProtocolNotesType;
import org.w3.x2001.protocolSummarySchema.ProtocolOtherDataType;
import org.w3.x2001.protocolSummarySchema.ProtocolOtherDocumentsType;
import org.w3.x2001.protocolSummarySchema.ProtocolReferencesType;
import org.w3.x2001.protocolSummarySchema.ProtocolResearchAreasType;
import org.w3.x2001.protocolSummarySchema.ProtocolRiskLevelsType;
import org.w3.x2001.protocolSummarySchema.ProtocolRolesType;
import org.w3.x2001.protocolSummarySchema.ProtocolSpecialReviewType;
import org.w3.x2001.protocolSummarySchema.ProtocolSubjectsType;
import org.w3.x2001.protocolSummarySchema.ProtocolSummaryDocument;
import org.w3.x2001.protocolSummarySchema.ProtocolUnitsType;
import org.w3.x2001.protocolSummarySchema.ProtocolUserRolesType;
import org.w3.x2001.protocolSummarySchema.SchoolInfoType;

public class ProtocolSummaryXmlStream
extends ProtocolSummaryXmlStreamBase<ProtocolSummaryDocument> {
    private static final String OTHER = "9";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private SponsorService sponsorService;
    private UnitService unitService;
    private InstitutionalProposalService institutionalProposalService;
    private AwardService awardService;
    private ParameterService parameterService;
    private ProtocolActionService protocolActionService;
    private ProtocolNotificationTemplateAuthorizationService protocolNotificationTemplateAuthorizationService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public Class<ProtocolSummaryDocument> type() {
        return ProtocolSummaryDocument.class;
    }

    @Override
    public Map<String, ProtocolSummaryDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolSummaryDocument protocolSummaryDocument = ProtocolSummaryDocument.Factory.newInstance();
        protocolSummaryDocument.setProtocolSummary(this.getProtocolSummary(protocol, reportParameters));
        HashMap<String, ProtocolSummaryDocument> map = new HashMap<String, ProtocolSummaryDocument>();
        map.put("PrtocolSummary", protocolSummaryDocument);
        return map;
    }

    private String getOptionString(boolean printOption) {
        return printOption ? "1" : "0";
    }

    public ProtocolSummaryDocument.ProtocolSummary getProtocolSummary(KcPersistableBusinessObjectBase printableBusinessObject, Map<?, Object> htData) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolSummaryDocument.ProtocolSummary protocolSummary = ProtocolSummaryDocument.ProtocolSummary.Factory.newInstance();
        ProtocolSummaryDocument.ProtocolSummary.PrintRequirement printRequirementType = protocolSummary.addNewPrintRequirement();
        protocolSummary.setPrintRequirement(printRequirementType);
        if (htData != null) {
            ProtocolSummaryPrintOptions summaryOptions = (ProtocolSummaryPrintOptions)htData.get(ProtocolSummaryPrintOptions.class);
            printRequirementType.setActionsRequired(this.getOptionString(summaryOptions.isActions()));
            printRequirementType.setAmendRenewModulesRequired(this.getOptionString(summaryOptions.isAmmendmentRenewalSummary()));
            printRequirementType.setAmendRenewSRequired(this.getOptionString(summaryOptions.isAmendmentRenewalHistory()));
            printRequirementType.setDocumentsRequired(this.getOptionString(summaryOptions.isDocuments()));
            printRequirementType.setResearchAreasRequired(this.getOptionString(summaryOptions.isAreaOfResearch()));
            printRequirementType.setCorrespondentsRequired(this.getOptionString(summaryOptions.isCorrespondents()));
            printRequirementType.setFundingSourcesRequired(this.getOptionString(summaryOptions.isFundingSource()));
            printRequirementType.setInvestigatorsRequired(this.getOptionString(summaryOptions.isInvestigator()));
            printRequirementType.setNotesRequired(this.getOptionString(summaryOptions.isNotes()));
            printRequirementType.setOrganizationRequired(this.getOptionString(summaryOptions.isOrganizaition()));
            printRequirementType.setOtherDataRequired(this.getOptionString(summaryOptions.isOtherData()));
            printRequirementType.setProtocolDetailsRequired(this.getOptionString(summaryOptions.isProtocolDetails()));
            printRequirementType.setReferencesRequired(this.getOptionString(summaryOptions.isReferences()));
            printRequirementType.setRiskLevelsRequired(this.getOptionString(summaryOptions.isRiskLevel()));
            printRequirementType.setUserRolesRequired(this.getOptionString(summaryOptions.isRoles()));
            printRequirementType.setSpecialReviewRequired(this.getOptionString(summaryOptions.isSpecialReview()));
            printRequirementType.setKeyPersonsRequired(this.getOptionString(summaryOptions.isStudyPersonnels()));
            printRequirementType.setSubjectsRequired(this.getOptionString(summaryOptions.isSubjects()));
        }
        printRequirementType.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        this.setProtocolDetails(protocolSummary, protocol);
        this.setProtocolPersons(protocolSummary, protocol);
        this.setProtocolLocations(protocolSummary, protocol);
        this.setProtocolResearchAreas(protocolSummary, protocol);
        this.setProtocolFundingResources(protocolSummary, protocol);
        this.setProtocolActions(protocolSummary, protocol);
        this.setProtocolVulnerableSubjects(protocolSummary, protocol);
        this.setProtocolSpecialReviewes(protocolSummary, protocol);
        this.setProtocolRiskLevels(protocolSummary, protocol);
        this.setProtocolNotes(protocolSummary, protocol);
        this.setProtocolAmendmentRenewals(protocolSummary, protocol);
        this.setProtocolOtherData(protocolSummary, protocol);
        this.setProtocolReferences(protocolSummary, protocol);
        this.setProtocolUserRoles(protocolSummary, protocol);
        this.setProtocolDocuments(protocolSummary, protocol);
        this.setSchoolInfo(protocolSummary, protocol);
        return protocolSummary;
    }

    private void setSchoolInfo(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protoInfoBean) {
        String schoolName = this.getProposalParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getProposalParameterValue(SCHOOL_ACRONYM);
        SchoolInfoType schoolInfoType = protocolSummary.addNewSchoolInfo();
        schoolInfoType.setSchoolName(schoolName);
        schoolInfoType.setAcronym(schoolAcronym);
        protocolSummary.setSchoolInfo(schoolInfoType);
    }

    private String getProposalParameterValue(String param) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    private void setProtocolDocuments(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolDocumentsType protocolDocumentsType = protocolSummary.addNewProtocolDocuments();
        protocolDocumentsType.setProtocolNumber(protocol.getProtocolNumber());
        protocolDocumentsType.setSequenceNumber(protocol.getSequenceNumber());
        List<ProtocolAttachmentProtocolBase> protocolAttachments = protocol.getActiveAttachmentProtocols();
        for (ProtocolAttachmentProtocol protocolAttachmentProtocol : protocolAttachments) {
            if (protocolAttachmentProtocol.getTypeCode().equals(OTHER)) {
                ProtocolOtherDocumentsType protocolOtherDocumentsType = protocolDocumentsType.addNewProtocolOtherDocuments();
                protocolOtherDocumentsType.setDescription(protocolAttachmentProtocol.getDescription());
                protocolOtherDocumentsType.setDocumentId(protocolAttachmentProtocol.getDocumentId());
                protocolOtherDocumentsType.setDocumentTypeCode(Integer.parseInt(protocolAttachmentProtocol.getTypeCode()));
                protocolOtherDocumentsType.setDocumentTypeDesc(protocolAttachmentProtocol.getType().getDescription());
                protocolOtherDocumentsType.setFileName(protocolAttachmentProtocol.getFile().getName());
                if (protocolAttachmentProtocol.getUpdateTimestamp() != null) {
                    protocolOtherDocumentsType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolAttachmentProtocol.getUpdateTimestamp()));
                }
                protocolOtherDocumentsType.setUpdateUser(protocolAttachmentProtocol.getUpdateUser());
                continue;
            }
            ProtocolDocumentType protocolDocumentType = protocolDocumentsType.addNewProtocolDocument();
            protocolDocumentType.setDescription(protocolAttachmentProtocol.getDescription());
            protocolDocumentType.setDocumentTypeCode(Integer.parseInt(protocolAttachmentProtocol.getTypeCode()));
            protocolDocumentType.setDocumentTypeGroup(protocolAttachmentProtocol.getType().getDescription());
            if (protocolAttachmentProtocol.getUpdateTimestamp() != null) {
                protocolDocumentType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolAttachmentProtocol.getUpdateTimestamp()));
            }
            protocolDocumentType.setUpdateUser(protocolAttachmentProtocol.getUpdateUser());
        }
    }

    private void setProtocolUserRoles(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolPrintPermissionUtils protocolPrintPermissionUtils = new ProtocolPrintPermissionUtils("KC-PROTOCOL");
        protocolPrintPermissionUtils.setProtocol(protocol);
        List<AssignedRole> assignedRoles = protocolPrintPermissionUtils.getAssignedRoles();
        for (AssignedRole userRolesInfoBean : assignedRoles) {
            ProtocolRolesType protocolRolesType = protocolSummary.addNewProtocolUserRoles();
            protocolRolesType.setRoleName(userRolesInfoBean.getRole().getName());
            List<String> vecUsers = userRolesInfoBean.getUserNames();
            for (String userName : vecUsers) {
                ProtocolUserRolesType protocolUserRolesType = protocolRolesType.addNewUserRoles();
                protocolUserRolesType.setUserName(userName);
                protocolUserRolesType.setPersonName(userName);
            }
        }
    }

    private void setProtocolReferences(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolReferenceBase> protocolReferences = protocol.getProtocolReferences();
        for (ProtocolReference protocolReference : protocolReferences) {
            protocolReference.refreshNonUpdateableReferences();
            ProtocolReferencesType protocolReferencesType = protocolSummary.addNewProtocolReferences();
            protocolReferencesType.setApplicationDate(this.convertDateToCalendar(protocolReference.getApplicationDate()));
            protocolReferencesType.setApprovalDate(this.convertDateToCalendar(protocolReference.getApprovalDate()));
            protocolReferencesType.setComments(protocolReference.getComments());
            protocolReferencesType.setProtocolNumber(protocolReference.getProtocolNumber());
            protocolReferencesType.setProtocolReferenceNumber(protocolReference.getProtocolReferenceNumber());
            if (protocolReference.getProtocolReferenceType() != null) {
                protocolReferencesType.setProtocolReferenceTypeCode(protocolReference.getProtocolReferenceTypeCode());
                protocolReferencesType.setProtocolReferenceTypeDesc(protocolReference.getProtocolReferenceType().getDescription());
            }
            protocolReferencesType.setReferenceKey(protocolReference.getReferenceKey());
            protocolReferencesType.setSequenceNumber(protocolReference.getSequenceNumber());
        }
    }

    public void prepareView(ProtocolDocument protocolDocument) {
        Map<String, CustomAttributeDocument> customAttributeDocuments = protocolDocument.getCustomAttributeDocuments();
        String documentNumber = protocolDocument.getDocumentNumber();
        for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocumentEntry.getValue();
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("documentNumber", documentNumber);
            primaryKeys.put("id", customAttributeDocument.getId());
            CustomAttributeDocValue customAttributeDocValue = (CustomAttributeDocValue)this.getBusinessObjectService().findByPrimaryKey(CustomAttributeDocValue.class, primaryKeys);
            if (customAttributeDocValue == null) continue;
            customAttributeDocument.getCustomAttribute().setValue(customAttributeDocValue.getValue());
        }
    }

    private void setProtocolOtherData(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolDocument protocolDocument = (ProtocolDocument)protocol.getProtocolDocument();
        this.prepareView(protocolDocument);
        Map<String, CustomAttributeDocument> customAttributes = protocolDocument.getCustomAttributeDocuments();
        for (String attributeKey : customAttributes.keySet()) {
            CustomAttributeDocument attributeDocument = customAttributes.get(attributeKey);
            String value = attributeDocument.getCustomAttribute().getValue();
            ProtocolOtherDataType protocolOtherDataType = protocolSummary.addNewProtocolOthersData();
            protocolOtherDataType.setColumnName(attributeKey);
            protocolOtherDataType.setColumnValue(value);
            protocolOtherDataType.setProtocolNumber(protocol.getProtocolNumber());
            protocolOtherDataType.setSequenceNumber(protocol.getSequenceNumber());
            protocolOtherDataType.setUpdateUser(customAttributes.get(attributeKey).getUpdateUser());
        }
    }

    private void setProtocolAmendmentRenewals(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        String versionNo = "";
        String moduleType = "";
        String amendType = ProtocolSpecialVersion.AMENDMENT.getDescription();
        String renewalType = ProtocolSpecialVersion.RENEWAL.getDescription();
        List<ProtocolAmendRenewalBase> protocolAmendmentRenewals = protocol.getProtocolAmendRenewals();
        for (ProtocolAmendRenewal protocolAmendRenewal : protocolAmendmentRenewals) {
            ProtoAmendRenewalType protoAmendRenewalType = protocolSummary.addNewProtocolAmenRenewal();
            protoAmendRenewalType.setDateCreated(this.convertDateToCalendar(protocolAmendRenewal.getDateCreated()));
            protoAmendRenewalType.setProtoAmendRenNumber(protocolAmendRenewal.getProtoAmendRenNumber());
            protoAmendRenewalType.setProtocolNumber(protocolAmendRenewal.getProtocolNumber());
            protoAmendRenewalType.setSequenceNumber(protocolAmendRenewal.getSequenceNumber());
            protoAmendRenewalType.setSummary(protocolAmendRenewal.getSummary());
            protoAmendRenewalType.setUpdateUser(protocolAmendRenewal.getUpdateUser());
            String protocolNo = protocolAmendRenewal.getProtoAmendRenNumber();
            if (protocolNo != null && protocolNo.length() >= 14) {
                versionNo = protocolNo.substring(11);
                if (protocolNo.contains(ProtocolSpecialVersion.AMENDMENT.getCode())) {
                    moduleType = amendType;
                } else if (protocolNo.contains(ProtocolSpecialVersion.RENEWAL.getCode())) {
                    moduleType = renewalType;
                }
            }
            if (moduleType != null && moduleType.length() > 0) {
                protoAmendRenewalType.setType(moduleType);
            }
            if (versionNo != null && versionNo.length() > 0) {
                protoAmendRenewalType.setVersion(versionNo);
            }
            if (protocolAmendRenewal.getProtocol() != null && protocolAmendRenewal.getProtocol().getProtocolStatus() != null) {
                protoAmendRenewalType.setProtocolStatusDesc(protocolAmendRenewal.getProtocol().getProtocolStatus().getDescription());
                protoAmendRenewalType.setProtocolStatusCode(Integer.parseInt(protocolAmendRenewal.getProtocol().getProtocolStatusCode()));
            }
            List<ProtocolAmendRenewModuleBase> vecModuleData = protocolAmendRenewal.getModules();
            for (ProtocolAmendRenewModule protocolAmendRenewModule : vecModuleData) {
                ProtocolModulesType protocolModulesType = protoAmendRenewalType.addNewProtocolModules();
                if (protocolAmendRenewModule.getProtocolModule() != null) {
                    protocolModulesType.setProtocolModuleCode(protocolAmendRenewModule.getProtocolModule().getProtocolModuleCode());
                    protocolModulesType.setDescription(protocolAmendRenewModule.getProtocolModule().getDescription());
                }
                protocolModulesType.setUpdateUser(protocolAmendRenewModule.getUpdateUser());
            }
        }
    }

    private void setProtocolNotes(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolNotepadBase> protocolNotes = protocol.getNotepads();
        boolean isProtocolPerson = this.getProtocolActionService().isProtocolPersonnel(protocol);
        boolean hasPermission = this.getProtocolNotificationTemplateAuthorizationService().hasPermission("View Restricted Notes");
        for (ProtocolNotepad protocolNotepad : protocolNotes) {
            boolean restrictedView = protocolNotepad.getRestrictedView();
            if ((isProtocolPerson || !hasPermission) && restrictedView) continue;
            ProtocolNotesType protocolNotesType = protocolSummary.addNewProtocolNotes();
            protocolNotesType.setComments(protocolNotepad.getComments());
            protocolNotesType.setEntryNumber(protocolNotepad.getEntryNumber());
            protocolNotesType.setProtocolNumber(protocolNotepad.getProtocolNumber());
            protocolNotesType.setSequenceNumber(protocolNotepad.getSequenceNumber());
            protocolNotesType.setUpdateUser(protocolNotepad.getUpdateUser());
            if (protocolNotepad.getUpdateTimestamp() == null) continue;
            protocolNotesType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolNotepad.getUpdateTimestamp()));
        }
    }

    private Calendar convertDateToCalendar(Date date) {
        return date == null ? null : this.getDateTimeService().getCalendar((java.util.Date)date);
    }

    private void setProtocolRiskLevels(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolRiskLevel> protocolRiskLevels = protocol.getProtocolRiskLevels();
        for (ProtocolRiskLevel protocolRiskLevelBean : protocolRiskLevels) {
            protocolRiskLevelBean.refreshNonUpdateableReferences();
            ProtocolRiskLevelsType protocolRiskLevelsType = protocolSummary.addNewProtocolRiskLevels();
            protocolRiskLevelsType.setComments(protocolRiskLevelBean.getComments());
            protocolRiskLevelsType.setDateAssigned(this.convertDateToCalendar(protocolRiskLevelBean.getDateAssigned()));
            protocolRiskLevelsType.setDateUpdated(this.convertDateToCalendar(protocolRiskLevelBean.getDateInactivated()));
            protocolRiskLevelsType.setProtocolNumber(protocolRiskLevelBean.getProtocolNumber());
            if (protocolRiskLevelBean.getRiskLevelCode() != null) {
                protocolRiskLevelsType.setRiskLevelCode(Integer.parseInt(protocolRiskLevelBean.getRiskLevelCode()));
                protocolRiskLevelsType.setRiskLevelDesc(protocolRiskLevelBean.getRiskLevel().getDescription());
            }
            protocolRiskLevelsType.setSequenceNumber(protocolRiskLevelBean.getSequenceNumber());
            protocolRiskLevelsType.setStatus(protocolRiskLevelBean.getStatus());
            protocolRiskLevelsType.setUpdateUser(protocolRiskLevelBean.getUpdateUser());
        }
    }

    private void setProtocolSpecialReviewes(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolSpecialReviewBase> protocolSpecialReviews = protocol.getSpecialReviews();
        for (ProtocolSpecialReview protocolSpecialReview : protocolSpecialReviews) {
            protocolSpecialReview.refreshNonUpdateableReferences();
            ProtocolSpecialReviewType protocolSpecialReviewType = protocolSummary.addNewProtocolSpecialReview();
            if (protocolSpecialReview.getApplicationDate() != null) {
                protocolSpecialReviewType.setApplicationDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSpecialReview.getApplicationDate()));
            }
            if (protocolSpecialReview.getApprovalDate() != null) {
                protocolSpecialReviewType.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSpecialReview.getApprovalDate()));
            }
            if (protocolSpecialReview.getApprovalTypeCode() != null) {
                protocolSpecialReviewType.setApprovalTypeCode(Integer.parseInt(protocolSpecialReview.getApprovalTypeCode()));
                protocolSpecialReviewType.setApprovalTypeDesc(protocolSpecialReview.getApprovalType().getDescription());
            }
            protocolSpecialReviewType.setComments(protocolSpecialReview.getComments());
            protocolSpecialReviewType.setProtocolNumber(protocolSpecialReview.getProtocolNumber());
            protocolSpecialReviewType.setSequenceNumber(protocolSpecialReview.getSequenceNumber());
            protocolSpecialReviewType.setSpRevProtocolNumber(protocolSpecialReview.getProtocolNumber());
            if (protocolSpecialReview.getSpecialReviewTypeCode() != null) {
                protocolSpecialReviewType.setSpecialReviewCode(Integer.parseInt(protocolSpecialReview.getSpecialReviewTypeCode()));
                protocolSpecialReviewType.setSpecialReviewDesc(protocolSpecialReview.getSpecialReviewType().getDescription());
            }
            protocolSpecialReviewType.setSpecialReviewNumber(protocolSpecialReview.getSpecialReviewNumber());
            protocolSpecialReviewType.setUpdateUser(protocolSpecialReview.getUpdateUser());
        }
    }

    private void setProtocolVulnerableSubjects(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolParticipant> protocolParticipants = protocol.getProtocolParticipants();
        for (ProtocolParticipant vulnerableSubListsBean : protocolParticipants) {
            ProtocolSubjectsType protocolSubjectsType = protocolSummary.addNewProtocolSubjects();
            protocolSubjectsType.setProtocolNumber(vulnerableSubListsBean.getProtocolNumber());
            protocolSubjectsType.setSequenceNumber(vulnerableSubListsBean.getSequenceNumber());
            if (vulnerableSubListsBean.getParticipantCount() != null) {
                protocolSubjectsType.setSubjectCount(vulnerableSubListsBean.getParticipantCount());
            }
            if (vulnerableSubListsBean.getParticipantType() != null) {
                protocolSubjectsType.setVulnerableSubjectTypeCode(Integer.parseInt(vulnerableSubListsBean.getParticipantTypeCode()));
                protocolSubjectsType.setVulnerableSubjectTypeDesc(vulnerableSubListsBean.getParticipantType().getDescription());
            }
            protocolSubjectsType.setUpdateUser(vulnerableSubListsBean.getUpdateUser());
        }
    }

    private void setProtocolActions(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolActionBase> protocolAction = protocol.getProtocolActions();
        for (ProtocolAction protocolAction2 : protocolAction) {
            ProtocolActionsType protocolActionsType = protocolSummary.addNewProtocolActions();
            protocolActionsType.setActionId(protocolAction2.getActionId());
            if (protocolAction2.getActionDate() != null) {
                protocolActionsType.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolAction2.getActionDate()));
            }
            protocolActionsType.setComments(protocolAction2.getComments());
            if (protocolAction2.getProtocolActionTypeCode() != null) {
                protocolActionsType.setProtocolActionTypeCode(Integer.parseInt(protocolAction2.getProtocolActionTypeCode()));
                protocolActionsType.setProtocolActionTypeDesc(protocolAction2.getProtocolActionType().getDescription());
            }
            protocolActionsType.setProtocolNumber(protocolAction2.getProtocolNumber());
            protocolActionsType.setSequenceNumber(protocolAction2.getSequenceNumber());
            if (protocolAction2.getSubmissionNumber() != null) {
                protocolActionsType.setSubmissionNumber(protocolAction2.getSubmissionNumber());
            }
            protocolActionsType.setUpdateUser(protocolAction2.getUpdateUser());
            if (protocol.getApprovalDate() == null) continue;
            protocolActionsType.setApprovalDate(this.convertDateToCalendar(protocol.getApprovalDate()));
        }
    }

    private void setProtocolFundingResources(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolFundingSourceBase> protocolFundngSources = protocol.getProtocolFundingSources();
        for (ProtocolFundingSource protocolFundingSource : protocolFundngSources) {
            ProtocolFundingSourceType protocolFundingSourceType = protocolSummary.addNewProtocolFundingSources();
            protocolFundingSourceType.setFundingSource(protocolFundingSource.getFundingSourceNumber());
            protocolFundingSourceType.setFundingSourceTypeCode(Integer.valueOf(protocolFundingSource.getFundingSourceTypeCode()));
            String title = this.getFundingSourceNameOrTitle(protocolFundingSource);
            if (title != null) {
                protocolFundingSourceType.setTitle(title);
            }
            if (protocolFundingSource.getFundingSourceType() != null) {
                protocolFundingSourceType.setFundingSourceTypeDesc(protocolFundingSource.getFundingSourceType().getDescription());
            }
            protocolFundingSourceType.setProtocolNumber(protocolFundingSource.getProtocolNumber());
            protocolFundingSourceType.setSequenceNumber(protocolFundingSource.getSequenceNumber());
            protocolFundingSourceType.setUpdateUser(protocolFundingSource.getUpdateUser());
        }
    }

    private String getFundingSourceNameOrTitle(ProtocolFundingSource fundingSourceBean) {
        String title = null;
        String fundingSourceTypeCode = fundingSourceBean.getFundingSourceTypeCode();
        if ("1".equals(fundingSourceTypeCode)) {
            title = this.getSponsorName(fundingSourceBean.getFundingSourceNumber());
        } else if ("2".equals(fundingSourceTypeCode)) {
            title = this.getUnitName(fundingSourceBean.getFundingSourceNumber());
        } else if ("4".equals(fundingSourceTypeCode)) {
            title = this.getDevelopmentProposalTitle(fundingSourceBean.getFundingSourceNumber());
        } else if ("5".equals(fundingSourceTypeCode)) {
            title = this.getInstitutionalProposalTitle(fundingSourceBean.getFundingSourceNumber());
        } else if ("6".equals(fundingSourceTypeCode)) {
            title = this.getAwardTitle(fundingSourceBean.getFundingSourceNumber());
        }
        return title;
    }

    private String getSponsorName(String fundingSourceNumber) {
        return this.getSponsorService().getSponsorName(fundingSourceNumber);
    }

    private String getUnitName(String fundingSourceNumber) {
        return this.getUnitService().getUnitName(fundingSourceNumber);
    }

    private String getDevelopmentProposalTitle(String fundingSourceNumber) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)fundingSourceNumber);
        return developmentProposal == null ? null : developmentProposal.getTitle();
    }

    private String getInstitutionalProposalTitle(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal == null ? null : institutionalProposal.getTitle();
    }

    private String getAwardTitle(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award == null ? null : award.getTitle();
    }

    private void setProtocolResearchAreas(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolResearchAreaBase> vecResearchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchArea protocolResearchArea : vecResearchAreas) {
            ProtocolResearchAreasType protocolResearchAreasType = protocolSummary.addNewProtocolResearchAreas();
            protocolResearchAreasType.setProtocolNumber(protocolResearchArea.getProtocolNumber());
            protocolResearchAreasType.setResearchAreaCode(protocolResearchArea.getResearchAreaCode());
            protocolResearchAreasType.setResearchAreaDesc(protocolResearchArea.getResearchAreas().getDescription());
            protocolResearchAreasType.setSequenceNumber(protocolResearchArea.getSequenceNumber());
            protocolResearchAreasType.setUpdateUser(protocolResearchArea.getUpdateUser());
        }
    }

    private void setProtocolLocations(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolLocationBase> protocolLocationList = protocol.getProtocolLocations();
        for (ProtocolLocation protocolLocation : protocolLocationList) {
            protocolLocation.refreshNonUpdateableReferences();
            ProtocolLocationType protocolLocationType = protocolSummary.addNewProtocolOrganization();
            protocolLocationType.setOrganizationId(protocolLocation.getOrganizationId());
            if (protocolLocation.getProtocolOrganizationType() != null) {
                protocolLocationType.setProtocolOrgTypeCode(Integer.parseInt(protocolLocation.getProtocolOrganizationTypeCode()));
                protocolLocationType.setProtocolOrgTypeDesc(protocolLocation.getProtocolOrganizationType().getDescription());
            }
            if (protocolLocation.getOrganization() != null) {
                protocolLocationType.setOrgName(protocolLocation.getOrganization().getOrganizationName());
            }
            protocolLocationType.setAddress(this.getAddress(protocolLocation));
            protocolLocationType.setRolodexId(protocolLocation.getRolodexId());
        }
    }

    private String getAddress(ProtocolLocation protocolLocationListBean) {
        Rolodex address;
        protocolLocationListBean.refreshNonUpdateableReferences();
        StringBuilder strBffr = new StringBuilder();
        if (protocolLocationListBean.getOrganization() != null) {
            strBffr.append(protocolLocationListBean.getOrganization().getOrganizationName());
            strBffr.append(" ");
        }
        if ((address = protocolLocationListBean.getRolodex()) != null) {
            strBffr.append(address.getAddressLine1());
            strBffr.append(" ");
            strBffr.append(address.getAddressLine2());
            strBffr.append(" ");
            strBffr.append(address.getAddressLine3());
            strBffr.append(" ");
            strBffr.append(address.getCity());
            strBffr.append(" ");
            strBffr.append(address.getCounty());
            strBffr.append(" ");
            strBffr.append(address.getState());
            strBffr.append(" ");
            strBffr.append(address.getPostalCode());
            strBffr.append(" ");
            strBffr.append(address.getCountryCode());
            strBffr.append(" ");
        }
        return strBffr.toString();
    }

    private void setProtocolPersons(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List<ProtocolPersonBase> vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPerson protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                ProtocolInvestigatorType protocolInvestigatorType = protocolSummary.addNewProtocolInvestigators();
                protocolInvestigatorType.setPersonId(protocolPerson.getPersonId());
                protocolInvestigatorType.setPersonName(protocolPerson.getPersonName());
                if (protocolPerson.getAffiliationType() != null) {
                    protocolInvestigatorType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode());
                    protocolInvestigatorType.setAffiliationTypeDesc(protocolPerson.getAffiliationType().getDescription());
                }
                protocolInvestigatorType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
                protocolInvestigatorType.setPrincipalInvestigatorFlag(protocolPerson.isPrincipalInvestigator() ? "Y" : "N");
                protocolInvestigatorType.setProtocolNumber(protocolPerson.getProtocolNumber());
                protocolInvestigatorType.setSequenceNumber(protocolPerson.getSequenceNumber());
                protocolInvestigatorType.setUpdateUser(protocolPerson.getUpdateUser());
                protocolInvestigatorType.setTrainingFlag(protocolPerson.isTrained() ? "Y" : "N");
                List<ProtocolUnitBase> vecInvUnits = protocolPerson.getProtocolUnits();
                for (ProtocolUnit protocolUnit : vecInvUnits) {
                    ProtocolUnitsType protocolUnitsType = protocolInvestigatorType.addNewProtocolUnits();
                    protocolUnitsType.setLeadUnitFlag(protocolUnit.getLeadUnitFlag() ? "Y" : "N");
                    protocolUnitsType.setPersonId(protocolUnit.getPersonId());
                    protocolUnitsType.setUnitNumber(protocolUnit.getUnitNumber());
                    protocolUnitsType.setUnitName(protocolUnit.getUnitName());
                    protocolUnitsType.setProtocolNumber(protocolUnit.getProtocolNumber());
                    protocolUnitsType.setSequenceNumber(protocolUnit.getSequenceNumber());
                }
                continue;
            }
            if (protocolPerson.getProtocolPersonRoleId().equals("SP")) {
                ProtocolKeyPersonsType protocolKeyPersonsType = protocolSummary.addNewProtocolKeyPersons();
                protocolKeyPersonsType.setPersonId(protocolPerson.getPersonId());
                protocolKeyPersonsType.setPersonName(protocolPerson.getPersonName());
                protocolKeyPersonsType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode());
                protocolKeyPersonsType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
                protocolKeyPersonsType.setProtocolNumber(protocolPerson.getProtocolNumber());
                protocolKeyPersonsType.setSequenceNumber(protocolPerson.getSequenceNumber());
                protocolKeyPersonsType.setUpdateUser(protocolPerson.getUpdateUser());
                if (protocolPerson.getProtocolPersonRole() != null) {
                    protocolKeyPersonsType.setPersonRole(protocolPerson.getProtocolPersonRole().getDescription());
                }
                protocolKeyPersonsType.setTrainingFlag(protocolPerson.isTrained() ? "Y" : "N");
                protocolKeyPersonsType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode());
                if (protocolPerson.getAffiliationType() == null) continue;
                protocolKeyPersonsType.setAffiliationTypeDesc(protocolPerson.getAffiliationType().getDescription());
                continue;
            }
            if (!protocolPerson.getProtocolPersonRoleId().equals("CRC") && !protocolPerson.getProtocolPersonRoleId().equals("CA")) continue;
            ProtocolCorrespondentType protocolCorrespondentType = protocolSummary.addNewProtocolCorrespondents();
            protocolCorrespondentType.setCorrespondentTypeCode(Integer.parseInt(protocolPerson.getProtocolPersonRoleId()));
            protocolCorrespondentType.setCorrespondentTypeDesc(protocolPerson.getProtocolPersonRole().getDescription());
            protocolCorrespondentType.setComments(protocolPerson.getComments());
            protocolCorrespondentType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
            protocolCorrespondentType.setPersonId(protocolPerson.getPersonId());
            protocolCorrespondentType.setPersonName(protocolPerson.getPersonName());
            protocolCorrespondentType.setProtocolNumber(protocolPerson.getProtocolNumber());
            protocolCorrespondentType.setSequenceNumber(protocolPerson.getSequenceNumber());
            protocolCorrespondentType.setUpdateUser(protocolPerson.getUpdateUser());
        }
    }

    private void setProtocolDetails(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        if (protocol != null) {
            ProtocolDetailsType protocolDetailsType = protocolSummary.addNewProtocolDetails();
            if (protocol.getSubmissionDate() != null) {
                protocolDetailsType.setApplicationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getSubmissionDate()));
            }
            if (protocol.getApprovalDate() != null) {
                protocolDetailsType.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
            }
            if (protocol.getInitialSubmissionDate() != null) {
                protocolDetailsType.setCreateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocol.getUpdateTimestamp()));
            }
            protocolDetailsType.setDescription(protocol.getDescription());
            if (protocol.getExpirationDate() != null) {
                protocolDetailsType.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
            }
            protocolDetailsType.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
            if (protocol.getProtocolSubmission() != null) {
                protocolDetailsType.setIsBillable(protocol.getProtocolSubmission().isBillable() ? "Y" : "N");
            }
            if (protocol.getLastApprovalDate() != null) {
                protocolDetailsType.setLastApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getLastApprovalDate()));
            }
            protocolDetailsType.setProtocolNumber(protocol.getProtocolNumber());
            if (protocol.getProtocolStatusCode() != null) {
                protocolDetailsType.setProtocolStatusCode(Integer.parseInt(protocol.getProtocolStatusCode()));
                protocolDetailsType.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            }
            protocolDetailsType.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            if (protocol.getProtocolTypeCode() != null) {
                protocolDetailsType.setProtocolTypeCode(Integer.parseInt(protocol.getProtocolTypeCode()));
                protocolDetailsType.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
            }
            this.setProtocolInvestigator(protocol, protocolDetailsType);
            protocolDetailsType.setReferenceNumber1(protocol.getReferenceNumber1());
            protocolDetailsType.setReferenceNumber2(protocol.getReferenceNumber2());
            protocolDetailsType.setSequenceNumber(protocol.getSequenceNumber());
            protocolDetailsType.setTitle(protocol.getTitle());
            protocolDetailsType.setUpdateUser(protocol.getUpdateUser());
        }
    }

    private void setProtocolInvestigator(Protocol protocol, ProtocolDetailsType protocolDetailsType) {
        List<ProtocolPersonBase> vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPerson protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (!protocolPerson.getProtocolPersonRoleId().equals("PI")) continue;
            protocolDetailsType.setInvestigator(protocolPerson.getPersonName());
        }
    }

    public SponsorService getSponsorService() {
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public ProtocolNotificationTemplateAuthorizationService getProtocolNotificationTemplateAuthorizationService() {
        return this.protocolNotificationTemplateAuthorizationService;
    }

    public void setProtocolNotificationTemplateAuthorizationService(ProtocolNotificationTemplateAuthorizationService protocolNotificationTemplateAuthorizationService) {
        this.protocolNotificationTemplateAuthorizationService = protocolNotificationTemplateAuthorizationService;
    }
}

