/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public abstract class ProtocolDocumentBase
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final Logger LOG = LogManager.getLogger(ProtocolDocumentBase.class);
    private static final long serialVersionUID = 6493566444038807312L;
    private List<ProtocolBase> protocolList = new ArrayList<ProtocolBase>();
    private String protocolWorkflowType;
    private boolean reRouted = false;
    public ProtocolLocationService protocolLocationService;
    private transient ProjectPublisher projectPublisher;

    public ProtocolDocumentBase() {
        ProtocolBase newProtocol = this.createNewProtocolInstanceHook();
        newProtocol.setProtocolDocument(this);
        this.protocolList.add(newProtocol);
        this.setProtocolWorkflowType(ProtocolWorkflowType.NORMAL);
        this.initializeProtocolLocation();
    }

    protected abstract ProtocolBase createNewProtocolInstanceHook();

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("RESEARCH_AREA_CODE", "000001");
        ResearchAreaBase ra = (ResearchAreaBase)this.getBusinessObjectService().findByPrimaryKey(this.getResearchAreaBoClassHook(), primaryKeys);
        ArrayList<ResearchAreaBase> selectedBOs = new ArrayList<ResearchAreaBase>();
        selectedBOs.add(ra);
        KcServiceLocator.getService(this.getProtocolResearchAreaServiceClassHook()).addProtocolResearchArea(this.getProtocol(), selectedBOs);
    }

    protected abstract Class<? extends ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook();

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBoClassHook();

    public ProtocolBase getProtocol() {
        if (this.protocolList.size() == 0) {
            return null;
        }
        return this.protocolList.get(0);
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocolList.set(0, protocol);
    }

    public List<ProtocolBase> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<ProtocolBase> protocolList) {
        this.protocolList = protocolList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        if (this.getProtocol() != null) {
            managedLists.addAll(this.getProtocol().buildListOfDeletionAwareLists());
        }
        managedLists.add(this.protocolList);
        return managedLists;
    }

    @Override
    public abstract String getDocumentTypeCode();

    public String getProtocolWorkflowType() {
        return this.protocolWorkflowType;
    }

    public void setProtocolWorkflowType(ProtocolWorkflowType protocolWorkflowType) {
        this.protocolWorkflowType = protocolWorkflowType.getName();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            if (this.isFinal(statusChangeEvent)) {
                this.mergeProtocolAmendment();
            } else if (this.isDisapproved(statusChangeEvent)) {
                if (!this.isNormal()) {
                    this.getProtocol().setActive(false);
                    this.getBusinessObjectService().save((PersistableBusinessObject)this);
                }
                try {
                    this.performVersioningOperationsOnProtocolAfterDisapproval();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            } else if (this.isRecall(statusChangeEvent)) {
                this.getProtocolGenericActionService().recall(this.getProtocol());
            }
            Project project = this.getProjectRetrievalService().retrieveProject(this.getProtocol().getProtocolNumber());
            if (project != null) {
                this.getProjectPublisher().publishProject(project);
            }
            return null;
        });
    }

    protected DocumentRouteHeaderValue getDocumentRouteHeaderValue() {
        return KcServiceLocator.getService(RouteHeaderService.class).getRouteHeader(this.getDocumentHeader().getWorkflowDocument().getDocumentId());
    }

    protected void setProtocolDocumentToApproveByDefault() {
        DocumentRouteHeaderValue document = this.getDocumentRouteHeaderValue();
        document.getDocumentType().getDefaultApprovePolicy().setPolicyValue(Boolean.valueOf(true));
    }

    protected void performVersioningOperationsOnProtocolAfterDisapproval() throws Exception {
        ProtocolBase protocol = this.getProtocol();
        if (!StringUtils.equals((CharSequence)this.getCommitteeDisapprovedStatusCodeHook(), (CharSequence)protocol.getProtocolStatusCode())) {
            this.getProtocolGenericActionService().recordDisapprovedInRoutingActionAndUpdateStatuses(protocol, this.getLatestCurrentActionTakenValue());
            ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().versionAfterDisapprovalInRouting(protocol);
            protocol = newDocument.getProtocol();
            ProtocolNotificationContextBase context = this.getDisapproveNotificationContextHook(protocol);
            ProtocolNotification notification = this.getNewProtocolNotificationInstanceHook();
            this.getNotificationService().sendNotificationAndPersist(context, notification, protocol);
        }
    }

    protected abstract String getCommitteeDisapprovedStatusCodeHook();

    protected abstract ProtocolNotification getNewProtocolNotificationInstanceHook();

    protected abstract ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase var1);

    protected final ActionTakenValue getLatestCurrentActionTakenValue() {
        ActionTakenValue latestCurrentActionTakenVal = null;
        DocumentRouteHeaderValue routeHeaderValue = this.getRouteHeaderService().getRouteHeader(this.getDocumentHeader().getWorkflowDocument().getDocumentId());
        List actionsTakenList = routeHeaderValue.getActionsTaken();
        for (ActionTakenValue actionTakenVal : actionsTakenList) {
            if (!actionTakenVal.getCurrentIndicator().booleanValue() || latestCurrentActionTakenVal != null && !actionTakenVal.getActionDate().after(latestCurrentActionTakenVal.getActionDate())) continue;
            latestCurrentActionTakenVal = actionTakenVal;
        }
        return latestCurrentActionTakenVal;
    }

    protected RouteHeaderService getRouteHeaderService() {
        return KcServiceLocator.getService(RouteHeaderService.class);
    }

    protected KcNotificationService getNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }

    protected ProtocolGenericActionService getProtocolGenericActionService() {
        return KcServiceLocator.getService(this.getProtocolGenericActionServiceClassHook());
    }

    protected abstract Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook();

    protected abstract void mergeProtocolAmendment();

    public void updateProtocolStatus(String actionTypeCode, String comments) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(this.getProtocol(), null, actionTypeCode);
        protocolAction.setComments(comments);
        this.getProtocol().getProtocolActions().add(protocolAction);
        this.getProtocolActionService().updateProtocolStatus(protocolAction, this.getProtocol());
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected ProtocolActionService getProtocolActionService() {
        return KcServiceLocator.getService(this.getProtocolActionServiceClassHook());
    }

    protected abstract Class<? extends ProtocolActionService> getProtocolActionServiceClassHook();

    protected void finalizeAttachmentProtocol(ProtocolBase protocol) {
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!attachment.isDraft()) continue;
            attachment.setDocumentStatusCode("2");
        }
    }

    protected String getProtocolNumberIndex() {
        return this.getProtocol().getProtocolNumber().substring(11);
    }

    protected DocumentService getDocumentService() {
        return KcServiceLocator.getService(DocumentService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    protected String getOriginalProtocolNumber() {
        return this.getProtocol().getProtocolNumber().substring(0, 10);
    }

    protected boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((CharSequence)"F", (CharSequence)statusChangeEvent.getNewRouteStatus());
    }

    protected boolean isDisapproved(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((CharSequence)"D", (CharSequence)statusChangeEvent.getNewRouteStatus());
    }

    protected boolean isRecall(DocumentRouteStatusChange statusChangeEvent) {
        return !StringUtils.equals((CharSequence)"I", (CharSequence)statusChangeEvent.getOldRouteStatus()) && StringUtils.equals((CharSequence)"S", (CharSequence)statusChangeEvent.getNewRouteStatus());
    }

    public boolean isRenewal() {
        return this.getProtocol().isRenewal();
    }

    public boolean isAmendment() {
        return this.getProtocol().isAmendment();
    }

    public boolean isFYI() {
        return this.getProtocol().isFYI();
    }

    public boolean isRenewalWithAmendment() {
        return this.getProtocol().isRenewalWithAmendment();
    }

    public boolean isNormal() {
        return !this.isAmendment() && !this.isRenewal() && !this.isFYI();
    }

    private boolean isComplete(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((CharSequence)"R", (CharSequence)statusChangeEvent.getNewRouteStatus()) && StringUtils.equals((CharSequence)"S", (CharSequence)statusChangeEvent.getOldRouteStatus());
    }

    public void initializeProtocolLocation() {
        if (this.getProtocolLocationService() != null) {
            this.getProtocolLocationService().addDefaultProtocolLocation(this.getProtocol());
        }
    }

    protected abstract Class<? extends ProtocolLocationService> getProtocolLocationServiceClassHook();

    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        this.getProtocol().getLeadUnitNumber();
        return super.wrapDocumentWithMetadataForXmlSerialization();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getProtocol().getProtocolNumber();
    }

    public boolean getReRouted() {
        return this.reRouted;
    }

    public void setReRouted(boolean reRouted) {
        this.reRouted = reRouted;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return KRADServiceLocatorWeb.getWorkflowDocumentService();
    }

    protected String getNewProtocolDocId() {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("protocolNumber", this.getProtocol().getAmendedProtocolNumber());
        keyMap.put("active", "Y");
        BusinessObjectService boService = KcServiceLocator.getService(BusinessObjectService.class);
        List protocols = (List)boService.findMatchingOrderBy(this.getProtocolBOClassHook(), keyMap, "sequenceNumber", false);
        return protocols.size() == 0 ? null : ((ProtocolBase)protocols.get(0)).getProtocolDocument().getDocumentNumber();
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getProtocol().getLeadUnitNumber());
    }

    public ProtocolLocationService getProtocolLocationService() {
        if (this.protocolLocationService == null) {
            return KcServiceLocator.getService(this.getProtocolLocationServiceClassHook());
        }
        return this.protocolLocationService;
    }

    public void setProtocolLocationService(ProtocolLocationService protocolLocationService) {
        this.protocolLocationService = protocolLocationService;
    }

    public abstract ProjectRetrievalService getProjectRetrievalService();

    public abstract void setProjectRetrievalService(ProjectRetrievalService var1);

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public static enum ProtocolWorkflowType {
        NORMAL("Normal"),
        APPROVED("Approved"),
        APPROVED_AMENDMENT("ApprovedAmendment");

        private final String name;

        private ProtocolWorkflowType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ProtocolMergeException
    extends RuntimeException {
        private static final long serialVersionUID = 8370108752465881796L;

        public ProtocolMergeException(Throwable t) {
            super(t);
        }
    }
}

