/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewService;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.SaveProtocolFundingSourceLinkEvent;

public class SaveProtocolFundingSourceLinkRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<SaveProtocolFundingSourceLinkEvent> {
    private static final String FUNDING_SOURCE_NUMBER = "fundingSourceNumber";
    private SpecialReviewService specialReviewService;
    private AwardService awardService;
    private InstitutionalProposalService institutionalProposalService;

    @Override
    public boolean processRules(SaveProtocolFundingSourceLinkEvent event) {
        boolean rulePassed = true;
        for (ProtocolFundingSourceBase protocolFundingSource : event.getProtocolFundingSources()) {
            String fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
            String fundingSourceTypeCode = protocolFundingSource.getFundingSourceTypeCode();
            String protocolNumber = protocolFundingSource.getProtocolNumber();
            if (this.getSpecialReviewService().isLinkedToSpecialReview(fundingSourceNumber, fundingSourceTypeCode, protocolNumber)) continue;
            rulePassed &= this.validateProtocolFundingSource(protocolFundingSource);
        }
        return rulePassed;
    }

    private boolean validateProtocolFundingSource(ProtocolFundingSourceBase protocolFundingSource) {
        InstitutionalProposal institutionalProposal;
        boolean isValid = true;
        String fundingSourceType = protocolFundingSource.getFundingSourceTypeCode();
        String fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
        if (StringUtils.equals((CharSequence)"6", (CharSequence)String.valueOf(fundingSourceType))) {
            Award award = this.getAward(fundingSourceNumber);
            if (!award.getAwardDocument().getPessimisticLocks().isEmpty()) {
                isValid = false;
                this.reportError(FUNDING_SOURCE_NUMBER, "error.protocol.fundingSource.award.locked", fundingSourceNumber);
            }
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)String.valueOf(fundingSourceType)) && !(institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber)).getInstitutionalProposalDocument().getPessimisticLocks().isEmpty()) {
            isValid = false;
            this.reportError(FUNDING_SOURCE_NUMBER, "error.protocol.fundingSource.institutional.proposal.locked", fundingSourceNumber);
        }
        return isValid;
    }

    private Award getAward(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award;
    }

    private InstitutionalProposal getInstitutionalProposal(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal;
    }

    private SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = KcServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

