/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.Calendar;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.rice.kns.rule.PromptBeforeValidation;
import org.kuali.rice.kns.rules.PromptBeforeValidationBase;
import org.kuali.rice.krad.document.Document;

public class SubAwardInvoicePromptBeforeValidation
extends PromptBeforeValidationBase
implements PromptBeforeValidation {
    protected static final String EFFECTIVE_DATE_PROMPT_ID = "effectiveDate";
    protected static final String EFFECTIVE_DATE_PROMPT = "Invoice Effective Date is more than 30 days in the past or more than 30 days in the future. Do you wish to continue?";

    public boolean doPrompts(Document document) {
        SubAwardAmountReleased invoice = (SubAwardAmountReleased)document.getNoteTarget();
        if (invoice.getEffectiveDate() != null) {
            Calendar beforeEffective = Calendar.getInstance();
            beforeEffective.add(5, -30);
            Calendar afterEffective = Calendar.getInstance();
            afterEffective.add(5, 30);
            Calendar effectiveDate = Calendar.getInstance();
            effectiveDate.setTime(invoice.getEffectiveDate());
            if (effectiveDate.before(beforeEffective) || effectiveDate.after(afterEffective)) {
                if (!this.askOrAnalyzeYesNoQuestion(EFFECTIVE_DATE_PROMPT_ID, EFFECTIVE_DATE_PROMPT)) {
                    this.abortRulesCheck();
                    return false;
                }
                return true;
            }
        }
        return true;
    }
}

