/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.joda.time.DateTimeZone;

public interface DocValueFormat
extends NamedWriteable {
    public static final DocValueFormat RAW = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "raw";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Long format(long value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public String format(BytesRef value) {
            return value.utf8ToString();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            double d = Double.parseDouble(value);
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef((CharSequence)value);
        }
    };
    public static final DocValueFormat BINARY = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "binary";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            return Base64.getEncoder().withoutPadding().encodeToString(Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length));
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(Base64.getDecoder().decode(value));
        }
    };
    public static final DocValueFormat GEOHASH = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "geo_hash";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(long value) {
            return GeoHashUtils.stringEncode(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }
    };
    public static final DocValueFormat BOOLEAN = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "bool";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Boolean format(long value) {
            return value != 0L;
        }

        @Override
        public Boolean format(double value) {
            return value != 0.0;
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            switch (value) {
                case "false": {
                    return 0L;
                }
                case "true": {
                    return 1L;
                }
            }
            throw new IllegalArgumentException("Cannot parse boolean [" + value + "], expected either [true] or [false]");
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }
    };
    public static final DocValueFormat IP = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "ip";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
            InetAddress inet = InetAddressPoint.decode((byte[])bytes);
            return NetworkAddress.format(inet);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(value)));
        }
    };

    default public Object format(long value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(double value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(BytesRef value) {
        throw new UnsupportedOperationException();
    }

    default public long parseLong(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public double parseDouble(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public BytesRef parseBytesRef(String value) {
        throw new UnsupportedOperationException();
    }

    public static final class Decimal
    implements DocValueFormat {
        public static final String NAME = "decimal";
        private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
        final String pattern;
        private final NumberFormat format;

        public Decimal(String pattern) {
            this.pattern = pattern;
            this.format = new DecimalFormat(pattern, SYMBOLS);
        }

        public Decimal(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
        }

        @Override
        public String format(long value) {
            return this.format.format(value);
        }

        @Override
        public String format(double value) {
            return this.format.format(value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (this.format.isParseIntegerOnly()) {
                return n.longValue();
            }
            double d = n.doubleValue();
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return n.doubleValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Decimal that = (Decimal)o;
            return Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }

    public static final class DateTime
    implements DocValueFormat {
        public static final String NAME = "date_time";
        final DateFormatter formatter;
        final DateTimeZone timeZone;
        private final ZoneId zoneId;
        private final DateMathParser parser;

        public DateTime(DateFormatter formatter, DateTimeZone timeZone) {
            this.formatter = Objects.requireNonNull(formatter);
            this.timeZone = Objects.requireNonNull(timeZone);
            this.zoneId = DateUtils.dateTimeZoneToZoneId(timeZone);
            this.parser = formatter.toDateMathParser();
        }

        public DateTime(StreamInput in) throws IOException {
            this(DateFormatter.forPattern(in.readString()), DateTimeZone.forID((String)in.readString()));
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.formatter.pattern());
            out.writeString(this.timeZone.getID());
        }

        @Override
        public String format(long value) {
            return this.formatter.withZone(this.zoneId).formatMillis(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return this.parser.parse(value, now, roundUp, DateUtils.dateTimeZoneToZoneId(this.timeZone));
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }
    }
}

