/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.process;

public class ProcessWorkItemHandlerException
extends RuntimeException {
    private static final long serialVersionUID = -5953387125605633663L;
    private String processId;
    private HandlingStrategy strategy;

    public ProcessWorkItemHandlerException(String processId, String strategy, Throwable cause) {
        this(processId, HandlingStrategy.valueOf(strategy), cause);
    }

    public ProcessWorkItemHandlerException(String processId, HandlingStrategy strategy, Throwable cause) {
        super(cause);
        this.processId = processId;
        this.strategy = strategy;
        if (processId == null || strategy == null) {
            throw new IllegalArgumentException("Process id and strategy are required");
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public HandlingStrategy getStrategy() {
        return this.strategy;
    }

    public static enum HandlingStrategy {
        RETRY,
        COMPLETE,
        ABORT,
        RETHROW;

    }
}

