/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.jrobin.core.jrrd.Archive;
import org.jrobin.core.jrrd.ConsolidationFunctionType;
import org.jrobin.core.jrrd.DataChunk;
import org.jrobin.core.jrrd.DataSource;
import org.jrobin.core.jrrd.Header;
import org.jrobin.core.jrrd.RRDException;
import org.jrobin.core.jrrd.RRDFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRDatabase {
    RRDFile rrdFile;
    private String name;
    Header header;
    ArrayList<DataSource> dataSources;
    ArrayList<Archive> archives;
    Date lastUpdate;

    public RRDatabase(String name) throws IOException {
        this(new File(name));
    }

    public RRDatabase(File file) throws IOException {
        Archive archive;
        DataSource ds;
        this.name = file.getName();
        this.rrdFile = new RRDFile(file);
        this.header = new Header(this.rrdFile);
        this.dataSources = new ArrayList();
        int i = 0;
        while (i < this.header.dsCount) {
            ds = new DataSource(this.rrdFile);
            this.dataSources.add(ds);
            ++i;
        }
        this.archives = new ArrayList();
        i = 0;
        while (i < this.header.rraCount) {
            archive = new Archive(this);
            this.archives.add(archive);
            ++i;
        }
        this.rrdFile.align();
        this.lastUpdate = new Date((long)this.rrdFile.readInt() * 1000L);
        i = 0;
        while (i < this.header.dsCount) {
            ds = this.dataSources.get(i);
            ds.loadPDPStatusBlock(this.rrdFile);
            ++i;
        }
        i = 0;
        while (i < this.header.rraCount) {
            archive = this.archives.get(i);
            archive.loadCDPStatusBlocks(this.rrdFile, this.header.dsCount);
            ++i;
        }
        i = 0;
        while (i < this.header.rraCount) {
            archive = this.archives.get(i);
            archive.loadCurrentRow(this.rrdFile);
            ++i;
        }
        i = 0;
        while (i < this.header.rraCount) {
            archive = this.archives.get(i);
            archive.loadData(this.rrdFile, this.header.dsCount);
            ++i;
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public DataSource getDataSource(int index) {
        return this.dataSources.get(index);
    }

    public Iterator<DataSource> getDataSources() {
        return this.dataSources.iterator();
    }

    public Archive getArchive(int index) {
        return this.archives.get(index);
    }

    public Iterator<Archive> getArchives() {
        return this.archives.iterator();
    }

    public int getNumArchives() {
        return this.header.rraCount;
    }

    public Iterator<Archive> getArchives(ConsolidationFunctionType type) {
        return this.getArchiveList(type).iterator();
    }

    ArrayList<Archive> getArchiveList(ConsolidationFunctionType type) {
        ArrayList<Archive> subset = new ArrayList<Archive>();
        int i = 0;
        while (i < this.archives.size()) {
            Archive archive = this.archives.get(i);
            if (archive.getType().equals(type)) {
                subset.add(archive);
            }
            ++i;
        }
        return subset;
    }

    public void close() throws IOException {
        this.rrdFile.close();
    }

    public void printInfo(PrintStream s) {
        DecimalFormat numberFormat = new DecimalFormat("0.0000000000E0");
        this.printInfo(s, numberFormat);
    }

    public DataChunk getData(ConsolidationFunctionType type) throws RRDException, IOException {
        return this.getData(type, 1L);
    }

    public DataChunk getData(ConsolidationFunctionType type, long step) throws RRDException, IOException {
        ArrayList<Archive> possibleArchives = this.getArchiveList(type);
        if (possibleArchives.size() == 0) {
            throw new RRDException("Database does not contain an Archive of consolidation function type " + type);
        }
        Calendar endCal = Calendar.getInstance();
        endCal.set(14, 0);
        Calendar startCal = (Calendar)endCal.clone();
        startCal.add(5, -1);
        long end = endCal.getTime().getTime() / 1000L;
        long start = startCal.getTime().getTime() / 1000L;
        Archive archive = this.findBestArchive(start, end, step, possibleArchives);
        step = this.header.pdpStep * archive.pdpCount;
        start -= start % step;
        if (end % step != 0L) {
            end += step - end % step;
        }
        int rows = (int)((end - start) / step + 1L);
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        long archiveEndTime = lastUpdateLong - lastUpdateLong % step;
        long archiveStartTime = archiveEndTime - step * (long)(archive.rowCount - 1);
        int startOffset = (int)((start - archiveStartTime) / step);
        int endOffset = (int)((archiveEndTime - end) / step);
        DataChunk chunk = new DataChunk(start, startOffset, endOffset, step, this.header.dsCount, rows);
        archive.loadData(chunk);
        return chunk;
    }

    private Archive findBestArchive(long start, long end, long step, ArrayList<Archive> archives) {
        Archive archive = null;
        Archive bestFullArchive = null;
        Archive bestPartialArchive = null;
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        boolean firstPart = true;
        boolean firstFull = true;
        long bestMatch = 0L;
        long bestStepDiff = 0L;
        long tmpStepDiff = 0L;
        int i = 0;
        while (i < archives.size()) {
            archive = archives.get(i);
            long calEnd = lastUpdateLong - lastUpdateLong % (long)(archive.pdpCount * this.header.pdpStep);
            long calStart = calEnd - (long)(archive.pdpCount * archive.rowCount * this.header.pdpStep);
            long fullMatch = end - start;
            if (calEnd >= end && calStart < start) {
                tmpStepDiff = Math.abs(step - (long)(this.header.pdpStep * archive.pdpCount));
                if (firstFull || tmpStepDiff < bestStepDiff) {
                    firstFull = false;
                    bestStepDiff = tmpStepDiff;
                    bestFullArchive = archive;
                }
            } else {
                long tmpMatch = fullMatch;
                if (calStart > start) {
                    tmpMatch -= calStart - start;
                }
                if (calEnd < end) {
                    tmpMatch -= end - calEnd;
                }
                if (firstPart || bestMatch < tmpMatch) {
                    firstPart = false;
                    bestMatch = tmpMatch;
                    bestPartialArchive = archive;
                }
            }
            ++i;
        }
        if (!firstFull) {
            archive = bestFullArchive;
        } else if (!firstPart) {
            archive = bestPartialArchive;
        }
        return archive;
    }

    public void printInfo(PrintStream s, NumberFormat numberFormat) {
        s.print("filename = \"");
        s.print(this.name);
        s.println("\"");
        s.print("rrd_version = \"");
        s.print(this.header.version);
        s.println("\"");
        s.print("step = ");
        s.println(this.header.pdpStep);
        s.print("last_update = ");
        s.println(this.lastUpdate.getTime() / 1000L);
        for (DataSource ds : this.dataSources) {
            ds.printInfo(s, numberFormat);
        }
        int index = 0;
        for (Archive archive : this.archives) {
            archive.printInfo(s, numberFormat, index++);
        }
    }

    public void toXml(PrintStream s) {
        s.println("<!--");
        s.println("  -- Round Robin RRDatabase Dump ");
        s.println("  -- Generated by jRRD <ciaran@codeloop.com>");
        s.println("  -->");
        s.println("<rrd>");
        s.print("\t<version> ");
        s.print(this.header.version);
        s.println(" </version>");
        s.print("\t<step> ");
        s.print(this.header.pdpStep);
        s.println(" </step> <!-- Seconds -->");
        s.print("\t<lastupdate> ");
        s.print(this.lastUpdate.getTime() / 1000L);
        s.print(" </lastupdate> <!-- ");
        s.print(this.lastUpdate.toString());
        s.println(" -->");
        s.println();
        int i = 0;
        while (i < this.header.dsCount) {
            DataSource ds = this.dataSources.get(i);
            ds.toXml(s);
            ++i;
        }
        s.println("<!-- Round Robin Archives -->");
        i = 0;
        while (i < this.header.rraCount) {
            Archive archive = this.archives.get(i);
            archive.toXml(s);
            ++i;
        }
        s.println("</rrd>");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        sb.append(this.header.toString());
        for (DataSource ds : this.dataSources) {
            sb.append("\n\t");
            sb.append(ds.toString());
        }
        for (Archive archive : this.archives) {
            sb.append("\n\t");
            sb.append(archive.toString());
        }
        return sb.toString();
    }
}

