/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class CIELabColorFunction
extends FunctionBase {
    CIELabColorFunction() {
    }

    public int getRequiredArgsCount() {
        return 6;
    }

    public PercentBase getPercentBase() {
        return new CIELabPercentBase();
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        float red = args[0].getNumber().floatValue();
        float green = args[1].getNumber().floatValue();
        float blue = args[2].getNumber().floatValue();
        if (red < 0.0f || red > 255.0f || green < 0.0f || green > 255.0f || blue < 0.0f || blue > 255.0f) {
            throw new PropertyException("sRGB color values out of range. Arguments to cie-lab-color() must be [0..255] or [0%..100%]");
        }
        float l = args[3].getNumber().floatValue();
        float a = args[4].getNumber().floatValue();
        float b = args[5].getNumber().floatValue();
        if (l < 0.0f || l > 100.0f) {
            throw new PropertyException("L* value out of range. Valid range: [0..100]");
        }
        if (a < -127.0f || a > 127.0f || b < -127.0f || b > 127.0f) {
            throw new PropertyException("a* and b* values out of range. Valid range: [-127..+127]");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("cie-lab-color(" + red + "," + green + "," + blue + "," + l + "," + a + "," + b + ")");
        FOUserAgent ua = pInfo == null ? null : (pInfo.getFO() == null ? null : pInfo.getFO().getUserAgent());
        return ColorProperty.getInstance(ua, sb.toString());
    }

    private static class CIELabPercentBase
    implements PercentBase {
        private CIELabPercentBase() {
        }

        public int getDimension() {
            return 0;
        }

        public double getBaseValue() {
            return 1.0;
        }

        public int getBaseLength(PercentBaseContext context) {
            return 0;
        }
    }
}

