/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Image;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MemoryInformations;
import net.bull.javamelody.internal.model.TomcatInformations;
import net.bull.javamelody.internal.web.html.HtmlJavaInformationsReport;
import net.bull.javamelody.internal.web.pdf.Bar;
import net.bull.javamelody.internal.web.pdf.PdfAbstractReport;
import net.bull.javamelody.internal.web.pdf.PdfDocumentFactory;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

class PdfJavaInformationsReport
extends PdfAbstractReport {
    private static final String DIVIDE = " / ";
    private static final String BAR_SEPARATOR = "   ";
    private final boolean noDatabase = Parameters.isNoDatabase();
    private final DecimalFormat decimalFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final List<JavaInformations> javaInformationsList;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font boldCellFont = PdfFonts.BOLD_CELL.getFont();
    private PdfPTable currentTable;

    PdfJavaInformationsReport(List<JavaInformations> javaInformationsList, Document document) {
        super(document);
        assert (javaInformationsList != null);
        this.javaInformationsList = javaInformationsList;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.addCell("");
            this.addCell("");
            this.addToDocument((Element)this.currentTable);
        }
    }

    private static PdfPTable createJavaInformationsTable() throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setHorizontalAlignment(0);
        table.setWidthPercentage(100.0f);
        table.setWidths(new int[]{2, 8});
        table.getDefaultCell().setBorder(0);
        return table;
    }

    private void writeSummary(JavaInformations javaInformations) throws BadElementException, IOException {
        this.addCell(PdfJavaInformationsReport.getString("Host") + ':');
        this.currentTable.addCell(new Phrase(javaInformations.getHost(), this.boldCellFont));
        this.addCell(PdfJavaInformationsReport.getString("memoire_utilisee") + ':');
        MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
        long usedMemory = memoryInformations.getUsedMemory();
        long maxMemory = memoryInformations.getMaxMemory();
        Phrase memoryPhrase = new Phrase(this.integerFormat.format(usedMemory / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo") + DIVIDE + this.integerFormat.format(maxMemory / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo") + BAR_SEPARATOR, this.cellFont);
        com.lowagie.text.Image memoryImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(memoryInformations.getUsedMemoryPercentage()), null);
        memoryImage.scalePercent(50.0f);
        memoryPhrase.add((Object)new Chunk(memoryImage, 0.0f, 0.0f));
        this.currentTable.addCell(memoryPhrase);
        if (javaInformations.getSessionCount() >= 0) {
            this.addCell(PdfJavaInformationsReport.getString("nb_sessions_http") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getSessionCount()));
        }
        this.addCell(PdfJavaInformationsReport.getString("nb_threads_actifs") + "\n(" + PdfJavaInformationsReport.getString("Requetes_http_en_cours") + "):");
        this.addCell(this.integerFormat.format(javaInformations.getActiveThreadCount()));
        if (!this.noDatabase) {
            this.addCell(PdfJavaInformationsReport.getString("nb_connexions_actives") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getActiveConnectionCount()));
            this.addCell(PdfJavaInformationsReport.getString("nb_connexions_utilisees") + "\n(" + PdfJavaInformationsReport.getString("ouvertes") + "):");
            int usedConnectionCount = javaInformations.getUsedConnectionCount();
            int maxConnectionCount = javaInformations.getMaxConnectionCount();
            if (maxConnectionCount <= 0) {
                this.addCell(this.integerFormat.format(usedConnectionCount));
            } else {
                Phrase usedConnectionCountPhrase = new Phrase(this.integerFormat.format(usedConnectionCount) + DIVIDE + this.integerFormat.format(maxConnectionCount) + BAR_SEPARATOR, this.cellFont);
                com.lowagie.text.Image usedConnectionCountImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(javaInformations.getUsedConnectionPercentage()), null);
                usedConnectionCountImage.scalePercent(50.0f);
                usedConnectionCountPhrase.add((Object)new Chunk(usedConnectionCountImage, 0.0f, 0.0f));
                this.currentTable.addCell(usedConnectionCountPhrase);
            }
        }
        if (javaInformations.getSystemLoadAverage() >= 0.0) {
            this.addCell(PdfJavaInformationsReport.getString("Charge_systeme") + ':');
            this.addCell(this.decimalFormat.format(javaInformations.getSystemLoadAverage()));
        }
        if (javaInformations.getSystemCpuLoad() >= 0.0) {
            this.addCell(PdfJavaInformationsReport.getString("systemCpuLoad") + ':');
            Phrase systemCpuLoadPhrase = new Phrase(this.decimalFormat.format(javaInformations.getSystemCpuLoad()) + BAR_SEPARATOR, this.cellFont);
            com.lowagie.text.Image systemCpuLoadImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(javaInformations.getSystemCpuLoad()), null);
            systemCpuLoadImage.scalePercent(50.0f);
            systemCpuLoadPhrase.add((Object)new Chunk(systemCpuLoadImage, 0.0f, 0.0f));
            this.currentTable.addCell(systemCpuLoadPhrase);
        }
    }

    void writeInformationsDetails() throws DocumentException, IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.writeDetails(javaInformations);
            this.addToDocument((Element)this.currentTable);
        }
    }

    private void writeDetails(JavaInformations javaInformations) throws BadElementException, IOException {
        String serverInfo;
        this.addCell(PdfJavaInformationsReport.getString("OS") + ':');
        Phrase osPhrase = new Phrase("", this.cellFont);
        String osIconName = HtmlJavaInformationsReport.getOSIconName(javaInformations.getOS());
        String separator = BAR_SEPARATOR;
        if (osIconName != null) {
            com.lowagie.text.Image osImage = PdfDocumentFactory.getImage("servers/" + osIconName);
            osImage.scalePercent(40.0f);
            osPhrase.add((Object)new Chunk(osImage, 0.0f, 0.0f));
            osPhrase.add((Object)BAR_SEPARATOR);
        }
        osPhrase.add((Object)(javaInformations.getOS() + " (" + javaInformations.getAvailableProcessors() + ' ' + PdfJavaInformationsReport.getString("coeurs") + ')'));
        this.currentTable.addCell(osPhrase);
        this.addCell(PdfJavaInformationsReport.getString("Java") + ':');
        this.addCell(javaInformations.getJavaVersion());
        this.addCell(PdfJavaInformationsReport.getString("JVM") + ':');
        Phrase jvmVersionPhrase = new Phrase(javaInformations.getJvmVersion(), this.cellFont);
        if (javaInformations.getJvmVersion().contains("Client")) {
            jvmVersionPhrase.add((Object)BAR_SEPARATOR);
            com.lowagie.text.Image alertImage = PdfDocumentFactory.getImage("alert.png");
            alertImage.scalePercent(50.0f);
            jvmVersionPhrase.add((Object)new Chunk(alertImage, 0.0f, -2.0f));
        }
        this.currentTable.addCell(jvmVersionPhrase);
        this.addCell(PdfJavaInformationsReport.getString("PID") + ':');
        this.addCell(javaInformations.getPID());
        if (javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
            this.writeFileDescriptorCounts(javaInformations);
        }
        if ((serverInfo = javaInformations.getServerInfo()) != null) {
            this.writeServerInfo(serverInfo);
            this.addCell(PdfJavaInformationsReport.getString("Contexte_webapp") + ':');
            this.addCell(javaInformations.getContextPath());
        }
        this.addCell(PdfJavaInformationsReport.getString("Demarrage") + ':');
        this.addCell(I18N.createDateAndTimeFormat().format(javaInformations.getStartDate()));
        this.addCell(PdfJavaInformationsReport.getString("Arguments_JVM") + ':');
        this.addCell(javaInformations.getJvmArguments());
        if (javaInformations.getSessionCount() >= 0) {
            this.addCell(PdfJavaInformationsReport.getString("httpSessionsMeanAge") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getSessionMeanAgeInMinutes()));
        }
        this.writeTomcatInformations(javaInformations.getTomcatInformationsList());
        this.addCell(PdfJavaInformationsReport.getString("Gestion_memoire") + ':');
        this.writeMemoryInformations(javaInformations.getMemoryInformations());
        if (javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.addCell(PdfJavaInformationsReport.getString("Free_disk_space") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getFreeDiskSpaceInTemp() / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo"));
        }
        this.writeDatabaseVersionAndDataSourceDetails(javaInformations);
        this.addCell("");
        this.addCell("");
    }

    private void writeServerInfo(String serverInfo) throws BadElementException, IOException {
        this.addCell(PdfJavaInformationsReport.getString("Serveur") + ':');
        Phrase serverInfoPhrase = new Phrase("", this.cellFont);
        String applicationServerIconName = HtmlJavaInformationsReport.getApplicationServerIconName(serverInfo);
        if (applicationServerIconName != null) {
            com.lowagie.text.Image applicationServerImage = PdfDocumentFactory.getImage("servers/" + applicationServerIconName);
            applicationServerImage.scalePercent(40.0f);
            serverInfoPhrase.add((Object)new Chunk(applicationServerImage, 0.0f, 0.0f));
            serverInfoPhrase.add((Object)BAR_SEPARATOR);
        }
        serverInfoPhrase.add((Object)serverInfo);
        this.currentTable.addCell(serverInfoPhrase);
    }

    private void writeFileDescriptorCounts(JavaInformations javaInformations) throws BadElementException, IOException {
        long unixOpenFileDescriptorCount = javaInformations.getUnixOpenFileDescriptorCount();
        long unixMaxFileDescriptorCount = javaInformations.getUnixMaxFileDescriptorCount();
        this.addCell(PdfJavaInformationsReport.getString("nb_fichiers") + ':');
        Phrase fileDescriptorCountPhrase = new Phrase(this.integerFormat.format(unixOpenFileDescriptorCount) + DIVIDE + this.integerFormat.format(unixMaxFileDescriptorCount) + BAR_SEPARATOR, this.cellFont);
        com.lowagie.text.Image fileDescriptorCountImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(javaInformations.getUnixOpenFileDescriptorPercentage()), null);
        fileDescriptorCountImage.scalePercent(50.0f);
        fileDescriptorCountPhrase.add((Object)new Chunk(fileDescriptorCountImage, 0.0f, 0.0f));
        this.currentTable.addCell(fileDescriptorCountPhrase);
    }

    private void writeDatabaseVersionAndDataSourceDetails(JavaInformations javaInformations) {
        if (!this.noDatabase && javaInformations.getDataBaseVersion() != null) {
            this.addCell(PdfJavaInformationsReport.getString("Base_de_donnees") + ':');
            this.addCell(javaInformations.getDataBaseVersion());
        }
        if (javaInformations.getDataSourceDetails() != null) {
            this.addCell(PdfJavaInformationsReport.getString("DataSource_jdbc") + ':');
            this.addCell(javaInformations.getDataSourceDetails());
            this.addCell("");
            Anchor anchor = new Anchor("DataSource reference", PdfFonts.BLUE.getFont());
            anchor.setName("DataSource reference");
            anchor.setReference("http://commons.apache.org/dbcp/apidocs/org/apache/commons/dbcp/BasicDataSource.html");
            this.currentTable.addCell((Phrase)anchor);
        }
    }

    private void writeTomcatInformations(List<TomcatInformations> tomcatInformationsList) throws BadElementException, IOException {
        for (TomcatInformations tomcatInformations : tomcatInformationsList) {
            if (tomcatInformations.getRequestCount() <= 0) continue;
            this.addCell("Tomcat " + tomcatInformations.getName() + ':');
            int currentThreadsBusy = tomcatInformations.getCurrentThreadsBusy();
            String equal = " = ";
            Phrase phrase = new Phrase(PdfJavaInformationsReport.getString("busyThreads") + " = " + this.integerFormat.format(currentThreadsBusy) + DIVIDE + this.integerFormat.format(tomcatInformations.getMaxThreads()) + BAR_SEPARATOR, this.cellFont);
            com.lowagie.text.Image threadsImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(100.0 * (double)currentThreadsBusy / (double)tomcatInformations.getMaxThreads()), null);
            threadsImage.scalePercent(50.0f);
            phrase.add((Object)new Chunk(threadsImage, 0.0f, 0.0f));
            phrase.add((Object)new Chunk('\n' + PdfJavaInformationsReport.getString("bytesReceived") + " = " + this.integerFormat.format(tomcatInformations.getBytesReceived()) + '\n' + PdfJavaInformationsReport.getString("bytesSent") + " = " + this.integerFormat.format(tomcatInformations.getBytesSent()) + '\n' + PdfJavaInformationsReport.getString("requestCount") + " = " + this.integerFormat.format(tomcatInformations.getRequestCount()) + '\n' + PdfJavaInformationsReport.getString("errorCount") + " = " + this.integerFormat.format(tomcatInformations.getErrorCount()) + '\n' + PdfJavaInformationsReport.getString("processingTime") + " = " + this.integerFormat.format(tomcatInformations.getProcessingTime()) + '\n' + PdfJavaInformationsReport.getString("maxProcessingTime") + " = " + this.integerFormat.format(tomcatInformations.getMaxTime())));
            this.currentTable.addCell(phrase);
        }
    }

    private void writeMemoryInformations(MemoryInformations memoryInformations) throws BadElementException, IOException {
        this.addCell(memoryInformations.getMemoryDetails().replace(" Mo", ' ' + PdfJavaInformationsReport.getString("Mo")));
        long usedPermGen = memoryInformations.getUsedPermGen();
        if (usedPermGen > 0L) {
            long maxPermGen = memoryInformations.getMaxPermGen();
            this.addCell(PdfJavaInformationsReport.getString("Memoire_Perm_Gen") + ':');
            if (maxPermGen > 0L) {
                Phrase permGenPhrase = new Phrase(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo") + DIVIDE + this.integerFormat.format(maxPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo") + BAR_SEPARATOR, this.cellFont);
                com.lowagie.text.Image permGenImage = com.lowagie.text.Image.getInstance((Image)Bar.toBarWithAlert(memoryInformations.getUsedPermGenPercentage()), null);
                permGenImage.scalePercent(50.0f);
                permGenPhrase.add((Object)new Chunk(permGenImage, 0.0f, 0.0f));
                this.currentTable.addCell(permGenPhrase);
            } else {
                this.addCell(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getString("Mo"));
            }
        }
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

