/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="viewHeader", parent="Uif-ViewHeader")
public class ViewHeader
extends Header {
    private static final long serialVersionUID = -974112303431464467L;
    private Message areaTitleMessage;
    private Message supportTitleMessage;
    private Message metadataMessage;
    private boolean sticky;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        View view = ViewLifecycle.getView();
        if (this.supportTitleMessage != null && view.getCurrentPage() != null && view.getCurrentPage().getHeader() != null && view.isUnifiedHeader()) {
            Header pageHeader = view.getCurrentPage().getHeader();
            pageHeader.addStyleClass("uif-hideHeaderText");
            Message pageHeaderMessage = pageHeader.getRichHeaderMessage();
            if (pageHeaderMessage != null && StringUtils.isBlank((String)this.supportTitleMessage.getMessageText())) {
                pageHeaderMessage.addStyleClass("uif-viewHeader-supportTitle");
                this.supportTitleMessage = pageHeaderMessage;
            } else if (StringUtils.isNotBlank((String)pageHeader.getHeaderText()) && StringUtils.isBlank((String)this.supportTitleMessage.getMessageText())) {
                this.supportTitleMessage.setMessageText(pageHeader.getHeaderText().trim());
            }
        }
        this.getCssClasses().addAll(0, view.getContentContainerCssClasses());
        if (this.isSticky()) {
            this.addDataAttribute("sticky", "true");
        }
    }

    @BeanTagAttribute
    public String getAreaTitleText() {
        return this.areaTitleMessage.getMessageText();
    }

    public void setAreaTitleText(String areaTitle) {
        this.areaTitleMessage.setMessageText(areaTitle);
    }

    @BeanTagAttribute
    public Message getAreaTitleMessage() {
        return this.areaTitleMessage;
    }

    public void setAreaTitleMessage(Message areaTitleMessage) {
        this.areaTitleMessage = areaTitleMessage;
    }

    @BeanTagAttribute
    public String getSupportTitleText() {
        return this.supportTitleMessage.getMessageText();
    }

    public void setSupportTitleText(String supportTitle) {
        this.supportTitleMessage.setMessageText(supportTitle);
    }

    @BeanTagAttribute
    public Message getSupportTitleMessage() {
        return this.supportTitleMessage;
    }

    public void setSupportTitleMessage(Message supportTitleMessage) {
        this.supportTitleMessage = supportTitleMessage;
    }

    @BeanTagAttribute
    public String getMetadataText() {
        return this.metadataMessage.getMessageText();
    }

    public void setMetadataText(String metadataText) {
        this.metadataMessage.setMessageText(metadataText);
    }

    @BeanTagAttribute
    public Message getMetadataMessage() {
        return this.metadataMessage;
    }

    public void setMetadataMessage(Message metadataMessage) {
        this.metadataMessage = metadataMessage;
    }

    @BeanTagAttribute
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }
}

