/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.cache.CacheAdminService;
import org.kuali.rice.core.api.cache.CacheTarget;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class CacheAdminServiceImpl
implements CacheAdminService,
InitializingBean {
    private static final Logger LOG = LogManager.getLogger(CacheAdminServiceImpl.class);
    private CacheManager cacheManager;

    public void flush(Collection<CacheTarget> cacheTargets) throws RiceIllegalArgumentException {
        if (CollectionUtils.isNotEmpty(cacheTargets)) {
            this.logCacheFlush(cacheTargets);
            for (CacheTarget cacheTarget : cacheTargets) {
                if (cacheTarget == null) {
                    throw new RiceIllegalArgumentException("cacheTarget is null");
                }
                Cache c = this.getCache(cacheTarget.getCache());
                if (c == null) continue;
                if (cacheTarget.containsKey()) {
                    c.evict((Object)cacheTarget.getKey());
                    continue;
                }
                c.clear();
            }
        }
    }

    protected void logCacheFlush(Collection<CacheTarget> cacheTargets) {
        if (LOG.isDebugEnabled()) {
            ArrayList<String> cacheTargetLog = new ArrayList<String>(cacheTargets.size());
            for (CacheTarget cacheTarget : cacheTargets) {
                cacheTargetLog.add(cacheTarget.toString());
            }
            LOG.debug("Performing local flush of cache targets [" + StringUtils.join(cacheTargetLog, (String)", ") + "]");
        }
    }

    private Cache getCache(String cache) {
        return this.cacheManager.getCache(cache);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheManager == null) {
            throw new IllegalStateException("the cacheManager must be set");
        }
    }
}

