/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.deliverer.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.api.exception.MessageDismissalException;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;

public class AOLInstantMessageDeliverer
implements MessageDeliverer {
    private static final String SCREEN_NAME = "aim_screen_name";

    @Override
    public void deliver(MessageDelivery messageDelivery) throws MessageDeliveryException {
    }

    @Override
    public void dismiss(MessageDelivery messageDelivery, String user, String cause) throws MessageDismissalException {
    }

    @Override
    public String getDescription() {
        return "This is the default AOL Instant Messenger delivery type.";
    }

    @Override
    public String getName() {
        return "AIM";
    }

    @Override
    public String getTitle() {
        return "AOL Instant Messenger Delivery";
    }

    public LinkedHashMap getPreferenceKeys() {
        LinkedHashMap<String, String> prefKeys = new LinkedHashMap<String, String>();
        prefKeys.put(SCREEN_NAME, "AIM Screen Name");
        return prefKeys;
    }

    public void validatePreferenceValues(HashMap prefs) throws ErrorList {
        boolean error = false;
        ErrorList errorList = new ErrorList();
        if (!prefs.containsKey(this.getName() + ".aim_screen_name")) {
            errorList.addError("AIM Screen Name is a required field.");
            error = true;
        } else {
            String screenName = (String)prefs.get(this.getName() + ".aim_screen_name");
            if (StringUtils.isBlank((String)screenName)) {
                errorList.addError("AIM Screen Name is a required.");
                error = true;
            }
        }
        if (error) {
            throw errorList;
        }
    }
}

