/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.deliverer.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.api.exception.MessageDismissalException;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;

public class SMSMessageDeliverer
implements MessageDeliverer {
    private static final String MOBILE_NUMBER = "sms_mobile_number";

    @Override
    public void deliver(MessageDelivery messageDelivery) throws MessageDeliveryException {
    }

    @Override
    public void dismiss(MessageDelivery messageDelivery, String user, String cause) throws MessageDismissalException {
    }

    @Override
    public String getDescription() {
        return "This is the default SMS message delivery type.  Please note that you may incur charges for each SMS message that you receive to your mobile phone.";
    }

    @Override
    public String getName() {
        return "SMS";
    }

    @Override
    public String getTitle() {
        return "SMS Message Delivery";
    }

    public LinkedHashMap getPreferenceKeys() {
        LinkedHashMap<String, String> prefKeys = new LinkedHashMap<String, String>();
        prefKeys.put(MOBILE_NUMBER, "Mobile Phone Number (\"555-555-5555\")");
        return prefKeys;
    }

    public void validatePreferenceValues(HashMap prefs) throws ErrorList {
        boolean error = false;
        ErrorList errorList = new ErrorList();
        if (!prefs.containsKey(this.getName() + ".sms_mobile_number")) {
            errorList.addError("Mobile Phone Number is a required field.");
            error = true;
        } else {
            String mobileNumber = (String)prefs.get(this.getName() + ".sms_mobile_number");
            if (StringUtils.isBlank((String)mobileNumber)) {
                errorList.addError("Mobile Phone Number is a required.");
                error = true;
            }
        }
        if (error) {
            throw errorList;
        }
    }
}

