/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.deliverer.impl.AOLInstantMessageDeliverer;
import org.kuali.rice.kcb.deliverer.impl.EmailMessageDeliverer;
import org.kuali.rice.kcb.deliverer.impl.MockMessageDeliverer;
import org.kuali.rice.kcb.deliverer.impl.SMSMessageDeliverer;
import org.kuali.rice.kcb.service.MessageDelivererRegistryService;

public class MessageDelivererRegistryServiceImpl
implements MessageDelivererRegistryService {
    private static Logger LOG = LogManager.getLogger(MessageDelivererRegistryServiceImpl.class);
    private HashMap<String, Class<? extends MessageDeliverer>> messageDelivererTypes;

    public MessageDelivererRegistryServiceImpl() {
        EmailMessageDeliverer email = new EmailMessageDeliverer();
        SMSMessageDeliverer sms = new SMSMessageDeliverer();
        AOLInstantMessageDeliverer aim = new AOLInstantMessageDeliverer();
        MockMessageDeliverer mock = new MockMessageDeliverer();
        this.messageDelivererTypes = new HashMap(4);
        this.messageDelivererTypes.put(email.getName().toLowerCase(), email.getClass());
        this.messageDelivererTypes.put(sms.getName().toLowerCase(), sms.getClass());
        this.messageDelivererTypes.put(aim.getName().toLowerCase(), aim.getClass());
        this.messageDelivererTypes.put(mock.getName().toLowerCase(), mock.getClass());
    }

    @Override
    public Collection<String> getAllDelivererTypes() {
        Collection<MessageDeliverer> deliverers = this.getAllDeliverers();
        HashSet<String> types = new HashSet<String>(deliverers.size());
        for (MessageDeliverer deliverer : deliverers) {
            types.add(deliverer.getName().toLowerCase());
        }
        return types;
    }

    @Override
    public Collection<MessageDeliverer> getAllDeliverers() {
        ArrayList<MessageDeliverer> delivererTypes = new ArrayList<MessageDeliverer>();
        Set<Map.Entry<String, Class<? extends MessageDeliverer>>> registeredTypes = this.messageDelivererTypes.entrySet();
        for (Map.Entry<String, Class<? extends MessageDeliverer>> entry : registeredTypes) {
            try {
                delivererTypes.add(entry.getValue().newInstance());
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getStackTrace());
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getStackTrace());
            }
        }
        return delivererTypes;
    }

    @Override
    public MessageDeliverer getDeliverer(MessageDelivery messageDelivery) {
        if (messageDelivery == null) {
            throw new RiceIllegalArgumentException("messageDelivery is null");
        }
        MessageDeliverer nmd = this.getDelivererByName(messageDelivery.getDelivererTypeName());
        if (nmd == null) {
            LOG.error("The message deliverer type ('" + messageDelivery.getDelivererTypeName() + "') associated with message delivery id='" + messageDelivery.getId() + "' was not found in the message deliverer registry.  This deliverer plugin is not in the system.");
        }
        return nmd;
    }

    @Override
    public MessageDeliverer getDelivererByName(String messageDelivererName) {
        if (StringUtils.isBlank((String)messageDelivererName)) {
            throw new RiceIllegalArgumentException("messageDelivererName is null or blank");
        }
        Class<? extends MessageDeliverer> clazz = this.messageDelivererTypes.get(messageDelivererName.toLowerCase());
        if (clazz == null) {
            LOG.error("The message deliverer type ('" + messageDelivererName + "')  was not found in the message deliverer registry.  This deliverer plugin is not in the system.");
            return null;
        }
        MessageDeliverer messageDeliverer = null;
        try {
            messageDeliverer = clazz.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)e.getStackTrace());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getStackTrace());
        }
        return messageDeliverer;
    }
}

