/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.document.kew.NotificationWorkflowDocument;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class AdministerNotificationRequestController
extends MultiActionController {
    private static final Logger LOG = LogManager.getLogger(AdministerNotificationRequestController.class);
    protected NotificationMessageContentService messageContentService;
    protected NotificationWorkflowDocumentService workflowDocumentService;
    protected NotificationRecipientService recipientService;

    public void setMessageContentService(NotificationMessageContentService notificationMessageContentService) {
        this.messageContentService = notificationMessageContentService;
    }

    public void setWorkflowDocumentService(NotificationWorkflowDocumentService notificationWorkflowDocumentService) {
        this.workflowDocumentService = notificationWorkflowDocumentService;
    }

    public void setRecipientService(NotificationRecipientService notificationRecipientService) {
        this.recipientService = notificationRecipientService;
    }

    private NotificationBo retrieveNotificationForWorkflowDocument(WorkflowDocument document) throws Exception {
        String notificationAsXml = document.getApplicationContent();
        NotificationBo notification = this.messageContentService.parseSerializedNotificationXml(notificationAsXml.getBytes());
        return notification;
    }

    public ModelAndView view(HttpServletRequest request, HttpServletResponse response, AdministerNotificationRequestCommand command) {
        String initiatorId = request.getRemoteUser();
        if (command.getDocId() == null) {
            throw new RuntimeException("An invalid document ID was recieved from KEW's action list.");
        }
        String view = request.getParameter("command");
        String standaloneWindow = "true";
        if (view != null && view.equals("displayActionListInlineView")) {
            standaloneWindow = "false";
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("standaloneWindow", standaloneWindow);
        try {
            WorkflowDocument document = NotificationWorkflowDocument.loadNotificationDocument(initiatorId, command.getDocId());
            NotificationBo notification = this.retrieveNotificationForWorkflowDocument(document);
            command.setDocument(document);
            command.setNotification(notification);
            command.setRenderedContent(Util.transformContent(notification));
            LOG.info("notification auto remove date time: " + notification.getAutoRemoveDateTime());
            if (document.isApproved()) {
                command.setValid(false);
                command.setMessage("This notification request has been approved.");
            } else if (document.isDisapproved()) {
                command.setMessage("This notification request has been disapproved.");
            } else if (notification.getAutoRemoveDateTime() != null && notification.getAutoRemoveDateTimeValue().before(new Date(System.currentTimeMillis()))) {
                boolean disapproved = document.isDisapproved();
                if (!document.isDisapproved()) {
                    List<NotificationChannelReviewerBo> reviewers = notification.getChannel().getReviewers();
                    String user = null;
                    block2: for (NotificationChannelReviewerBo reviewer : reviewers) {
                        String[] members;
                        if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)reviewer.getReviewerType())) {
                            if (!reviewer.getReviewerId().equals(request.getRemoteUser())) continue;
                            user = request.getRemoteUser();
                            continue;
                        }
                        if (!KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.equals((Object)reviewer.getReviewerType())) continue;
                        for (String member : members = this.recipientService.getGroupMembers(reviewer.getReviewerId())) {
                            if (!StringUtils.equals((String)member, (String)request.getRemoteUser())) continue;
                            user = request.getRemoteUser();
                            continue block2;
                        }
                    }
                    if (user != null) {
                        WorkflowDocumentFactory.loadDocument(user, (String)command.getDocId()).disapprove("Disapproving notification request.  Auto-remove datetime has already passed.");
                        disapproved = true;
                    }
                }
                command.setValid(false);
                if (disapproved) {
                    command.setMessage("This notification request is no longer valid because the Auto-Remove date has already passed.  It has been disapproved.  Please refresh your action list.");
                } else {
                    command.setMessage("This notification request is no longer valid because the Auto-Remove date has already passed.");
                }
            }
            model.put(this.getCommandName(command), command);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ModelAndView("ViewNotificationRequestDetails", model);
    }

    public ModelAndView approve(HttpServletRequest request, HttpServletResponse response, AdministerNotificationRequestCommand command) throws ServletException {
        this.administerEventNotificationMessage(request, response, command, "approve");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("workflowActionTaken", "Approved");
        model.put("standaloneWindow", request.getParameter("standaloneWindow"));
        return new ModelAndView("SendNotificationRequestActionTakenWindow", model);
    }

    public ModelAndView disapprove(HttpServletRequest request, HttpServletResponse response, AdministerNotificationRequestCommand command) throws ServletException {
        this.administerEventNotificationMessage(request, response, command, "disapprove");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("workflowActionTaken", "Disapproved");
        model.put("standaloneWindow", request.getParameter("standaloneWindow"));
        return new ModelAndView("SendNotificationRequestActionTakenWindow", model);
    }

    public ModelAndView acknowledge(HttpServletRequest request, HttpServletResponse response, AdministerNotificationRequestCommand command) throws ServletException {
        this.administerEventNotificationMessage(request, response, command, "acknowledge");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("standaloneWindow", request.getParameter("standaloneWindow"));
        model.put("workflowActionTaken", "Acknowledged");
        return new ModelAndView("SendNotificationRequestActionTakenWindow", model);
    }

    private void administerEventNotificationMessage(HttpServletRequest request, HttpServletResponse response, AdministerNotificationRequestCommand command, String action) throws ServletException {
        LOG.debug("remoteUser: " + request.getRemoteUser());
        BindException bindException = new BindException((Object)command, "command");
        ValidationUtils.rejectIfEmpty((Errors)bindException, (String)"docId", (String)"Document id must be specified");
        if (bindException.hasErrors()) {
            throw new ServletRequestBindingException("Document id must be specified", (Throwable)bindException);
        }
        String userId = request.getRemoteUser();
        try {
            WorkflowDocument document = NotificationWorkflowDocument.loadNotificationDocument(userId, command.getDocId());
            NotificationBo notification = this.retrieveNotificationForWorkflowDocument(document);
            String initiatorPrincipalId = document.getInitiatorPrincipalId();
            Person initiator = KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
            String notificationBlurb = notification.getContentType().getName() + " notification submitted by " + initiator.getName() + " for channel " + notification.getChannel().getName();
            if ("disapprove".equals(action)) {
                document.disapprove("User " + userId + " disapproving " + notificationBlurb);
            } else if ("approve".equals(action)) {
                document.approve("User " + userId + " approving " + notificationBlurb);
            } else if ("acknowledge".equals(action)) {
                document.acknowledge("User " + userId + " acknowledging " + notificationBlurb);
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred taking action on notification request", (Throwable)e);
            throw new ServletException("Exception occurred taking action on notification request", (Throwable)e);
        }
    }

    public static class AdministerNotificationRequestCommand {
        private String docId;
        private WorkflowDocument document;
        private NotificationBo notification;
        private String renderedContent;
        private boolean valid = true;
        private String message;

        public String getDocId() {
            return this.docId;
        }

        public void setDocId(String docId) {
            this.docId = docId;
        }

        public WorkflowDocument getDocument() {
            return this.document;
        }

        public void setDocument(WorkflowDocument document) {
            this.document = document;
        }

        public NotificationBo getNotification() {
            return this.notification;
        }

        public void setNotification(NotificationBo notification) {
            this.notification = notification;
        }

        public String getRenderedContent() {
            return this.renderedContent;
        }

        public void setRenderedContent(String renderedContent) {
            this.renderedContent = renderedContent;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

