/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.framework;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.coi.framework.AbstractProjectRetrievalService;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectSponsor;

public abstract class AbstractMultiSponsorProjectRetrievalService
extends AbstractProjectRetrievalService {
    @Override
    public Collection<Project> retrieveProjects() {
        Map<String, Project> projects = this.getProjectsMap();
        if (!projects.isEmpty()) {
            Map<String, List<ProjectPerson>> persons = this.getPersonsMap();
            persons.forEach((k, v) -> ((Project)projects.get(k)).setPersons((List<ProjectPerson>)v));
            Map<String, List<ProjectSponsor>> sponsors = this.getJdbcOperations().query(c -> c.prepareStatement(this.allProjectSponsorQuery()), (rs, rowNum) -> this.toProjectSponsor(rs)).stream().collect(Collectors.groupingBy(ProjectSponsor::getSourceIdentifier));
            sponsors.forEach((k, v) -> this.setSponsorFields((List<ProjectSponsor>)v, (Project)projects.get(k)));
        }
        return projects.values();
    }

    @Override
    public Project retrieveProject(String sourceIdentifier) {
        Project project = super.retrieveProject(sourceIdentifier);
        if (project != null) {
            List sponsors = this.getJdbcOperations().query(c -> {
                PreparedStatement statement = c.prepareStatement(this.projectSponsorQuery());
                statement.setString(1, sourceIdentifier);
                return statement;
            }, (rs, rowNum) -> this.toProjectSponsor(rs));
            this.setSponsorFields(sponsors, project);
        }
        return project;
    }

    protected abstract ProjectSponsor toProjectSponsor(ResultSet var1) throws SQLException;

    protected abstract String allProjectSponsorQuery();

    protected abstract String projectSponsorQuery();
}

