/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.summary;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonServiceFactory;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.kra.infrastructure.OnOffCampusFlagConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetSummaryService")
public class BudgetSummaryServiceImpl
implements BudgetSummaryService {
    private static final String BUDGET_DATE_CHANGE_WARNING_MSG = "Changing the budget period dates will result in changes being made to line item Expenses & recalculation of the budget, Do you want to proceed? ";
    private static final String BUDGET_DATE_CHANGE_AND_DELETE_WARNING_MSG = "Changing the budget period dates will result in changes being made to line item Expenses & recalculation of the budget, and one or more periods to be deleted have expense line items that will be deleted. Are you sure you want to proceed? ";
    private static final String BUDGET_PERIOD_DELETE_WARNING_MSG = "One or more periods to be deleted have expense line items that will be deleted. Are you sure you want to proceed?";
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    @Override
    public void generateAllPeriods(Budget budget) {
        this.calculateBudget(budget);
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        List<Object> budgetLineItems = new ArrayList();
        int period1Duration = 0;
        BudgetPeriod budgetPeriod1 = null;
        block3: for (BudgetPeriod budgetPeriod : budgetPeriods) {
            Integer budPeriod = budgetPeriod.getBudgetPeriod();
            Long budgetPeriodId = budgetPeriod.getBudgetPeriodId();
            int lineDuration = 0;
            int currentPeriodDuration = 0;
            int gap = 0;
            ArrayList<Date> startEndDates = new ArrayList<Date>();
            switch (budPeriod) {
                case 1: {
                    budgetPeriod1 = budgetPeriod;
                    budgetLineItems = budgetPeriod.getBudgetLineItems();
                    period1Duration = this.getDateTimeService().dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
                    continue block3;
                }
            }
            budgetPeriod.setNumberOfParticipants(budgetPeriod1.getNumberOfParticipants());
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                BudgetLineItem budgetLineItem2 = (BudgetLineItem)this.getDataObjectService().copyInstance((Object)budgetLineItem, new CopyOption[]{CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER, CopyOption.RESET_OBJECT_ID});
                budgetLineItem2.setBudgetId(budget.getBudgetId());
                budgetLineItem2.getBudgetCalculatedAmounts().clear();
                budgetLineItem2.setBudgetPeriod(budPeriod);
                budgetLineItem2.setBudgetPeriodId(budgetPeriodId);
                budgetLineItem2.setBudgetPeriodBO(budgetPeriod);
                boolean isLeapDateInPeriod = this.isLeapDaysInPeriod(budgetLineItem2.getStartDate(), budgetLineItem2.getEndDate());
                gap = this.getDateTimeService().dateDiff((java.util.Date)budgetPeriod1.getStartDate(), (java.util.Date)budgetLineItem2.getStartDate(), false);
                boolean isLeapDayInGap = this.isLeapDaysInPeriod(budgetPeriod1.getStartDate(), budgetLineItem2.getStartDate());
                lineDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetLineItem2.getStartDate(), (java.util.Date)budgetLineItem2.getEndDate(), false);
                currentPeriodDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
                if (period1Duration == lineDuration || lineDuration > currentPeriodDuration) {
                    budgetLineItem2.setStartDate(budgetPeriod.getStartDate());
                    budgetLineItem2.setEndDate(budgetPeriod.getEndDate());
                } else {
                    startEndDates.add(0, budgetPeriod.getStartDate());
                    startEndDates.add(1, budgetPeriod.getEndDate());
                    List<Date> dates = this.getNewStartEndDates(startEndDates, gap, lineDuration, budgetLineItem2.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetLineItem2.setStartDate(dates.get(0));
                    budgetLineItem2.setEndDate(dates.get(1));
                }
                budgetLineItem2.setBasedOnLineItem(budgetLineItem2.getLineItemNumber());
                lineDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
                int personnelDuration = 0;
                List<BudgetPersonnelDetails> budgetPersonnelDetails = budgetLineItem2.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    budgetPersonnelDetail.setBudgetPersonnelLineItemId(null);
                    budgetPersonnelDetail.getBudgetCalculatedAmounts().clear();
                    personnelDuration = this.getDateTimeService().dateDiff((java.util.Date)budgetPersonnelDetail.getStartDate(), (java.util.Date)budgetPersonnelDetail.getEndDate(), false);
                    budgetPersonnelDetail.setBudgetPeriod(budPeriod);
                    budgetPersonnelDetail.setBudgetPeriodId(budgetPeriodId);
                    gap = this.getDateTimeService().dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetPersonnelDetail.getStartDate(), false);
                    isLeapDayInGap = this.isLeapDaysInPeriod(budgetLineItem.getStartDate(), budgetPersonnelDetail.getStartDate());
                    if (period1Duration == personnelDuration || personnelDuration >= lineDuration) {
                        budgetPersonnelDetail.setStartDate(budgetLineItem2.getStartDate());
                        budgetPersonnelDetail.setEndDate(budgetLineItem2.getEndDate());
                        continue;
                    }
                    startEndDates.add(0, budgetLineItem2.getStartDate());
                    startEndDates.add(1, budgetLineItem2.getEndDate());
                    isLeapDateInPeriod = this.isLeapDaysInPeriod(budgetPersonnelDetail.getStartDate(), budgetPersonnelDetail.getEndDate());
                    List<Date> dates = this.getNewStartEndDates(startEndDates, gap, personnelDuration, budgetPersonnelDetail.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetPersonnelDetail.setStartDate(dates.get(0));
                    budgetPersonnelDetail.setEndDate(dates.get(1));
                }
                budgetPeriod.getBudgetLineItems().add(budgetLineItem2);
            }
        }
        BudgetPeriod firstPeriod = budgetPeriods.get(0);
        for (BudgetLineItem budgetLineItem : new ArrayList<BudgetLineItem>(firstPeriod.getBudgetLineItems())) {
            this.budgetCalculationService.applyToLaterPeriods(budget, firstPeriod, budgetLineItem);
        }
        this.calculateBudget(budget);
        this.setupOldStartEndDate(budget, true);
    }

    @Override
    public List<BudgetPeriod> generateBudgetPeriods(Budget budget) {
        ArrayList<BudgetPeriod> budgetPeriods = new ArrayList<BudgetPeriod>();
        java.util.Date projectStartDate = budget.getStartDate();
        java.util.Date projectEndDate = budget.getEndDate();
        boolean budgetPeriodExists = true;
        Calendar cl = Calendar.getInstance();
        java.util.Date periodStartDate = projectStartDate;
        int budgetPeriodNum = 1;
        while (budgetPeriodExists) {
            cl.setTime(periodStartDate);
            cl.add(1, 1);
            Date nextPeriodStartDate = new Date(cl.getTime().getTime());
            cl.add(5, -1);
            java.util.Date periodEndDate = new Date(cl.getTime().getTime());
            switch (periodEndDate.compareTo(projectEndDate)) {
                case 1: {
                    periodEndDate = projectEndDate;
                }
                case 0: {
                    budgetPeriodExists = false;
                }
            }
            BudgetPeriod budgetPeriod = budget.getNewBudgetPeriod();
            budgetPeriod.setBudgetPeriod(budgetPeriodNum);
            budgetPeriod.setStartDate((Date)periodStartDate);
            budgetPeriod.setEndDate((Date)periodEndDate);
            budgetPeriod.setBudget(budget);
            budgetPeriods.add(budgetPeriod);
            periodStartDate = nextPeriodStartDate;
            ++budgetPeriodNum;
        }
        return budgetPeriods;
    }

    @Override
    public void defaultBudgetPeriods(Budget budget) {
        List<BudgetPeriod> newPeriods = this.generateBudgetPeriods(budget);
        while (budget.getBudgetPeriods().size() > newPeriods.size()) {
            this.deleteBudgetPeriod(budget, budget.getBudgetPeriods().size() - 1);
        }
        for (int i = 0; i < newPeriods.size(); ++i) {
            BudgetPeriod newPeriod = newPeriods.get(i);
            if (i < budget.getBudgetPeriods().size()) {
                BudgetPeriod curPeriod = budget.getBudgetPeriod(i);
                curPeriod.setStartDate(newPeriod.getStartDate());
                curPeriod.setEndDate(newPeriod.getEndDate());
                curPeriod.setCostSharingAmount(null);
                curPeriod.setDirectCostLimit(null);
                curPeriod.setExpenseTotal(null);
                curPeriod.setTotalCost(null);
                curPeriod.setTotalCostLimit(null);
                curPeriod.setTotalDirectCost(null);
                curPeriod.setTotalDirectCostLessSubcontractorFA(null);
                curPeriod.setTotalIndirectCost(null);
                curPeriod.setUnderrecoveryAmount(null);
                continue;
            }
            budget.getBudgetPeriods().add(newPeriod);
        }
        this.adjustStartEndDatesForLineItems(budget);
        this.calculateBudget(budget);
    }

    @Override
    public boolean budgetLineItemExists(Budget budget, Integer budgetPeriod) {
        boolean lineItemExists = false;
        List<BudgetLineItem> budgetLineItems = budget.getBudgetPeriod(budgetPeriod).getBudgetLineItems();
        block0: for (BudgetLineItem periodLineItem : budgetLineItems) {
            Integer lineItemPeriod = periodLineItem.getBudgetPeriod();
            if (budgetPeriod + 1 == lineItemPeriod) {
                lineItemExists = true;
                break;
            }
            List<BudgetPersonnelDetails> budgetPersonnelDetailsList = periodLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails periodPersonnelLineItem : budgetPersonnelDetailsList) {
                lineItemPeriod = periodPersonnelLineItem.getBudgetPeriod();
                if (budgetPeriod + 1 != lineItemPeriod) continue;
                lineItemExists = true;
                continue block0;
            }
        }
        return lineItemExists;
    }

    protected void updateBudgetPeriods(Budget budget, List<BudgetPeriod> budgetPeriods, int checkPeriod, boolean deletePeriod) {
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            Integer budPeriod = budgetPeriod.getBudgetPeriod();
            if (budPeriod < checkPeriod) continue;
            int newPeriod = 0;
            newPeriod = deletePeriod ? budPeriod - 1 : budPeriod + 1;
            budgetPeriod.setBudgetPeriod(newPeriod);
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem periodLineItem : budgetLineItems) {
                periodLineItem.setBudgetPeriod(newPeriod);
                List<BudgetPersonnelDetails> budgetPersonnelDetails = periodLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    budgetPersonnelDetail.setBudgetPeriod(newPeriod);
                }
            }
        }
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            for (BudgetSubAwardPeriodDetail detail : subAward.getBudgetSubAwardPeriodDetails()) {
                if (detail.getBudgetPeriod() < checkPeriod) continue;
                if (deletePeriod) {
                    detail.setBudgetPeriod(detail.getBudgetPeriod() - 1);
                    continue;
                }
                detail.setBudgetPeriod(detail.getBudgetPeriod() + 1);
            }
        }
    }

    @Override
    public void calculateBudget(Budget budget) {
        this.getBudgetCommonService(budget.getBudgetParent()).recalculateBudget(budget);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParent parentBudget) {
        return BudgetCommonServiceFactory.createInstance(parentBudget);
    }

    @Override
    public void deleteBudgetPeriod(Budget budget, int delPeriod) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        BudgetPeriod deletedPeriod = budgetPeriods.remove(delPeriod);
        this.deleteSubAwardPeriodDetails(deletedPeriod);
        this.updateBudgetPeriods(budget, budgetPeriods, delPeriod + 1, true);
    }

    protected void deleteSubAwardPeriodDetails(BudgetPeriod deletedPeriod) {
        Budget budget = deletedPeriod.getBudget();
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            Iterator<BudgetSubAwardPeriodDetail> iter = subAward.getBudgetSubAwardPeriodDetails().iterator();
            while (iter.hasNext()) {
                BudgetSubAwardPeriodDetail detail = iter.next();
                if (!Objects.equals(detail.getBudgetPeriod(), deletedPeriod.getBudgetPeriod())) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void addBudgetPeriod(Budget budget, BudgetPeriod newBudgetPeriod) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        Integer newPeriodIndex = newBudgetPeriod.getBudgetPeriod();
        int totalPeriods = budgetPeriods.size();
        if (newPeriodIndex > totalPeriods) {
            budgetPeriods.add(newBudgetPeriod);
        } else {
            this.updateBudgetPeriods(budget, budgetPeriods, newPeriodIndex, false);
            budgetPeriods.add(newPeriodIndex - 1, newBudgetPeriod);
        }
    }

    public final BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public final void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    @Override
    public void updateOnOffCampusFlag(Budget budget, String onOffCampusFlag) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetLineItems() == null) continue;
            for (BudgetLineItem periodLineItem : budgetPeriod.getBudgetLineItems()) {
                if (onOffCampusFlag.equalsIgnoreCase("D")) {
                    if (periodLineItem.getCostElementBO() == null) {
                        periodLineItem.refreshReferenceObject("costElementBO");
                    }
                    periodLineItem.setOnOffCampusFlag(periodLineItem.getCostElementBO().getOnOffCampusFlag());
                } else {
                    periodLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
                }
                for (BudgetPersonnelDetails periodPersonnelDetail : periodLineItem.getBudgetPersonnelDetailsList()) {
                    if (onOffCampusFlag.equalsIgnoreCase("D")) {
                        if (periodLineItem.getCostElementBO() == null) {
                            periodLineItem.refreshReferenceObject("costElementBO");
                        }
                        periodPersonnelDetail.setOnOffCampusFlag(periodLineItem.getCostElementBO().getOnOffCampusFlag());
                        continue;
                    }
                    periodPersonnelDetail.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
                }
            }
        }
    }

    @Override
    public void adjustStartEndDatesForLineItems(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            this.adjustStartEndDatesForLineItems(budgetPeriod);
        }
    }

    @Override
    public void adjustStartEndDatesForLineItems(BudgetPeriod budgetPeriod) {
        if (budgetPeriod.getOldStartDate() != null && budgetPeriod.getStartDate().compareTo(budgetPeriod.getOldStartDate()) != 0 || budgetPeriod.getOldEndDate() != null && budgetPeriod.getEndDate().compareTo(budgetPeriod.getOldEndDate()) != 0) {
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            this.setupOldStartEndDate(budgetLineItems);
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                ArrayList<Date> startEndDates = new ArrayList<Date>();
                startEndDates.add(0, budgetLineItem.getStartDate());
                startEndDates.add(1, budgetLineItem.getEndDate());
                this.getNewStartEndDates(budgetPeriod.getStartDate(), budgetPeriod.getOldStartDate(), budgetPeriod.getEndDate(), budgetPeriod.getOldEndDate(), startEndDates);
                Date newStartDate = (Date)startEndDates.get(0);
                Date newEndDate = (Date)startEndDates.get(1);
                budgetLineItem.setStartDate(newStartDate);
                budgetLineItem.setEndDate(newEndDate);
                budgetLineItem.setBasedOnLineItem(budgetLineItem.getLineItemNumber());
            }
            this.adjustStartEndDatesForPersonnelLineItems(budgetLineItems);
        }
        budgetPeriod.setOldStartDate(budgetPeriod.getStartDate());
        budgetPeriod.setOldEndDate(budgetPeriod.getEndDate());
    }

    protected void adjustStartEndDatesForPersonnelLineItems(List<BudgetLineItem> budgetLineItems) {
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (budgetLineItem.getOldStartDate() != null && budgetLineItem.getStartDate().compareTo(budgetLineItem.getOldStartDate()) != 0 || budgetLineItem.getOldEndDate() != null && budgetLineItem.getEndDate().compareTo(budgetLineItem.getOldEndDate()) != 0) {
                List<BudgetPersonnelDetails> budgetPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    Date newStartDate = budgetPersonnelDetail.getStartDate();
                    Date newEndDate = budgetPersonnelDetail.getEndDate();
                    ArrayList<Date> startEndDates = new ArrayList<Date>();
                    startEndDates.add(0, budgetPersonnelDetail.getStartDate());
                    startEndDates.add(1, budgetPersonnelDetail.getEndDate());
                    this.getNewStartEndDates(budgetLineItem.getStartDate(), budgetLineItem.getOldStartDate(), budgetLineItem.getEndDate(), budgetLineItem.getOldEndDate(), startEndDates);
                    newStartDate = (Date)startEndDates.get(0);
                    newEndDate = (Date)startEndDates.get(1);
                    budgetPersonnelDetail.setStartDate(newStartDate);
                    budgetPersonnelDetail.setEndDate(newEndDate);
                }
            }
            budgetLineItem.setOldStartDate(budgetLineItem.getStartDate());
            budgetLineItem.setOldEndDate(budgetLineItem.getEndDate());
        }
    }

    @Override
    public void setupOldStartEndDate(Budget budget, boolean resetAll) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getOldStartDate() != null && budgetPeriod.getOldEndDate() != null && !resetAll) continue;
            budgetPeriod.setOldStartDate(budgetPeriod.getStartDate());
            budgetPeriod.setOldEndDate(budgetPeriod.getEndDate());
        }
    }

    protected void setupOldStartEndDate(List<BudgetLineItem> budgetLineItems) {
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (budgetLineItem.getOldStartDate() != null && budgetLineItem.getOldEndDate() != null) continue;
            budgetLineItem.setOldStartDate(budgetLineItem.getStartDate());
            budgetLineItem.setOldEndDate(budgetLineItem.getEndDate());
        }
    }

    protected Date add(Date date, int days) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(new java.util.Date(date.getTime()));
        c1.add(5, days);
        return new Date(c1.getTime().getTime());
    }

    protected List<Date> getNewStartEndDates(Date parentStartDate, Date oldStartDate, Date parentEndDate, Date oldEndDate, List<Date> startEndDates) {
        Date startDate = startEndDates.get(0);
        Date endDate = startEndDates.get(1);
        Date newStartDate = startDate;
        Date newEndDate = endDate;
        if (startDate.compareTo(oldStartDate) == 0 && endDate.compareTo(oldEndDate) == 0) {
            newStartDate = parentStartDate;
            newEndDate = parentEndDate;
        } else if (parentStartDate.compareTo(oldStartDate) != 0) {
            if ((newStartDate = this.add(newStartDate, this.getDateTimeService().dateDiff((java.util.Date)oldStartDate, (java.util.Date)parentStartDate, false))).after(parentEndDate)) {
                newStartDate = parentStartDate;
            } else if (newStartDate.after(parentStartDate)) {
                int parentDuration = this.getDateTimeService().dateDiff((java.util.Date)parentStartDate, (java.util.Date)parentEndDate, false);
                int duration = this.getDateTimeService().dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false);
                int daysTOEndDate = this.getDateTimeService().dateDiff((java.util.Date)newStartDate, (java.util.Date)parentEndDate, false);
                if (daysTOEndDate < duration) {
                    if (parentDuration > duration) {
                        newEndDate = parentEndDate;
                        newStartDate = this.add(newEndDate, duration * -1);
                    } else {
                        newStartDate = parentStartDate;
                    }
                }
            }
            newEndDate = this.add(newStartDate, this.getDateTimeService().dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false));
            if (newEndDate.after(parentEndDate)) {
                newEndDate = parentEndDate;
            }
        } else if (parentEndDate.compareTo(oldStartDate) != 0 && parentEndDate.before(endDate)) {
            if (parentEndDate.after(startDate) && parentEndDate.before(endDate)) {
                newEndDate = parentEndDate;
                newStartDate = this.add(newEndDate, this.getDateTimeService().dateDiff((java.util.Date)endDate, (java.util.Date)startDate, false));
                if (newStartDate.before(parentStartDate)) {
                    newStartDate = parentStartDate;
                }
            } else if (parentEndDate.before(startDate) && (newEndDate = this.add(newStartDate = parentStartDate, this.getDateTimeService().dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false))).after(parentEndDate)) {
                newEndDate = parentEndDate;
            }
        }
        startEndDates.clear();
        startEndDates.add(0, newStartDate);
        startEndDates.add(1, newEndDate);
        return startEndDates;
    }

    @Override
    public List<Date> getNewStartEndDates(List<Date> startEndDates, int gap, int duration, Date prevDate, boolean leapDayInPeriod, boolean leapDayInGap) {
        Date startDate = startEndDates.get(0);
        Date newStartDate = this.add(startDate, gap);
        Date newEndDate = this.add(newStartDate, duration);
        boolean isLeapDayInNewPeriod = this.isLeapDaysInPeriod(startDate, newEndDate);
        boolean isLeapDayInNewGap = this.isLeapDaysInPeriod(startDate, newStartDate);
        boolean isLeapDayInInitialPeriod = leapDayInPeriod || leapDayInGap;
        boolean isLeapYearOnEndDate = this.isLeapYear(newEndDate);
        boolean isLastFebDayOnNonLeap = this.isLastFebOnNonLeap(newEndDate);
        if (isLeapDayInInitialPeriod && !isLeapDayInNewPeriod) {
            newEndDate = this.add(newEndDate, -1);
        } else if (!isLeapDayInInitialPeriod && isLeapDayInNewPeriod) {
            newEndDate = this.add(newEndDate, 1);
        } else if (isLeapYearOnEndDate && isLastFebDayOnNonLeap) {
            newEndDate = this.add(newEndDate, 1);
        }
        if (!isLeapDayInNewGap && leapDayInGap) {
            newStartDate = this.add(newStartDate, -1);
        } else if (isLeapDayInNewGap && !leapDayInGap) {
            newStartDate = this.add(newStartDate, 1);
        }
        ArrayList<Date> newStartEndDates = new ArrayList<Date>();
        newStartEndDates.add(0, newStartDate);
        newStartEndDates.add(1, newEndDate);
        return newStartEndDates;
    }

    protected boolean isLastFebOnNonLeap(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(c1.get(1), 1, 28);
        return c1.compareTo(c2) == 0;
    }

    protected boolean isLeapYear(Date date) {
        int year = this.getYear(date);
        return this.isLeapYear(year);
    }

    protected boolean isLeapYear(int year) {
        boolean isLeapYear = year % 4 == 0;
        isLeapYear = isLeapYear && year % 100 != 0;
        isLeapYear = isLeapYear || year % 400 == 0;
        return isLeapYear;
    }

    protected int getYear(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(new java.util.Date(date.getTime()));
        return c1.get(1);
    }

    @Override
    public boolean isLeapDaysInPeriod(Date sDate, Date eDate) {
        int sYear = this.getYear(sDate);
        int eYear = this.getYear(eDate);
        if (this.isLeapYear(sDate)) {
            Calendar c1 = Calendar.getInstance();
            c1.clear();
            c1.set(sYear, 1, 29);
            Date leapDate = new Date(c1.getTime().getTime());
            if (sDate.before(leapDate) ? eDate.compareTo(leapDate) >= 0 : sDate.equals(leapDate)) {
                return true;
            }
        } else if (this.isLeapYear(eDate)) {
            Calendar c1 = Calendar.getInstance();
            c1.set(eYear, 1, 29);
            Date leapDate = new Date(c1.getTime().getTime());
            if (eDate.compareTo(leapDate) >= 0) {
                return true;
            }
        } else {
            ++sYear;
            while (eYear > sYear) {
                if (this.isLeapYear(sYear)) {
                    return true;
                }
                ++sYear;
            }
        }
        return false;
    }

    @Override
    public String getOnOffCampusFlagDescription(String onOffCampusFlag) {
        String retValue = null;
        for (OnOffCampusFlagConstants onOffCampusFlagConstants : OnOffCampusFlagConstants.values()) {
            if (!onOffCampusFlagConstants.getCode().equalsIgnoreCase(onOffCampusFlag)) continue;
            retValue = onOffCampusFlagConstants.getDescription();
            break;
        }
        return retValue;
    }

    @Override
    public String defaultWarningMessage(Budget budget) {
        List<BudgetPeriod> budgetPeriods = this.generateBudgetPeriods(budget);
        boolean dateChanged = false;
        boolean deletePeriodWithLineItem = false;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() <= budgetPeriods.size()) {
                if (!CollectionUtils.isNotEmpty(budgetPeriod.getBudgetLineItems()) || budgetPeriod.getStartDate().compareTo(budgetPeriods.get(budgetPeriod.getBudgetPeriod() - 1).getStartDate()) == 0 && budgetPeriod.getEndDate().compareTo(budgetPeriods.get(budgetPeriod.getBudgetPeriod() - 1).getEndDate()) == 0) continue;
                dateChanged = true;
                continue;
            }
            if (!CollectionUtils.isNotEmpty(budgetPeriod.getBudgetLineItems())) continue;
            deletePeriodWithLineItem = true;
        }
        if (dateChanged) {
            if (deletePeriodWithLineItem) {
                return BUDGET_DATE_CHANGE_AND_DELETE_WARNING_MSG;
            }
            return BUDGET_DATE_CHANGE_WARNING_MSG;
        }
        if (deletePeriodWithLineItem) {
            return BUDGET_PERIOD_DELETE_WARNING_MSG;
        }
        return "";
    }

    @Override
    public void syncBudgetPersonSalaryDetails(Budget budget) {
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            HashSet<Integer> existingBudgetPeriods = new HashSet<Integer>();
            for (BudgetPersonSalaryDetails budgetPersonSalaryDetails : budgetPerson.getBudgetPersonSalaryDetails()) {
                existingBudgetPeriods.add(budgetPersonSalaryDetails.getBudgetPeriod());
            }
            this.addSalaryDetailsForNewBudgetPeriod(budget, budgetPerson, existingBudgetPeriods);
        }
    }

    public void addSalaryDetailsForNewBudgetPeriod(Budget budget, BudgetPerson budgetPerson, HashSet<Integer> existingBudgetPeriods) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (existingBudgetPeriods.contains(budgetPeriod.getBudgetPeriod())) continue;
            budgetPerson.getBudgetPersonSalaryDetails().add(budgetPerson.getNewBudgetPersonSalaryDetails(budgetPeriod));
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

